/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs;

import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.MultipleDataLoadersDefinedException;
import com.netflix.graphql.dgs.exceptions.NoDataLoaderFoundException;
import com.netflix.graphql.dgs.internal.utils.DataLoaderNameUtil;
import graphql.GraphQLContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.type.StandardMethodMetadata;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0001J\u0006\u0010\b\u001a\u00020\tJ\u0011\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b\u00a2\u0006\u0002\u0010\fJ*\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u000e\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\u001f\u0010\u0018\u001a\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0019\"\u00020\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u0018\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u00162\u000e\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u00140\u0014H\u0096\u0001\u00a2\u0006\u0002\u0010 J<\u0010!\u001a\u000e\u0018\u0001H\u000b\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b#\"\u0010\b\u0000\u0010\u000b*\n \u001f*\u0004\u0018\u00010$0$2\u000e\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u00140\u0014H\u0097\u0001\u00a2\u0006\u0002\u0010%JH\u0010&\u001a\n \u001f*\u0004\u0018\u0001H\u000bH\u000b\"\u0010\b\u0000\u0010\u000b*\n \u001f*\u0004\u0018\u00010$0$2\u000e\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u00140\u00142\u000e\u0010'\u001a\n \u001f*\u0004\u0018\u0001H\u000bH\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010(JN\u0010)\u001aB\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u001f*\u0004\u0018\u00010$0$ \u001f* \u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u001f*\u0004\u0018\u00010$0$\u0018\u00010+0*H\u0096\u0001\u00a2\u0006\u0002\u0010,J(\u0010-\u001a\n \u001f*\u0004\u0018\u0001H\u000bH\u000b\"\u0010\b\u0000\u0010\u000b*\n \u001f*\u0004\u0018\u00010$0$H\u0097\u0001\u00a2\u0006\u0002\u0010\fJj\u0010\r\u001a*\u0012\f\u0012\n \u001f*\u0004\u0018\u0001H\u000fH\u000f\u0012\f\u0012\n \u001f*\u0004\u0018\u0001H\u0010H\u0010\u0018\u00010\u000e\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b#\"\u0010\b\u0000\u0010\u000f*\n \u001f*\u0004\u0018\u00010$0$\"\u0010\b\u0001\u0010\u0010*\n \u001f*\u0004\u0018\u00010$0$2\u000e\u0010.\u001a\n \u001f*\u0004\u0018\u00010\u00140\u0014H\u0097\u0001\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\n \u001f*\u0004\u0018\u00010101H\u0096\u0001\u00a2\u0006\u0002\u00102J\u0016\u00103\u001a\n \u001f*\u0004\u0018\u00010404H\u0096\u0001\u00a2\u0006\u0002\u00105J\u0016\u00106\u001a\n \u001f*\u0004\u0018\u00010707H\u0096\u0001\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\n \u001f*\u0004\u0018\u00010:0:H\u0096\u0001\u00a2\u0006\u0002\u0010;J\u0016\u0010<\u001a\n \u001f*\u0004\u0018\u00010=0=H\u0096\u0001\u00a2\u0006\u0002\u0010>J\u0016\u0010?\u001a\n \u001f*\u0004\u0018\u00010@0@H\u0096\u0001\u00a2\u0006\u0002\u0010AJ\u0016\u0010B\u001a\n \u001f*\u0004\u0018\u00010C0CH\u0096\u0001\u00a2\u0006\u0002\u0010DJ2\u0010E\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010=0= \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010=0=\u0018\u00010G0FH\u0097\u0001\u00a2\u0006\u0002\u0010HJN\u0010I\u001aB\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u001f*\u0004\u0018\u00010J0J \u001f* \u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u001f*\u0004\u0018\u00010J0J\u0018\u00010+0*H\u0096\u0001\u00a2\u0006\u0002\u0010,J\u0016\u0010K\u001a\n \u001f*\u0004\u0018\u00010L0LH\u0096\u0001\u00a2\u0006\u0002\u0010MJ\u0013\u0010N\u001a\f0O\u00a2\u0006\u0002\bP\u00a2\u0006\u0002\b#H\u0097\u0001J,\u0010Q\u001a\u000e\u0018\u0001H\u000b\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b#\"\u0010\b\u0000\u0010\u000b*\n \u001f*\u0004\u0018\u00010$0$H\u0097\u0001\u00a2\u0006\u0002\u0010\fJ\u0016\u0010R\u001a\n \u001f*\u0004\u0018\u00010S0SH\u0096\u0001\u00a2\u0006\u0002\u0010TJ\u0016\u0010U\u001a\n \u001f*\u0004\u0018\u00010V0VH\u0096\u0001\u00a2\u0006\u0002\u0010WJ\u0016\u0010X\u001a\n \u001f*\u0004\u0018\u00010Y0YH\u0096\u0001\u00a2\u0006\u0002\u0010ZJ\u0016\u0010[\u001a\n \u001f*\u0004\u0018\u00010\\0\\H\u0096\u0001\u00a2\u0006\u0002\u0010]J\u0016\u0010^\u001a\n \u001f*\u0004\u0018\u00010_0_H\u0096\u0001\u00a2\u0006\u0002\u0010`J(\u0010a\u001a\n \u001f*\u0004\u0018\u0001H\u000bH\u000b\"\u0010\b\u0000\u0010\u000b*\n \u001f*\u0004\u0018\u00010$0$H\u0096\u0001\u00a2\u0006\u0002\u0010\fJ\u0016\u0010b\u001a\n \u001f*\u0004\u0018\u00010c0cH\u0096\u0001\u00a2\u0006\u0002\u0010dJ,\u0010e\u001a\u000e\u0018\u0001H\u000b\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b#\"\u0010\b\u0000\u0010\u000b*\n \u001f*\u0004\u0018\u00010$0$H\u0097\u0001\u00a2\u0006\u0002\u0010\fJN\u0010f\u001aB\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u001f*\u0004\u0018\u00010$0$ \u001f* \u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u001f*\u0004\u0018\u00010$0$\u0018\u00010+0*H\u0096\u0001\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "Lgraphql/schema/DataFetchingEnvironment;", "dfe", "ctx", "Lorg/springframework/context/ApplicationContext;", "<init>", "(Lgraphql/schema/DataFetchingEnvironment;Lorg/springframework/context/ApplicationContext;)V", "getDfe", "getDgsContext", "Lcom/netflix/graphql/dgs/context/DgsContext;", "getSourceOrThrow", "T", "()Ljava/lang/Object;", "getDataLoader", "Lorg/dataloader/DataLoader;", "K", "V", "loaderClass", "Ljava/lang/Class;", "tryGetDataLoaderFromBeanDefinition", "", "isNestedArgumentSet", "", "path", "isArgumentSet", "", "([Ljava/lang/String;)Z", "keys", "Lkotlin/sequences/Sequence;", "containsArgument", "name", "kotlin.jvm.PlatformType", "(Ljava/lang/String;)Z", "getArgument", "Lorg/jetbrains/annotations/Nullable;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "(Ljava/lang/String;)Ljava/lang/Object;", "getArgumentOrDefault", "defaultValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getArguments", "", "", "()Ljava/util/Map;", "getContext", "dataLoaderName", "(Ljava/lang/String;)Lorg/dataloader/DataLoader;", "getDataLoaderRegistry", "Lorg/dataloader/DataLoaderRegistry;", "()Lorg/dataloader/DataLoaderRegistry;", "getDocument", "Lgraphql/language/Document;", "()Lgraphql/language/Document;", "getExecutionId", "Lgraphql/execution/ExecutionId;", "()Lgraphql/execution/ExecutionId;", "getExecutionStepInfo", "Lgraphql/execution/ExecutionStepInfo;", "()Lgraphql/execution/ExecutionStepInfo;", "getField", "Lgraphql/language/Field;", "()Lgraphql/language/Field;", "getFieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "()Lgraphql/schema/GraphQLFieldDefinition;", "getFieldType", "Lgraphql/schema/GraphQLOutputType;", "()Lgraphql/schema/GraphQLOutputType;", "getFields", "", "", "()Ljava/util/List;", "getFragmentsByName", "Lgraphql/language/FragmentDefinition;", "getGraphQLSchema", "Lgraphql/schema/GraphQLSchema;", "()Lgraphql/schema/GraphQLSchema;", "getGraphQlContext", "Lgraphql/GraphQLContext;", "Lorg/jetbrains/annotations/NotNull;", "getLocalContext", "getLocale", "Ljava/util/Locale;", "()Ljava/util/Locale;", "getMergedField", "Lgraphql/execution/MergedField;", "()Lgraphql/execution/MergedField;", "getOperationDefinition", "Lgraphql/language/OperationDefinition;", "()Lgraphql/language/OperationDefinition;", "getParentType", "Lgraphql/schema/GraphQLType;", "()Lgraphql/schema/GraphQLType;", "getQueryDirectives", "Lgraphql/execution/directives/QueryDirectives;", "()Lgraphql/execution/directives/QueryDirectives;", "getRoot", "getSelectionSet", "Lgraphql/schema/DataFetchingFieldSelectionSet;", "()Lgraphql/schema/DataFetchingFieldSelectionSet;", "getSource", "getVariables", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsDataFetchingEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsDataFetchingEnvironment.kt\ncom/netflix/graphql/dgs/DgsDataFetchingEnvironment\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,118:1\n3829#2:119\n4344#2,2:120\n1557#3:122\n1628#3,3:123\n37#4:126\n36#4,3:127\n*S KotlinDebug\n*F\n+ 1 DgsDataFetchingEnvironment.kt\ncom/netflix/graphql/dgs/DgsDataFetchingEnvironment\n*L\n50#1:119\n50#1:120,2\n93#1:122\n93#1:123,3\n94#1:126\n94#1:127,3\n*E\n"})
public final class DgsDataFetchingEnvironment
implements DataFetchingEnvironment {
    @NotNull
    private final DataFetchingEnvironment dfe;
    @NotNull
    private final ApplicationContext ctx;

    public DgsDataFetchingEnvironment(@NotNull DataFetchingEnvironment dfe, @NotNull ApplicationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.dfe = dfe;
        this.ctx = ctx;
    }

    @NotNull
    public final DataFetchingEnvironment getDfe() {
        return this.dfe;
    }

    @NotNull
    public final DgsContext getDgsContext() {
        return DgsContext.Companion.from(this);
    }

    public final <T> T getSourceOrThrow() {
        T t = this.getSource();
        if (t == null) {
            throw new IllegalStateException("source is null");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <K, V> DataLoader<K, V> getDataLoader(@NotNull Class<?> loaderClass) {
        String string;
        Intrinsics.checkNotNullParameter(loaderClass, (String)"loaderClass");
        DgsDataLoader annotation = loaderClass.getAnnotation(DgsDataLoader.class);
        if (annotation != null) {
            string = DataLoaderNameUtil.INSTANCE.getDataLoaderName(loaderClass, annotation);
        } else {
            void $this$filterTo$iv$iv;
            Field[] fieldArray = loaderClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getFields(...)");
            Object[] $this$filter$iv = fieldArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!it.isAnnotationPresent(DgsDataLoader.class)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List loaders = (List)destination$iv$iv;
            if (loaders.isEmpty()) {
                string = this.tryGetDataLoaderFromBeanDefinition(loaderClass);
            } else {
                if (loaders.size() > 1) {
                    $this$filter$iv = new Class[]{loaderClass};
                    throw new MultipleDataLoadersDefinedException((Class<?>[])$this$filter$iv);
                }
                Field field = (Field)CollectionsKt.firstOrNull((List)loaders);
                if (field == null) {
                    throw new NoDataLoaderFoundException(loaderClass);
                }
                Field loaderField = field;
                DgsDataLoader theAnnotation = loaderField.getAnnotation(DgsDataLoader.class);
                string = theAnnotation.name();
            }
        }
        String loaderName = string;
        DataLoader<K, V> dataLoader = this.getDataLoader(loaderName);
        if (dataLoader == null) {
            throw new NoDataLoaderFoundException("DataLoader with name " + loaderName + " not found");
        }
        return dataLoader;
    }

    private final String tryGetDataLoaderFromBeanDefinition(Class<?> loaderClass) {
        String name = loaderClass.getSimpleName();
        if (this.ctx instanceof ConfigurableApplicationContext) {
            Map beansOfType = ((ConfigurableApplicationContext)this.ctx).getBeanFactory().getBeansOfType(loaderClass);
            if (beansOfType.isEmpty()) {
                throw new NoDataLoaderFoundException(loaderClass);
            }
            if (beansOfType.size() > 1) {
                Class[] classArray = new Class[]{loaderClass};
                throw new MultipleDataLoadersDefinedException(classArray);
            }
            String beanName = (String)CollectionsKt.first((Iterable)beansOfType.keySet());
            BeanDefinition beanDefinition = ((ConfigurableApplicationContext)this.ctx).getBeanFactory().getBeanDefinition(beanName);
            if (beanDefinition.getSource() instanceof StandardMethodMetadata) {
                Object object = beanDefinition.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.springframework.core.type.StandardMethodMetadata");
                StandardMethodMetadata methodMetadata = (StandardMethodMetadata)object;
                Method method = methodMetadata.getIntrospectedMethod();
                DgsDataLoader methodAnnotation = method.getAnnotation(DgsDataLoader.class);
                Intrinsics.checkNotNull((Object)methodAnnotation);
                name = DataLoaderNameUtil.INSTANCE.getDataLoaderName(loaderClass, methodAnnotation);
            }
        }
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isNestedArgumentSet(@NotNull String path) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] stringArray = new String[]{".", "->"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void s;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)s))).toString());
        }
        List pathParts = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = pathParts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        return this.isArgumentSet(Arrays.copyOf(stringArray, stringArray.length));
    }

    public final boolean isArgumentSet(String ... path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.isArgumentSet((Sequence<String>)ArraysKt.asSequence((Object[])path));
    }

    private final boolean isArgumentSet(Sequence<String> keys) {
        Map map = this.dfe.getExecutionStepInfo().getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        Map args = map;
        Object value = null;
        for (String key : keys) {
            if (!args.containsKey(key)) {
                return false;
            }
            value = args.get(key);
            if (!(value instanceof Map)) {
                return true;
            }
            args = value;
        }
        return true;
    }

    @Nullable
    public <T> T getSource() {
        return (T)this.dfe.getSource();
    }

    public Map<String, Object> getArguments() {
        return this.dfe.getArguments();
    }

    public boolean containsArgument(String name) {
        return this.dfe.containsArgument(name);
    }

    @Nullable
    public <T> T getArgument(String name) {
        return (T)this.dfe.getArgument(name);
    }

    public <T> T getArgumentOrDefault(String name, T defaultValue) {
        return (T)this.dfe.getArgumentOrDefault(name, defaultValue);
    }

    @Deprecated(message="Deprecated in Java")
    public <T> T getContext() {
        return (T)this.dfe.getContext();
    }

    @NotNull
    public GraphQLContext getGraphQlContext() {
        GraphQLContext graphQLContext = this.dfe.getGraphQlContext();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLContext, (String)"getGraphQlContext(...)");
        return graphQLContext;
    }

    @Nullable
    public <T> T getLocalContext() {
        return (T)this.dfe.getLocalContext();
    }

    public <T> T getRoot() {
        return (T)this.dfe.getRoot();
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.dfe.getFieldDefinition();
    }

    @Deprecated(message="Deprecated in Java")
    public List<graphql.language.Field> getFields() {
        return this.dfe.getFields();
    }

    public MergedField getMergedField() {
        return this.dfe.getMergedField();
    }

    public graphql.language.Field getField() {
        return this.dfe.getField();
    }

    public GraphQLOutputType getFieldType() {
        return this.dfe.getFieldType();
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.dfe.getExecutionStepInfo();
    }

    public GraphQLType getParentType() {
        return this.dfe.getParentType();
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.dfe.getGraphQLSchema();
    }

    public Map<String, FragmentDefinition> getFragmentsByName() {
        return this.dfe.getFragmentsByName();
    }

    public ExecutionId getExecutionId() {
        return this.dfe.getExecutionId();
    }

    public DataFetchingFieldSelectionSet getSelectionSet() {
        return this.dfe.getSelectionSet();
    }

    public QueryDirectives getQueryDirectives() {
        return this.dfe.getQueryDirectives();
    }

    @Nullable
    public <K, V> DataLoader<K, V> getDataLoader(String dataLoaderName) {
        return this.dfe.getDataLoader(dataLoaderName);
    }

    public DataLoaderRegistry getDataLoaderRegistry() {
        return this.dfe.getDataLoaderRegistry();
    }

    public Locale getLocale() {
        return this.dfe.getLocale();
    }

    public OperationDefinition getOperationDefinition() {
        return this.dfe.getOperationDefinition();
    }

    public Document getDocument() {
        return this.dfe.getDocument();
    }

    public Map<String, Object> getVariables() {
        return this.dfe.getVariables();
    }
}

