/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.exceptions;

import com.netflix.graphql.dgs.exceptions.DgsException;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.language.SourceLocation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.ClassUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u0014\u0010\u0012\u001a\u00020\u00138DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "<init>", "()V", "handleException", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "doHandleException", "logException", "", "error", "Lgraphql/GraphQLError;", "exception", "", "unwrapCompletionException", "e", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "Companion", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDefaultDataFetcherExceptionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDataFetcherExceptionHandler.kt\ncom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public class DefaultDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    private static final boolean springSecurityAvailable;

    @NotNull
    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        CompletableFuture<DataFetcherExceptionHandlerResult> completableFuture = CompletableFuture.completedFuture(this.doHandleException(handlerParameters));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    private final DataFetcherExceptionHandlerResult doHandleException(DataFetcherExceptionHandlerParameters handlerParameters) {
        TypedGraphQLError typedGraphQLError;
        Throwable throwable = handlerParameters.getException();
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getException(...)");
        Throwable exception = this.unwrapCompletionException(throwable);
        if (exception instanceof DgsException) {
            typedGraphQLError = ((DgsException)exception).toGraphQlError(handlerParameters.getPath());
        } else {
            TypedGraphQLError.Builder builder = springSecurityAvailable && DefaultDataFetcherExceptionHandler.Companion.isSpringSecurityAccessException(exception) ? TypedGraphQLError.newPermissionDeniedBuilder() : TypedGraphQLError.newInternalErrorBuilder();
            builder.message(exception.getClass().getName() + ": " + exception.getMessage()).path(handlerParameters.getPath());
            SourceLocation sourceLocation = handlerParameters.getSourceLocation();
            if (sourceLocation != null) {
                SourceLocation it = sourceLocation;
                boolean bl = false;
                builder.location(it);
            }
            typedGraphQLError = builder.build();
        }
        TypedGraphQLError graphqlError = typedGraphQLError;
        Intrinsics.checkNotNull((Object)graphqlError);
        this.logException(handlerParameters, (GraphQLError)graphqlError, exception);
        DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)graphqlError).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherExceptionHandlerResult, (String)"build(...)");
        return dataFetcherExceptionHandlerResult;
    }

    protected void logException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters, @NotNull GraphQLError error, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Level logLevel = exception instanceof DgsException ? ((DgsException)exception).getLogLevel() : Level.ERROR;
        this.getLogger().atLevel(logLevel).setCause(exception).log("Exception while executing data fetcher for {}: {}", (Object)handlerParameters.getPath(), (Object)exception.getMessage());
    }

    private final Throwable unwrapCompletionException(Throwable e) {
        Throwable throwable;
        if (e instanceof CompletionException && e.getCause() != null) {
            Throwable throwable2 = e.getCause();
            throwable = throwable2;
            Intrinsics.checkNotNull((Object)throwable2);
        } else {
            throwable = e;
        }
        return throwable;
    }

    @NotNull
    protected final Logger getLogger() {
        return logger;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDataFetcherExceptionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DefaultDataFetcherExceptionHandler.logger = logger;
        springSecurityAvailable = ClassUtils.isPresent((String)"org.springframework.security.access.AccessDeniedException", (ClassLoader)DefaultDataFetcherExceptionHandler.class.getClassLoader());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "springSecurityAvailable", "", "isSpringSecurityAccessException", "exception", "", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSpringSecurityAccessException(Throwable exception) {
            try {
                return exception instanceof AccessDeniedException;
            }
            catch (Throwable e) {
                logger.trace("Unable to verify if {} is a Spring Security's AccessDeniedException.", (Object)exception, (Object)e);
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

