/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.federation;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.exceptions.InvalidDgsEntityFetcher;
import com.netflix.graphql.dgs.exceptions.MissingDgsEntityFetcherException;
import com.netflix.graphql.dgs.exceptions.MissingFederatedQueryArgument;
import com.netflix.graphql.dgs.internal.EntityFetcherRegistry;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.GraphQLContext;
import graphql.TypeResolutionEnvironment;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ResultPath;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.GraphQLObjectType;
import graphql.schema.TypeResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.Try;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 52\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0002\u0010\u000bJ\u0010\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aH\u0016Jb\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001b0\u001e2 \u0010#\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0$\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030%0\u001e2\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'H\u0002J$\u0010(\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0$0*0)2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u000302\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\b\u00103\u001a\u000204H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver;", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "<init>", "()V", "entityFetcherRegistry", "Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "dataFetcherExceptionHandler", "Ljava/util/Optional;", "Lgraphql/execution/DataFetcherExceptionHandler;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;Ljava/util/Optional;Lorg/springframework/context/ApplicationContext;)V", "getEntityFetcherRegistry", "()Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "setEntityFetcherRegistry", "(Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;)V", "dgsExceptionHandler", "getDgsExceptionHandler", "()Ljava/util/Optional;", "setDgsExceptionHandler", "(Ljava/util/Optional;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "setApplicationContext", "(Lorg/springframework/context/ApplicationContext;)V", "entitiesDataFetcher", "Lgraphql/schema/DataFetcher;", "", "entitiesFetcher", "valuesWithMappedScalars", "", "", "graphQLContext", "Lgraphql/GraphQLContext;", "values", "scalarMappings", "", "Lgraphql/schema/Coercing;", "currentPath", "", "dgsEntityFetchers", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/execution/DataFetcherResult;", "env", "Lgraphql/schema/DataFetchingEnvironment;", "createDataFetchingEnvironmentWithPath", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "pathIndex", "", "typeMapping", "Ljava/lang/Class;", "typeResolver", "Lgraphql/schema/TypeResolver;", "Companion", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDefaultDgsFederationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDgsFederationResolver.kt\ncom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,264:1\n462#2:265\n412#2:266\n1246#3,4:267\n1557#3:271\n1628#3,3:272\n37#4:275\n36#4,3:276\n12567#5,2:279\n*S KotlinDebug\n*F\n+ 1 DefaultDgsFederationResolver.kt\ncom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver\n*L\n92#1:265\n92#1:266\n92#1:267,4\n118#1:271\n118#1:272,3\n173#1:275\n173#1:276,3\n129#1:279,2\n*E\n"})
public class DefaultDgsFederationResolver
implements DgsFederationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Autowired
    public EntityFetcherRegistry entityFetcherRegistry;
    @Autowired
    public Optional<DataFetcherExceptionHandler> dgsExceptionHandler;
    @Autowired
    public ApplicationContext applicationContext;
    @NotNull
    private final DataFetcher<Object> entitiesDataFetcher;
    @NotNull
    private static final Logger logger;

    public DefaultDgsFederationResolver() {
        this.entitiesDataFetcher = arg_0 -> DefaultDgsFederationResolver.entitiesDataFetcher$lambda$0(this, arg_0);
    }

    public DefaultDgsFederationResolver(@NotNull EntityFetcherRegistry entityFetcherRegistry, @NotNull Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"entityFetcherRegistry");
        Intrinsics.checkNotNullParameter(dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this();
        this.setEntityFetcherRegistry(entityFetcherRegistry);
        this.setDgsExceptionHandler(dataFetcherExceptionHandler);
        this.setApplicationContext(applicationContext);
    }

    @NotNull
    public final EntityFetcherRegistry getEntityFetcherRegistry() {
        EntityFetcherRegistry entityFetcherRegistry = this.entityFetcherRegistry;
        if (entityFetcherRegistry != null) {
            return entityFetcherRegistry;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"entityFetcherRegistry");
        return null;
    }

    public final void setEntityFetcherRegistry(@NotNull EntityFetcherRegistry entityFetcherRegistry) {
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"<set-?>");
        this.entityFetcherRegistry = entityFetcherRegistry;
    }

    @NotNull
    public final Optional<DataFetcherExceptionHandler> getDgsExceptionHandler() {
        Optional<DataFetcherExceptionHandler> optional = this.dgsExceptionHandler;
        if (optional != null) {
            return optional;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dgsExceptionHandler");
        return null;
    }

    public final void setDgsExceptionHandler(@NotNull Optional<DataFetcherExceptionHandler> optional) {
        Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
        this.dgsExceptionHandler = optional;
    }

    @NotNull
    public final ApplicationContext getApplicationContext() {
        ApplicationContext applicationContext = this.applicationContext;
        if (applicationContext != null) {
            return applicationContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
        return null;
    }

    public final void setApplicationContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"<set-?>");
        this.applicationContext = applicationContext;
    }

    @Override
    @NotNull
    public DataFetcher<Object> entitiesFetcher() {
        return this.entitiesDataFetcher;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> valuesWithMappedScalars(GraphQLContext graphQLContext, Map<String, ? extends Object> values, Map<List<String>, ? extends Coercing<?, ?>> scalarMappings, List<String> currentPath) {
        void $this$mapValuesTo$iv$iv;
        Map<String, ? extends Object> $this$mapValues$iv = values;
        boolean $i$f$mapValues = false;
        Map<String, ? extends Object> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Object object;
            Object object2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String key = (String)entry2.getKey();
            Object value = entry2.getValue();
            ((Collection)currentPath).add(key);
            Coercing<?, ?> converter = scalarMappings.get(currentPath);
            if (converter != null) {
                object2 = converter.parseValue(value, graphQLContext, Locale.getDefault());
            } else if (value instanceof Map) {
                Map cfr_ignored_0 = (Map)value;
                object2 = this.valuesWithMappedScalars(graphQLContext, (Map)value, scalarMappings, currentPath);
            } else {
                object2 = value;
            }
            Object newValue = object2;
            CollectionsKt.removeLast(currentPath);
            Intrinsics.checkNotNull(newValue);
            map3.put(k, object);
        }
        return destination$iv$iv;
    }

    static /* synthetic */ Map valuesWithMappedScalars$default(DefaultDgsFederationResolver defaultDgsFederationResolver, GraphQLContext graphQLContext, Map map, Map map2, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: valuesWithMappedScalars");
        }
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        return defaultDgsFederationResolver.valuesWithMappedScalars(graphQLContext, map, map2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<DataFetcherResult<List<Object>>> dgsEntityFetchers(DataFetchingEnvironment env) {
        void $this$mapTo$iv$iv;
        List list = (List)env.getArgument("representations");
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void values;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CompletableFuture)Try.tryCall(() -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$7$lambda$3((Map)values, this, env)).map(arg_0 -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$7$lambda$5(DefaultDgsFederationResolver::dgsEntityFetchers$lambda$7$lambda$4, arg_0)).recover(DefaultDgsFederationResolver::dgsEntityFetchers$lambda$7$lambda$6).get());
        }
        List resultList = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = resultList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletionStage completionStage = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenApply(arg_0 -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$16(arg_0 -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$15(resultList, this, env, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public DgsDataFetchingEnvironment createDataFetchingEnvironmentWithPath(@NotNull DataFetchingEnvironment env, int pathIndex) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        ResultPath pathWithIndex = env.getExecutionStepInfo().getPath().segment(pathIndex);
        ExecutionStepInfo executionStepInfoWithPath = ExecutionStepInfo.newExecutionStepInfo((ExecutionStepInfo)env.getExecutionStepInfo()).path(pathWithIndex).build();
        DataFetchingEnvironment dfe = env instanceof DgsDataFetchingEnvironment ? ((DgsDataFetchingEnvironment)env).getDfe() : env;
        DataFetchingEnvironment dataFetchingEnvironment = DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)dfe).executionStepInfo(executionStepInfoWithPath).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetchingEnvironment, (String)"build(...)");
        return new DgsDataFetchingEnvironment(dataFetchingEnvironment, this.getApplicationContext());
    }

    @NotNull
    public Map<Class<?>, String> typeMapping() {
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public TypeResolver typeResolver() {
        return arg_0 -> DefaultDgsFederationResolver.typeResolver$lambda$17(this, arg_0);
    }

    private static final Object entitiesDataFetcher$lambda$0(DefaultDgsFederationResolver this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNull((Object)env);
        return this$0.dgsEntityFetchers(env);
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$7$lambda$3(Map $values, DefaultDgsFederationResolver this$0, DataFetchingEnvironment $env) {
        Object result;
        Object[] objectArray;
        Map coercedValues;
        boolean bl;
        Object[] parameterTypes;
        Method method;
        Object target;
        Object typename;
        block9: {
            Object v = $values.get("__typename");
            if (v == null) {
                String[] stringArray = new String[]{"__typename"};
                throw new MissingFederatedQueryArgument(stringArray);
            }
            typename = v;
            Pair<Object, Method> pair = this$0.getEntityFetcherRegistry().getEntityFetchers().get(typename);
            if (pair == null) {
                throw new MissingDgsEntityFetcherException(typename.toString());
            }
            Pair<Object, Method> pair2 = pair;
            target = pair2.component1();
            method = (Method)pair2.component2();
            parameterTypes = method.getParameterTypes();
            Intrinsics.checkNotNull(parameterTypes);
            Object[] $this$any$iv = parameterTypes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Class<Map> element$iv;
                Class<Map> it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!it.isAssignableFrom(Map.class)) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (!bl) {
            throw new InvalidDgsEntityFetcher("@DgsEntityFetcher " + target.getClass().getName() + "." + method.getName() + " is invalid. A DgsEntityFetcher must accept an argument of type Map<String, Object>");
        }
        if (this$0.getEntityFetcherRegistry().getEntityFetcherInputMappings().get(typename) != null) {
            GraphQLContext graphQLContext = $env.getGraphQlContext();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLContext, (String)"getGraphQlContext(...)");
            Map<List<String>, Coercing<?, ?>> map = this$0.getEntityFetcherRegistry().getEntityFetcherInputMappings().get(typename);
            Intrinsics.checkNotNull(map);
            v5 = DefaultDgsFederationResolver.valuesWithMappedScalars$default(this$0, graphQLContext, $values, map, null, 8, null);
        } else {
            v5 = coercedValues = $values;
        }
        if (((Class)ArraysKt.last((Object[])parameterTypes)).isAssignableFrom(DgsDataFetchingEnvironment.class)) {
            objectArray = new Object[]{coercedValues, new DgsDataFetchingEnvironment($env, this$0.getApplicationContext())};
            v6 = ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])objectArray);
        } else {
            objectArray = new Object[]{coercedValues};
            v6 = result = ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])objectArray);
        }
        if (result == null) {
            logger.error("@DgsEntityFetcher returned null for type: {}", typename);
            CompletableFuture.completedFuture(null);
        }
        return (objectArray = result) instanceof CompletionStage ? ((CompletionStage)result).toCompletableFuture() : (objectArray instanceof Mono ? ((Mono)result).toFuture() : CompletableFuture.completedFuture(result));
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$7$lambda$4(CompletableFuture tryFuture) {
        return Try.tryFuture((CompletionStage)tryFuture);
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$7$lambda$6(Throwable exception) {
        return CompletableFuture.completedFuture(Try.failed((Throwable)exception));
    }

    private static final Try dgsEntityFetchers$lambda$15$lambda$8(CompletableFuture it) {
        return (Try)it.join();
    }

    private static final Object dgsEntityFetchers$lambda$15$lambda$9(Try tryResult) {
        return tryResult.orElse(null);
    }

    private static final Sequence dgsEntityFetchers$lambda$15$lambda$10(Object r) {
        Sequence sequence;
        if (r instanceof Collection) {
            sequence = CollectionsKt.asSequence((Iterable)((Iterable)r));
        } else {
            Object[] objectArray = new Object[]{r};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        }
        return sequence;
    }

    private static final Pair dgsEntityFetchers$lambda$15$lambda$11(int index, Try tryResult) {
        return TuplesKt.to((Object)index, (Object)tryResult);
    }

    private static final boolean dgsEntityFetchers$lambda$15$lambda$12(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        Try tryResult = (Try)pair.component2();
        return tryResult.isFailure();
    }

    private static final Pair dgsEntityFetchers$lambda$15$lambda$13(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        int index = ((Number)pair.component1()).intValue();
        Try tryResult = (Try)pair.component2();
        return TuplesKt.to((Object)index, (Object)tryResult.getThrowable());
    }

    private static final Sequence dgsEntityFetchers$lambda$15$lambda$14(DefaultDgsFederationResolver this$0, DataFetchingEnvironment $env, Pair pair) {
        Sequence sequence;
        Throwable exception;
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        int idx = ((Number)pair.component1()).intValue();
        Throwable exc = (Throwable)pair.component2();
        if (exc instanceof InvocationTargetException) {
            v0 = ((InvocationTargetException)exc).getTargetException();
        } else if (exc instanceof CompletionException && ((CompletionException)exc).getCause() != null) {
            Throwable throwable = ((CompletionException)exc).getCause();
            v0 = throwable;
            Intrinsics.checkNotNull((Object)throwable);
        } else {
            v0 = exception = exc;
        }
        if (this$0.getDgsExceptionHandler().isPresent()) {
            DgsDataFetchingEnvironment dfeWithErrorPath = this$0.createDataFetchingEnvironmentWithPath($env, idx);
            CompletableFuture res = this$0.getDgsExceptionHandler().get().handleException(DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment((DataFetchingEnvironment)dfeWithErrorPath).exception(exception).build());
            List list = ((DataFetcherExceptionHandlerResult)res.join()).getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrors(...)");
            sequence = CollectionsKt.asSequence((Iterable)list);
        } else {
            Object[] objectArray = new TypedGraphQLError[1];
            Object[] objectArray2 = new Object[]{"/_entities", idx};
            objectArray[0] = TypedGraphQLError.newInternalErrorBuilder().message(exception.getClass().getName() + ": " + exception.getMessage()).path(ResultPath.fromList((List)CollectionsKt.listOf((Object[])objectArray2))).build();
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        }
        return sequence;
    }

    private static final DataFetcherResult dgsEntityFetchers$lambda$15(List $resultList, DefaultDgsFederationResolver this$0, DataFetchingEnvironment $env, Void it) {
        Sequence trySequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$resultList), DefaultDgsFederationResolver::dgsEntityFetchers$lambda$15$lambda$8);
        return DataFetcherResult.newResult().data((Object)SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)trySequence, DefaultDgsFederationResolver::dgsEntityFetchers$lambda$15$lambda$9), DefaultDgsFederationResolver::dgsEntityFetchers$lambda$15$lambda$10))).errors(SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapIndexed((Sequence)trySequence, DefaultDgsFederationResolver::dgsEntityFetchers$lambda$15$lambda$11), DefaultDgsFederationResolver::dgsEntityFetchers$lambda$15$lambda$12), DefaultDgsFederationResolver::dgsEntityFetchers$lambda$15$lambda$13), arg_0 -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$15$lambda$14(this$0, $env, arg_0)))).build();
    }

    private static final DataFetcherResult dgsEntityFetchers$lambda$16(Function1 $tmp0, Object p0) {
        return (DataFetcherResult)$tmp0.invoke(p0);
    }

    private static final GraphQLObjectType typeResolver$lambda$17(DefaultDgsFederationResolver this$0, TypeResolutionEnvironment env) {
        Object object = env.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
        Object src = object;
        String typeName = this$0.typeMapping().containsKey(src.getClass()) ? this$0.typeMapping().get(src.getClass()) : src.getClass().getSimpleName();
        GraphQLObjectType type = env.getSchema().getObjectType(typeName);
        if (type == null) {
            logger.warn("No type definition found for {}. You probably need to provide either a type mapping,or override DefaultDgsFederationResolver.typeResolver().Alternatively make sure the type name in the schema and your Java model match", (Object)src.getClass().getName());
        }
        return type;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDgsFederationResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DefaultDgsFederationResolver.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

