/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.internal.DgsWebMvcRequestData;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.context.request.WebRequest;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB-\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0012\b\u0002\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "", "dgsCustomContextBuilder", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "dgsCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilderWithRequest;", "<init>", "(Ljava/util/Optional;Ljava/util/Optional;)V", "build", "Lcom/netflix/graphql/dgs/context/DgsContext;", "dgsRequestData", "Lcom/netflix/graphql/dgs/internal/DgsWebMvcRequestData;", "buildDgsContext", "Companion", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDefaultDgsGraphQLContextBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDgsGraphQLContextBuilder.kt\ncom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,89:1\n95#2:90\n135#2,3:91\n*S KotlinDebug\n*F\n+ 1 DefaultDgsGraphQLContextBuilder.kt\ncom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder\n*L\n34#1:90\n34#1:91,3\n*E\n"})
public class DefaultDgsGraphQLContextBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder;
    @NotNull
    private final Optional<DgsCustomContextBuilderWithRequest<?>> dgsCustomContextBuilderWithRequest;
    @NotNull
    private static final Logger logger;

    public DefaultDgsGraphQLContextBuilder(@NotNull Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder, @NotNull Optional<DgsCustomContextBuilderWithRequest<?>> dgsCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilder, (String)"dgsCustomContextBuilder");
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilderWithRequest, (String)"dgsCustomContextBuilderWithRequest");
        this.dgsCustomContextBuilder = dgsCustomContextBuilder;
        this.dgsCustomContextBuilderWithRequest = dgsCustomContextBuilderWithRequest;
    }

    public /* synthetic */ DefaultDgsGraphQLContextBuilder(Optional optional, Optional optional2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            optional2 = Optional.empty();
        }
        this(optional, optional2);
    }

    @NotNull
    public final DgsContext build(@NotNull DgsWebMvcRequestData dgsRequestData) {
        Intrinsics.checkNotNullParameter((Object)dgsRequestData, (String)"dgsRequestData");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        DgsContext result$iv$iv = this.buildDgsContext(dgsRequestData);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        DgsContext context = (DgsContext)timedValue.component1();
        long elapsed = timedValue.component2-UwyO8pc();
        logger.debug("Created DGS context in {}ms", (Object)Duration.getInWholeMilliseconds-impl((long)elapsed));
        return context;
    }

    private final DgsContext buildDgsContext(DgsWebMvcRequestData dgsRequestData) {
        DgsWebMvcRequestData dgsWebMvcRequestData;
        if (this.dgsCustomContextBuilderWithRequest.isPresent()) {
            DgsWebMvcRequestData dgsWebMvcRequestData2;
            Object object = dgsRequestData;
            if (object == null || (object = ((DgsWebMvcRequestData)object).getExtensions()) == null) {
                object = MapsKt.emptyMap();
            }
            if ((dgsWebMvcRequestData2 = dgsRequestData) == null || (dgsWebMvcRequestData2 = dgsWebMvcRequestData2.getHeaders()) == null) {
                dgsWebMvcRequestData2 = new HttpHeaders();
            }
            DgsWebMvcRequestData dgsWebMvcRequestData3 = dgsRequestData;
            dgsWebMvcRequestData = this.dgsCustomContextBuilderWithRequest.get().build((Map<String, Object>)object, HttpHeaders.readOnlyHttpHeaders((HttpHeaders)dgsWebMvcRequestData2), (WebRequest)(dgsWebMvcRequestData3 != null ? dgsWebMvcRequestData3.getWebRequest() : null));
        } else {
            dgsWebMvcRequestData = this.dgsCustomContextBuilder.isPresent() ? this.dgsCustomContextBuilder.get().build() : dgsRequestData;
        }
        DgsWebMvcRequestData customContext = dgsWebMvcRequestData;
        return new DgsContext(customContext, dgsRequestData);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDgsGraphQLContextBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DefaultDgsGraphQLContextBuilder.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

