/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.types.errors.ErrorDetail;
import com.netflix.graphql.types.errors.ErrorType;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.ErrorClassification;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.SerializationError;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/netflix/graphql/dgs/internal/GraphQLJavaErrorInstrumentation;", "Lgraphql/execution/instrumentation/SimplePerformantInstrumentation;", "<init>", "()V", "instrumentExecutionResult", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/ExecutionResult;", "executionResult", "parameters", "Lgraphql/execution/instrumentation/parameters/InstrumentationExecutionParameters;", "state", "Lgraphql/execution/instrumentation/InstrumentationState;", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nGraphQLJavaErrorInstrumentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLJavaErrorInstrumentation.kt\ncom/netflix/graphql/dgs/internal/GraphQLJavaErrorInstrumentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1863#2,2:87\n*S KotlinDebug\n*F\n+ 1 GraphQLJavaErrorInstrumentation.kt\ncom/netflix/graphql/dgs/internal/GraphQLJavaErrorInstrumentation\n*L\n26#1:87,2\n*E\n"})
public final class GraphQLJavaErrorInstrumentation
extends SimplePerformantInstrumentation {
    @NotNull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(@NotNull ExecutionResult executionResult, @Nullable InstrumentationExecutionParameters parameters, @Nullable InstrumentationState state) {
        Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
        List list = executionResult.getErrors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrors(...)");
        if (!((Collection)list).isEmpty()) {
            ExecutionResult.Builder newExecutionResult = ExecutionResult.newExecutionResult().from(executionResult);
            List graphqlErrors = new ArrayList();
            List list2 = executionResult.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getErrors(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                GraphQLError error = (GraphQLError)element$iv;
                boolean bl2 = false;
                Map map = error.getExtensions() != null ? error.getExtensions() : MapsKt.emptyMap();
                Intrinsics.checkNotNull((Object)map);
                Map extensions = MapsKt.toMutableMap((Map)map);
                if (!extensions.containsKey("classification") && error.getErrorType() != null) {
                    ErrorClassification errorClassification = error.getErrorType();
                    extensions.put("classification", errorClassification.toSpecification(error));
                }
                if (error.getErrorType() == graphql.ErrorType.ValidationError || error.getErrorType() == graphql.ErrorType.InvalidSyntax || error.getErrorType() == graphql.ErrorType.NullValueInNonNullableField || error.getErrorType() == graphql.ErrorType.OperationNotSupported || error.getErrorType() == graphql.ErrorType.ExecutionAborted) {
                    List path = error instanceof ValidationError ? ((ValidationError)error).getQueryPath() : error.getPath();
                    TypedGraphQLError.Builder graphqlErrorBuilder = TypedGraphQLError.newBadRequestBuilder().locations(error.getLocations()).path(path).message(error.getMessage()).extensions(extensions);
                    if (error instanceof ValidationError) {
                        TypedGraphQLError.Builder builder = ((ValidationError)error).getValidationErrorType() == ValidationErrorType.FieldUndefined ? graphqlErrorBuilder.errorDetail((ErrorDetail)ErrorDetail.Common.FIELD_NOT_FOUND) : graphqlErrorBuilder.errorDetail((ErrorDetail)ErrorDetail.Common.INVALID_ARGUMENT);
                    }
                    if (error.getErrorType() == graphql.ErrorType.OperationNotSupported) {
                        graphqlErrorBuilder.errorDetail((ErrorDetail)ErrorDetail.Common.INVALID_ARGUMENT);
                    }
                    TypedGraphQLError typedGraphQLError = graphqlErrorBuilder.build();
                    Intrinsics.checkNotNullExpressionValue((Object)typedGraphQLError, (String)"build(...)");
                    bl = graphqlErrors.add(typedGraphQLError);
                    continue;
                }
                if (error.getErrorType() == graphql.ErrorType.DataFetchingException) {
                    TypedGraphQLError.Builder graphqlErrorBuilder = TypedGraphQLError.newBuilder().errorType(ErrorType.INTERNAL).errorDetail((ErrorDetail)ErrorDetail.Common.SERVICE_ERROR).locations(error.getLocations()).message(error.getMessage()).extensions(error.getExtensions());
                    if (error instanceof SerializationError) {
                        graphqlErrorBuilder.errorDetail((ErrorDetail)ErrorDetail.Common.SERIALIZATION_ERROR);
                    }
                    if (error.getPath() != null) {
                        graphqlErrorBuilder.path(error.getPath());
                    }
                    TypedGraphQLError typedGraphQLError = graphqlErrorBuilder.build();
                    Intrinsics.checkNotNullExpressionValue((Object)typedGraphQLError, (String)"build(...)");
                    bl = graphqlErrors.add(typedGraphQLError);
                    continue;
                }
                Intrinsics.checkNotNull((Object)error);
                bl = graphqlErrors.add(error);
            }
            CompletableFuture<ExecutionResult> completableFuture = CompletableFuture.completedFuture(newExecutionResult.errors(graphqlErrors).build());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture completableFuture = super.instrumentExecutionResult(executionResult, parameters, state);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"instrumentExecutionResult(...)");
        return completableFuture;
    }
}

