/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.method;

import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.MethodParameter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/internal/method/ArgumentResolverComposite;", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "argumentResolvers", "", "<init>", "(Ljava/util/List;)V", "argumentResolverCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/springframework/core/MethodParameter;", "supportsParameter", "", "parameter", "resolveArgument", "", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "getArgumentResolver", "getArgumentResolver$graphql_dgs", "graphql-dgs"})
public final class ArgumentResolverComposite
implements ArgumentResolver {
    @NotNull
    private final List<ArgumentResolver> argumentResolvers;
    @NotNull
    private final ConcurrentMap<MethodParameter, ArgumentResolver> argumentResolverCache;

    public ArgumentResolverComposite(@NotNull List<? extends ArgumentResolver> argumentResolvers) {
        Intrinsics.checkNotNullParameter(argumentResolvers, (String)"argumentResolvers");
        this.argumentResolvers = argumentResolvers;
        this.argumentResolverCache = new ConcurrentHashMap();
    }

    @Override
    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return this.getArgumentResolver$graphql_dgs(parameter) != null;
    }

    @Override
    @Nullable
    public Object resolveArgument(@NotNull MethodParameter parameter, @NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ArgumentResolver argumentResolver = this.getArgumentResolver$graphql_dgs(parameter);
        if (argumentResolver == null) {
            throw new IllegalArgumentException("Unsupported parameter type [" + parameter.getParameterType().getName() + "]. supportsParameter should be called first.");
        }
        ArgumentResolver resolver = argumentResolver;
        return resolver.resolveArgument(parameter, dfe);
    }

    @Nullable
    public final ArgumentResolver getArgumentResolver$graphql_dgs(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        ArgumentResolver cachedResolver = (ArgumentResolver)this.argumentResolverCache.get(parameter);
        if (cachedResolver != null) {
            return cachedResolver;
        }
        for (ArgumentResolver resolver : this.argumentResolvers) {
            if (!resolver.supportsParameter(parameter)) continue;
            ((Map)this.argumentResolverCache).put(parameter, resolver);
            return resolver;
        }
        return null;
    }
}

