/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.method;

import com.netflix.graphql.dgs.internal.InputObjectMapper;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.KotlinDetector;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/graphql/dgs/internal/method/InputObjectMapperConverter;", "Lorg/springframework/core/convert/converter/ConditionalGenericConverter;", "inputObjectMapper", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "<init>", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "getConvertibleTypes", "", "Lorg/springframework/core/convert/converter/GenericConverter$ConvertiblePair;", "matches", "", "sourceType", "Lorg/springframework/core/convert/TypeDescriptor;", "targetType", "convert", "", "source", "graphql-dgs"})
public final class InputObjectMapperConverter
implements ConditionalGenericConverter {
    @NotNull
    private final InputObjectMapper inputObjectMapper;

    public InputObjectMapperConverter(@NotNull InputObjectMapper inputObjectMapper) {
        Intrinsics.checkNotNullParameter((Object)inputObjectMapper, (String)"inputObjectMapper");
        this.inputObjectMapper = inputObjectMapper;
    }

    @NotNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return SetsKt.setOf((Object)new GenericConverter.ConvertiblePair(Map.class, Object.class));
    }

    public boolean matches(@NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        return sourceType.isMap() && !targetType.isMap() && !targetType.getType().isAssignableFrom(Optional.class);
    }

    @NotNull
    public Object convert(@Nullable Object source, @NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNull((Object)source, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
        Map mapInput = (Map)source;
        if (KotlinDetector.isKotlinType((Class)targetType.getType())) {
            Class clazz = targetType.getType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getType(...)");
            t = this.inputObjectMapper.mapToKotlinObject(mapInput, JvmClassMappingKt.getKotlinClass((Class)clazz));
        } else {
            Class clazz = targetType.getType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getType(...)");
            t = this.inputObjectMapper.mapToJavaObject(mapInput, clazz);
        }
        return t;
    }
}

