/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.utils;

import com.netflix.graphql.dgs.internal.utils.MultipartVariableMapper;
import com.netflix.graphql.dgs.internal.utils.VariableMappingException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.multipart.MultipartFile;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\t\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/netflix/graphql/dgs/internal/utils/MultipartVariableMapper;", "", "<init>", "()V", "PERIOD", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "MAP_MAPPER", "com/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$MAP_MAPPER$1", "Lcom/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$MAP_MAPPER$1;", "LIST_MAPPER", "com/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$LIST_MAPPER$1", "Lcom/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$LIST_MAPPER$1;", "mapVariable", "", "objectPath", "", "variables", "", "part", "Lorg/springframework/web/multipart/MultipartFile;", "Mapper", "graphql-dgs"})
public final class MultipartVariableMapper {
    @NotNull
    public static final MultipartVariableMapper INSTANCE = new MultipartVariableMapper();
    private static final Pattern PERIOD = Pattern.compile("\\.");
    @NotNull
    private static final MAP_MAPPER.1 MAP_MAPPER = new Mapper<Map<String, Object>>(){

        public Object set(Map<String, Object> location, String target, MultipartFile value) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return location.put(target, value);
        }

        public Object recurse(Map<String, Object> location, String target) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Object object = location.get(target);
            if (object == null) {
                throw new VariableMappingException("Path not found: " + target);
            }
            return object;
        }
    };
    @NotNull
    private static final LIST_MAPPER.1 LIST_MAPPER = new Mapper<List<Object>>(){

        public Object set(List<Object> location, String target, MultipartFile value) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return location.set(Integer.parseInt(target), value);
        }

        public Object recurse(List<Object> location, String target) {
            Intrinsics.checkNotNullParameter(location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return location.get(Integer.parseInt(target));
        }
    };

    private MultipartVariableMapper() {
    }

    public final void mapVariable(@NotNull String objectPath, @NotNull Map<String, Object> variables, @NotNull MultipartFile part) {
        Intrinsics.checkNotNullParameter((Object)objectPath, (String)"objectPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        String[] segments = PERIOD.split(objectPath);
        if (segments.length < 2) {
            throw new VariableMappingException("object-path in map must have at least two segments");
        }
        if (!Intrinsics.areEqual((Object)"variables", (Object)segments[0])) {
            throw new VariableMappingException("can only map into variables");
        }
        Object currentLocation = variables;
        int n = segments.length;
        for (int i = 1; i < n; ++i) {
            Object object;
            String segmentName = segments[i];
            if (i == segments.length - 1) {
                if (currentLocation instanceof Map) {
                    Map map = TypeIntrinsics.asMutableMap(currentLocation);
                    Intrinsics.checkNotNull((Object)segmentName);
                    if (MAP_MAPPER.set(map, segmentName, part) == null) continue;
                    throw new VariableMappingException("expected null value when mapping " + objectPath);
                }
                Map<String, Object> map = currentLocation;
                Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
                List list = TypeIntrinsics.asMutableList(map);
                Intrinsics.checkNotNull((Object)segmentName);
                if (LIST_MAPPER.set(list, segmentName, part) == null) continue;
                throw new VariableMappingException("expected null value when mapping " + objectPath);
            }
            if (currentLocation instanceof Map) {
                Map map = TypeIntrinsics.asMutableMap(currentLocation);
                Intrinsics.checkNotNull((Object)segmentName);
                object = MAP_MAPPER.recurse(map, segmentName);
            } else {
                Map<String, Object> map = currentLocation;
                Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
                List list = TypeIntrinsics.asMutableList(map);
                Intrinsics.checkNotNull((Object)segmentName);
                object = LIST_MAPPER.recurse(list, segmentName);
            }
            currentLocation = object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b`\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J'\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lcom/netflix/graphql/dgs/internal/utils/MultipartVariableMapper$Mapper;", "T", "", "set", "location", "target", "", "value", "Lorg/springframework/web/multipart/MultipartFile;", "(Ljava/lang/Object;Ljava/lang/String;Lorg/springframework/web/multipart/MultipartFile;)Ljava/lang/Object;", "recurse", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "graphql-dgs"})
    public static interface Mapper<T> {
        @Nullable
        public Object set(T var1, @NotNull String var2, @NotNull MultipartFile var3);

        @NotNull
        public Object recurse(T var1, @NotNull String var2);
    }
}

