/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs;

import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.MultipleDataLoadersDefinedException;
import com.netflix.graphql.dgs.exceptions.NoDataLoaderFoundException;
import com.netflix.graphql.dgs.internal.utils.DataLoaderNameUtil;
import graphql.GraphQLContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.type.StandardMethodMetadata;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tH\u0096\u0001J7\u0010\u000b\u001a\t\u0018\u0001H\f\u00a2\u0006\u0002\b\r\"\u0010\b\u0000\u0010\f*\n \n*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tH\u0097\u0001\u00a2\u0006\u0002\u0010\u000fJH\u0010\u0010\u001a\n \n*\u0004\u0018\u0001H\fH\f\"\u0010\b\u0000\u0010\f*\n \n*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u000e\u0010\u0011\u001a\n \n*\u0004\u0018\u0001H\fH\fH\u0096\u0001\u00a2\u0006\u0002\u0010\u0012JI\u0010\u0013\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00150\u0014H\u0096\u0001J(\u0010\u0016\u001a\n \n*\u0004\u0018\u0001H\fH\f\"\u0010\b\u0000\u0010\f*\n \n*\u0004\u0018\u00010\u000e0\u000eH\u0097\u0001\u00a2\u0006\u0002\u0010\u0017J*\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\u0019\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dJ`\u0010\u0018\u001a%\u0012\f\u0012\n \n*\u0004\u0018\u0001H\u001aH\u001a\u0012\f\u0012\n \n*\u0004\u0018\u0001H\u001bH\u001b\u0018\u00010\u0019\u00a2\u0006\u0002\b\r\"\u0010\b\u0000\u0010\u001a*\n \n*\u0004\u0018\u00010\u000e0\u000e\"\u0010\b\u0001\u0010\u001b*\n \n*\u0004\u0018\u00010\u000e0\u000e2\u000e\u0010\u001e\u001a\n \n*\u0004\u0018\u00010\t0\tH\u0097\u0001J\u0011\u0010\u001f\u001a\n \n*\u0004\u0018\u00010 0 H\u0096\u0001J\u0006\u0010!\u001a\u00020\u0001J\u0006\u0010\"\u001a\u00020#J\u0011\u0010$\u001a\n \n*\u0004\u0018\u00010%0%H\u0096\u0001J\u0011\u0010&\u001a\n \n*\u0004\u0018\u00010'0'H\u0096\u0001J\u0011\u0010(\u001a\n \n*\u0004\u0018\u00010)0)H\u0096\u0001J\u0011\u0010*\u001a\n \n*\u0004\u0018\u00010+0+H\u0096\u0001J\u0011\u0010,\u001a\n \n*\u0004\u0018\u00010-0-H\u0096\u0001J\u0011\u0010.\u001a\n \n*\u0004\u0018\u00010/0/H\u0096\u0001J-\u00100\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010+0+ \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010+0+\u0018\u00010201H\u0097\u0001JI\u00103\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010404 \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010404\u0018\u00010\u00150\u0014H\u0096\u0001J\u0011\u00105\u001a\n \n*\u0004\u0018\u00010606H\u0096\u0001J\u000e\u00107\u001a\u000708\u00a2\u0006\u0002\b9H\u0097\u0001J'\u0010:\u001a\t\u0018\u0001H\f\u00a2\u0006\u0002\b\r\"\u0010\b\u0000\u0010\f*\n \n*\u0004\u0018\u00010\u000e0\u000eH\u0097\u0001\u00a2\u0006\u0002\u0010\u0017J\u0011\u0010;\u001a\n \n*\u0004\u0018\u00010<0<H\u0096\u0001J\u0011\u0010=\u001a\n \n*\u0004\u0018\u00010>0>H\u0096\u0001J\u0011\u0010?\u001a\n \n*\u0004\u0018\u00010@0@H\u0096\u0001J\u0011\u0010A\u001a\n \n*\u0004\u0018\u00010B0BH\u0096\u0001J\u0011\u0010C\u001a\n \n*\u0004\u0018\u00010D0DH\u0096\u0001J(\u0010E\u001a\n \n*\u0004\u0018\u0001H\fH\f\"\u0010\b\u0000\u0010\f*\n \n*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001\u00a2\u0006\u0002\u0010\u0017J\u0011\u0010F\u001a\n \n*\u0004\u0018\u00010G0GH\u0096\u0001J'\u0010H\u001a\t\u0018\u0001H\f\u00a2\u0006\u0002\b\r\"\u0010\b\u0000\u0010\f*\n \n*\u0004\u0018\u00010\u000e0\u000eH\u0097\u0001\u00a2\u0006\u0002\u0010\u0017J\u0011\u0010I\u001a\u0002H\f\"\u0004\b\u0000\u0010\f\u00a2\u0006\u0002\u0010\u0017JI\u0010J\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00150\u0014H\u0096\u0001J\u001f\u0010K\u001a\u00020\u00072\u0012\u0010L\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0M\"\u00020\t\u00a2\u0006\u0002\u0010NJ\u0016\u0010K\u001a\u00020\u00072\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\t0PH\u0002J\u000e\u0010Q\u001a\u00020\u00072\u0006\u0010L\u001a\u00020\tJ\u0014\u0010R\u001a\u00020\t2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "Lgraphql/schema/DataFetchingEnvironment;", "dfe", "ctx", "Lorg/springframework/context/ApplicationContext;", "(Lgraphql/schema/DataFetchingEnvironment;Lorg/springframework/context/ApplicationContext;)V", "containsArgument", "", "name", "", "kotlin.jvm.PlatformType", "getArgument", "T", "Lorg/jetbrains/annotations/Nullable;", "", "(Ljava/lang/String;)Ljava/lang/Object;", "getArgumentOrDefault", "defaultValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getArguments", "", "", "getContext", "()Ljava/lang/Object;", "getDataLoader", "Lorg/dataloader/DataLoader;", "K", "V", "loaderClass", "Ljava/lang/Class;", "dataLoaderName", "getDataLoaderRegistry", "Lorg/dataloader/DataLoaderRegistry;", "getDfe", "getDgsContext", "Lcom/netflix/graphql/dgs/context/DgsContext;", "getDocument", "Lgraphql/language/Document;", "getExecutionId", "Lgraphql/execution/ExecutionId;", "getExecutionStepInfo", "Lgraphql/execution/ExecutionStepInfo;", "getField", "Lgraphql/language/Field;", "getFieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "getFieldType", "Lgraphql/schema/GraphQLOutputType;", "getFields", "", "", "getFragmentsByName", "Lgraphql/language/FragmentDefinition;", "getGraphQLSchema", "Lgraphql/schema/GraphQLSchema;", "getGraphQlContext", "Lgraphql/GraphQLContext;", "Lorg/jetbrains/annotations/NotNull;", "getLocalContext", "getLocale", "Ljava/util/Locale;", "getMergedField", "Lgraphql/execution/MergedField;", "getOperationDefinition", "Lgraphql/language/OperationDefinition;", "getParentType", "Lgraphql/schema/GraphQLType;", "getQueryDirectives", "Lgraphql/execution/directives/QueryDirectives;", "getRoot", "getSelectionSet", "Lgraphql/schema/DataFetchingFieldSelectionSet;", "getSource", "getSourceOrThrow", "getVariables", "isArgumentSet", "path", "", "([Ljava/lang/String;)Z", "keys", "Lkotlin/sequences/Sequence;", "isNestedArgumentSet", "tryGetDataLoaderFromBeanDefinition", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsDataFetchingEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsDataFetchingEnvironment.kt\ncom/netflix/graphql/dgs/DgsDataFetchingEnvironment\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,118:1\n3792#2:119\n4307#2,2:120\n1549#3:122\n1620#3,3:123\n37#4,2:126\n*S KotlinDebug\n*F\n+ 1 DgsDataFetchingEnvironment.kt\ncom/netflix/graphql/dgs/DgsDataFetchingEnvironment\n*L\n50#1:119\n50#1:120,2\n93#1:122\n93#1:123,3\n94#1:126,2\n*E\n"})
public final class DgsDataFetchingEnvironment
implements DataFetchingEnvironment {
    @NotNull
    private final DataFetchingEnvironment dfe;
    @NotNull
    private final ApplicationContext ctx;

    public DgsDataFetchingEnvironment(@NotNull DataFetchingEnvironment dfe, @NotNull ApplicationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.dfe = dfe;
        this.ctx = ctx;
    }

    public boolean containsArgument(String name) {
        return this.dfe.containsArgument(name);
    }

    @Nullable
    public <T> T getArgument(String name) {
        return (T)this.dfe.getArgument(name);
    }

    public <T> T getArgumentOrDefault(String name, T defaultValue) {
        return (T)this.dfe.getArgumentOrDefault(name, defaultValue);
    }

    public Map<String, Object> getArguments() {
        return this.dfe.getArguments();
    }

    @Deprecated(message="Deprecated in Java")
    public <T> T getContext() {
        return (T)this.dfe.getContext();
    }

    @Nullable
    public <K, V> DataLoader<K, V> getDataLoader(String dataLoaderName) {
        return this.dfe.getDataLoader(dataLoaderName);
    }

    public DataLoaderRegistry getDataLoaderRegistry() {
        return this.dfe.getDataLoaderRegistry();
    }

    public Document getDocument() {
        return this.dfe.getDocument();
    }

    public ExecutionId getExecutionId() {
        return this.dfe.getExecutionId();
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.dfe.getExecutionStepInfo();
    }

    public Field getField() {
        return this.dfe.getField();
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.dfe.getFieldDefinition();
    }

    public GraphQLOutputType getFieldType() {
        return this.dfe.getFieldType();
    }

    @Deprecated(message="Deprecated in Java")
    public List<Field> getFields() {
        return this.dfe.getFields();
    }

    public Map<String, FragmentDefinition> getFragmentsByName() {
        return this.dfe.getFragmentsByName();
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.dfe.getGraphQLSchema();
    }

    @NotNull
    public GraphQLContext getGraphQlContext() {
        return this.dfe.getGraphQlContext();
    }

    @Nullable
    public <T> T getLocalContext() {
        return (T)this.dfe.getLocalContext();
    }

    public Locale getLocale() {
        return this.dfe.getLocale();
    }

    public MergedField getMergedField() {
        return this.dfe.getMergedField();
    }

    public OperationDefinition getOperationDefinition() {
        return this.dfe.getOperationDefinition();
    }

    public GraphQLType getParentType() {
        return this.dfe.getParentType();
    }

    public QueryDirectives getQueryDirectives() {
        return this.dfe.getQueryDirectives();
    }

    public <T> T getRoot() {
        return (T)this.dfe.getRoot();
    }

    public DataFetchingFieldSelectionSet getSelectionSet() {
        return this.dfe.getSelectionSet();
    }

    @Nullable
    public <T> T getSource() {
        return (T)this.dfe.getSource();
    }

    public Map<String, Object> getVariables() {
        return this.dfe.getVariables();
    }

    @NotNull
    public final DataFetchingEnvironment getDfe() {
        return this.dfe;
    }

    @NotNull
    public final DgsContext getDgsContext() {
        return DgsContext.Companion.from(this);
    }

    public final <T> T getSourceOrThrow() {
        T t = this.getSource();
        if (t == null) {
            throw new IllegalStateException("source is null");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <K, V> DataLoader<K, V> getDataLoader(@NotNull Class<?> loaderClass) {
        String string;
        Intrinsics.checkNotNullParameter(loaderClass, (String)"loaderClass");
        DgsDataLoader annotation2 = loaderClass.getAnnotation(DgsDataLoader.class);
        if (annotation2 != null) {
            string = DataLoaderNameUtil.INSTANCE.getDataLoaderName(loaderClass, annotation2);
        } else {
            void $this$filterTo$iv$iv;
            java.lang.reflect.Field[] fieldArray = loaderClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getFields(...)");
            Object[] $this$filter$iv = fieldArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                java.lang.reflect.Field it = (java.lang.reflect.Field)element$iv$iv;
                boolean bl = false;
                if (!it.isAnnotationPresent(DgsDataLoader.class)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List loaders = (List)destination$iv$iv;
            if (loaders.isEmpty()) {
                string = this.tryGetDataLoaderFromBeanDefinition(loaderClass);
            } else {
                if (loaders.size() > 1) {
                    $this$filter$iv = new Class[]{loaderClass};
                    throw new MultipleDataLoadersDefinedException((Class<?>[])$this$filter$iv);
                }
                java.lang.reflect.Field field = (java.lang.reflect.Field)CollectionsKt.firstOrNull((List)loaders);
                if (field == null) {
                    throw new NoDataLoaderFoundException(loaderClass);
                }
                java.lang.reflect.Field loaderField = field;
                DgsDataLoader theAnnotation = loaderField.getAnnotation(DgsDataLoader.class);
                string = theAnnotation.name();
            }
        }
        String loaderName = string;
        DataLoader<K, V> dataLoader = this.getDataLoader(loaderName);
        if (dataLoader == null) {
            throw new NoDataLoaderFoundException("DataLoader with name " + loaderName + " not found");
        }
        return dataLoader;
    }

    private final String tryGetDataLoaderFromBeanDefinition(Class<?> loaderClass) {
        String name = loaderClass.getSimpleName();
        if (this.ctx instanceof ConfigurableApplicationContext) {
            Map beansOfType = ((ConfigurableApplicationContext)this.ctx).getBeanFactory().getBeansOfType(loaderClass);
            if (beansOfType.isEmpty()) {
                throw new NoDataLoaderFoundException(loaderClass);
            }
            if (beansOfType.size() > 1) {
                Class[] classArray = new Class[]{loaderClass};
                throw new MultipleDataLoadersDefinedException(classArray);
            }
            String beanName = (String)CollectionsKt.first((Iterable)beansOfType.keySet());
            BeanDefinition beanDefinition = ((ConfigurableApplicationContext)this.ctx).getBeanFactory().getBeanDefinition(beanName);
            if (beanDefinition.getSource() instanceof StandardMethodMetadata) {
                Object object = beanDefinition.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.springframework.core.type.StandardMethodMetadata");
                StandardMethodMetadata methodMetadata = (StandardMethodMetadata)object;
                Method method = methodMetadata.getIntrospectedMethod();
                DgsDataLoader methodAnnotation = method.getAnnotation(DgsDataLoader.class);
                Intrinsics.checkNotNull((Object)methodAnnotation);
                name = DataLoaderNameUtil.INSTANCE.getDataLoaderName(loaderClass, methodAnnotation);
            }
        }
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isNestedArgumentSet(@NotNull String path) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] stringArray = new String[]{".", "->"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void s;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)s))).toString());
        }
        List pathParts = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = pathParts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        return this.isArgumentSet(Arrays.copyOf(stringArray, stringArray.length));
    }

    public final boolean isArgumentSet(String ... path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.isArgumentSet((Sequence<String>)ArraysKt.asSequence((Object[])path));
    }

    private final boolean isArgumentSet(Sequence<String> keys) {
        Map map = this.dfe.getExecutionStepInfo().getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        Map args = map;
        Object value = null;
        for (String key : keys) {
            if (!args.containsKey(key)) {
                return false;
            }
            value = args.get(key);
            if (!(value instanceof Map)) {
                return true;
            }
            args = value;
        }
        return true;
    }
}

