/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DgsContextBuilder;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import com.netflix.graphql.dgs.internal.DefaultRequestData;
import com.netflix.graphql.dgs.internal.utils.TimeTracer;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0002R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "Lcom/netflix/graphql/dgs/DgsContextBuilder;", "dgsCustomContextBuilder", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "(Ljava/util/Optional;)V", "extensions", "", "", "", "getExtensions", "()Ljava/util/Map;", "setExtensions", "(Ljava/util/Map;)V", "headers", "Lorg/springframework/http/HttpHeaders;", "getHeaders", "()Lorg/springframework/http/HttpHeaders;", "setHeaders", "(Lorg/springframework/http/HttpHeaders;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "build", "Lcom/netflix/graphql/dgs/context/DgsContext;", "buildDgsContext", "graphql-dgs"})
public class DefaultDgsGraphQLContextBuilder
implements DgsContextBuilder {
    @NotNull
    private final Logger logger;
    @Nullable
    private Map<String, ? extends Object> extensions;
    @Nullable
    private HttpHeaders headers;
    private final Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public final void setExtensions(@Nullable Map<String, ? extends Object> map) {
        this.extensions = map;
    }

    @Nullable
    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@Nullable HttpHeaders httpHeaders) {
        this.headers = httpHeaders;
    }

    @Override
    @NotNull
    public DgsContext build() {
        return (DgsContext)TimeTracer.INSTANCE.logTime((Function0)new Function0<DgsContext>(this){
            final /* synthetic */ DefaultDgsGraphQLContextBuilder this$0;

            @NotNull
            public final DgsContext invoke() {
                return DefaultDgsGraphQLContextBuilder.access$buildDgsContext(this.this$0);
            }
            {
                this.this$0 = defaultDgsGraphQLContextBuilder;
                super(0);
            }
        }, this.logger, "Created DGS context in {}ms");
    }

    private final DgsContext buildDgsContext() {
        DefaultRequestData defaultRequestData;
        if (this.dgsCustomContextBuilder.isPresent()) {
            defaultRequestData = this.dgsCustomContextBuilder.get().build();
        } else {
            HttpHeaders httpHeaders;
            Map map = this.extensions;
            if (map == null) {
                boolean bl = false;
                map = MapsKt.emptyMap();
            }
            if ((httpHeaders = this.headers) == null) {
                httpHeaders = new HttpHeaders();
            }
            defaultRequestData = new DefaultRequestData(map, httpHeaders);
        }
        DefaultRequestData customContext = defaultRequestData;
        return new DgsContext(customContext);
    }

    public DefaultDgsGraphQLContextBuilder(@NotNull Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder) {
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilder, (String)"dgsCustomContextBuilder");
        this.dgsCustomContextBuilder = dgsCustomContextBuilder;
        Logger logger = LoggerFactory.getLogger(DefaultDgsGraphQLContextBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026ntextBuilder::class.java)");
        this.logger = logger;
    }

    public static final /* synthetic */ DgsContext access$buildDgsContext(DefaultDgsGraphQLContextBuilder $this) {
        return $this.buildDgsContext();
    }
}

