/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.exceptions.InvalidDataLoaderTypeException;
import com.netflix.graphql.dgs.exceptions.UnsupportedSecuredDataLoaderException;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider$sam$org_dataloader_BatchLoaderContextProvider$0;
import com.netflix.graphql.dgs.internal.utils.DgsComponentUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderContextProvider;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cJ2\u0010\u001d\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0006\u0010 \u001a\u00020\tH\u0002JF\u0010\u001d\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001e\"\u0004\b\u0000\u0010\u001a2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\u0006\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0002J2\u0010\u001d\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010 \u001a\u00020\tH\u0002JF\u0010\u001d\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001e\"\u0004\b\u0000\u0010\u001a2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0006\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0002J\r\u0010\"\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0005\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lorg/springframework/context/ApplicationContext;)V", "batchLoaders", "", "Lkotlin/Pair;", "Lorg/dataloader/BatchLoader;", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "batchLoadersWithContext", "Lorg/dataloader/BatchLoaderWithContext;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "mappedBatchLoaders", "Lorg/dataloader/MappedBatchLoader;", "mappedBatchLoadersWithContext", "Lorg/dataloader/MappedBatchLoaderWithContext;", "addDataLoaderComponents", "", "addDataLoaderFields", "buildRegistry", "Lorg/dataloader/DataLoaderRegistry;", "buildRegistryWithContextSupplier", "T", "contextSupplier", "Ljava/util/function/Supplier;", "createDataLoader", "Lorg/dataloader/DataLoader;", "batchLoader", "dgsDataLoader", "supplier", "findDataLoaders", "findDataLoaders$graphql_dgs", "graphql-dgs"})
public final class DgsDataLoaderProvider {
    @NotNull
    private final Logger logger;
    private final List<Pair<BatchLoader<?, ?>, DgsDataLoader>> batchLoaders;
    private final List<Pair<BatchLoaderWithContext<?, ?>, DgsDataLoader>> batchLoadersWithContext;
    private final List<Pair<MappedBatchLoader<?, ?>, DgsDataLoader>> mappedBatchLoaders;
    private final List<Pair<MappedBatchLoaderWithContext<?, ?>, DgsDataLoader>> mappedBatchLoadersWithContext;
    private final ApplicationContext applicationContext;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final DataLoaderRegistry buildRegistry() {
        return this.buildRegistryWithContextSupplier(buildRegistry.1.INSTANCE);
    }

    @NotNull
    public final <T> DataLoaderRegistry buildRegistryWithContextSupplier(@NotNull Supplier<T> contextSupplier) {
        Pair it;
        Intrinsics.checkNotNullParameter(contextSupplier, (String)"contextSupplier");
        long startTime = System.currentTimeMillis();
        DataLoaderRegistry dataLoaderRegistry2 = new DataLoaderRegistry();
        Iterable $this$forEach$iv = this.batchLoaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry2.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((BatchLoader)it.getFirst(), (DgsDataLoader)it.getSecond()));
        }
        $this$forEach$iv = this.mappedBatchLoaders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry2.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((MappedBatchLoader)it.getFirst(), (DgsDataLoader)it.getSecond()));
        }
        $this$forEach$iv = this.batchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry2.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((BatchLoaderWithContext)it.getFirst(), (DgsDataLoader)it.getSecond(), contextSupplier));
        }
        $this$forEach$iv = this.mappedBatchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry2.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((MappedBatchLoaderWithContext)it.getFirst(), (DgsDataLoader)it.getSecond(), contextSupplier));
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        this.logger.debug("Created DGS dataloader registry in {}ms", (Object)totalTime);
        return dataLoaderRegistry2;
    }

    @PostConstruct
    public final void findDataLoaders$graphql_dgs() {
        this.addDataLoaderComponents();
        this.addDataLoaderFields();
    }

    /*
     * WARNING - void declaration
     */
    private final void addDataLoaderFields() {
        Iterable $this$forEach$iv = this.applicationContext.getBeansWithAnnotation(DgsComponent.class).values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$filterTo$iv$iv;
            Field[] $this$filter$iv;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Object t = dgsComponent;
            Intrinsics.checkNotNullExpressionValue(t, (String)"dgsComponent");
            Class<?> javaClass = DgsComponentUtils.Companion.getClassEnhancedBySpringCGLib(t);
            Intrinsics.checkNotNullExpressionValue((Object)javaClass.getDeclaredFields(), (String)"javaClass.declaredFields");
            boolean $i$f$filter = false;
            Field[] fieldArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var13_14 = $this$filterTo$iv$iv;
            int n = ((void)var13_14).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var13_14[i];
                boolean bl2 = false;
                if (!it.isAnnotationPresent(DgsDataLoader.class)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv2 = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl3 = false;
                String string = dgsComponent.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dgsComponent.javaClass.name");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"EnhancerBySpringCGLIB", (boolean)false, (int)2, null)) {
                    throw (Throwable)new UnsupportedSecuredDataLoaderException(dgsComponent.getClass());
                }
                DgsDataLoader annotation = field.getAnnotation(DgsDataLoader.class);
                Field field2 = field;
                Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field");
                field2.setAccessible(true);
                Object get = field.get(dgsComponent);
                if (get instanceof BatchLoader) {
                    this.batchLoaders.add(new Pair(get, (Object)annotation));
                    continue;
                }
                if (get instanceof BatchLoaderWithContext) {
                    this.batchLoadersWithContext.add(new Pair(get, (Object)annotation));
                    continue;
                }
                if (get instanceof MappedBatchLoader) {
                    this.mappedBatchLoaders.add(new Pair(get, (Object)annotation));
                    continue;
                }
                if (get instanceof MappedBatchLoaderWithContext) {
                    this.mappedBatchLoadersWithContext.add(new Pair(get, (Object)annotation));
                    continue;
                }
                throw (Throwable)new InvalidDataLoaderTypeException(dgsComponent.getClass());
            }
        }
    }

    private final void addDataLoaderComponents() {
        Map dataLoaders = this.applicationContext.getBeansWithAnnotation(DgsDataLoader.class);
        Iterable $this$forEach$iv = dataLoaders.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Object t = dgsComponent;
            Intrinsics.checkNotNullExpressionValue(t, (String)"dgsComponent");
            Class<?> javaClass = DgsComponentUtils.Companion.getClassEnhancedBySpringCGLib(t);
            DgsDataLoader annotation = javaClass.getAnnotation(DgsDataLoader.class);
            Object t2 = dgsComponent;
            if (t2 instanceof BatchLoader) {
                this.batchLoaders.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            if (t2 instanceof BatchLoaderWithContext) {
                this.batchLoadersWithContext.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            if (t2 instanceof MappedBatchLoader) {
                this.mappedBatchLoaders.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            if (t2 instanceof MappedBatchLoaderWithContext) {
                this.mappedBatchLoadersWithContext.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            throw (Throwable)new InvalidDataLoaderTypeException(dgsComponent.getClass());
        }
    }

    private final DataLoader<? extends Object, ? extends Object> createDataLoader(BatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader) {
        BatchLoader<?, ?> batchLoader2;
        DataLoaderOptions options2 = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setCachingEnabled(dgsDataLoader.caching());
        if (dgsDataLoader.maxBatchSize() > 0) {
            options2.setMaxBatchSize(dgsDataLoader.maxBatchSize());
        }
        try {
            DataLoaderInstrumentationExtensionProvider extensionProvider = (DataLoaderInstrumentationExtensionProvider)this.applicationContext.getBean(DataLoaderInstrumentationExtensionProvider.class);
            batchLoader2 = extensionProvider.provide(batchLoader, dgsDataLoader.name());
        }
        catch (NoSuchBeanDefinitionException ex) {
            batchLoader2 = batchLoader;
        }
        BatchLoader<?, ?> extendedBatchLoader = batchLoader2;
        return DataLoader.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options2);
    }

    private final DataLoader<? extends Object, ? extends Object> createDataLoader(MappedBatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader) {
        MappedBatchLoader<?, ?> mappedBatchLoader;
        DataLoaderOptions options2 = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setCachingEnabled(dgsDataLoader.caching());
        if (dgsDataLoader.maxBatchSize() > 0) {
            options2.setMaxBatchSize(dgsDataLoader.maxBatchSize());
        }
        try {
            DataLoaderInstrumentationExtensionProvider extensionProvider = (DataLoaderInstrumentationExtensionProvider)this.applicationContext.getBean(DataLoaderInstrumentationExtensionProvider.class);
            mappedBatchLoader = extensionProvider.provide(batchLoader, dgsDataLoader.name());
        }
        catch (NoSuchBeanDefinitionException ex) {
            mappedBatchLoader = batchLoader;
        }
        MappedBatchLoader<?, ?> extendedBatchLoader = mappedBatchLoader;
        return DataLoader.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options2);
    }

    private final <T> DataLoader<? extends Object, ? extends Object> createDataLoader(BatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, Supplier<T> supplier) {
        BatchLoaderWithContext<?, ?> batchLoaderWithContext;
        Function0 function0 = new Function0<T>(supplier){

            public final T invoke() {
                return ((Supplier)this.receiver).get();
            }
        };
        DataLoaderOptions options2 = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setBatchLoaderContextProvider((BatchLoaderContextProvider)new DgsDataLoaderProvider$sam$org_dataloader_BatchLoaderContextProvider$0(function0)).setCachingEnabled(dgsDataLoader.caching());
        if (dgsDataLoader.maxBatchSize() > 0) {
            options2.setMaxBatchSize(dgsDataLoader.maxBatchSize());
        }
        try {
            DataLoaderInstrumentationExtensionProvider extensionProvider = (DataLoaderInstrumentationExtensionProvider)this.applicationContext.getBean(DataLoaderInstrumentationExtensionProvider.class);
            batchLoaderWithContext = extensionProvider.provide(batchLoader, dgsDataLoader.name());
        }
        catch (NoSuchBeanDefinitionException ex) {
            batchLoaderWithContext = batchLoader;
        }
        BatchLoaderWithContext<?, ?> extendedBatchLoader = batchLoaderWithContext;
        return DataLoader.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options2);
    }

    private final <T> DataLoader<? extends Object, ? extends Object> createDataLoader(MappedBatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, Supplier<T> supplier) {
        MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext;
        Function0 function0 = new Function0<T>(supplier){

            public final T invoke() {
                return ((Supplier)this.receiver).get();
            }
        };
        DataLoaderOptions options2 = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setBatchLoaderContextProvider((BatchLoaderContextProvider)new DgsDataLoaderProvider$sam$org_dataloader_BatchLoaderContextProvider$0(function0)).setCachingEnabled(dgsDataLoader.caching());
        if (dgsDataLoader.maxBatchSize() > 0) {
            options2.setMaxBatchSize(dgsDataLoader.maxBatchSize());
        }
        try {
            DataLoaderInstrumentationExtensionProvider extensionProvider = (DataLoaderInstrumentationExtensionProvider)this.applicationContext.getBean(DataLoaderInstrumentationExtensionProvider.class);
            mappedBatchLoaderWithContext = extensionProvider.provide(batchLoader, dgsDataLoader.name());
        }
        catch (NoSuchBeanDefinitionException ex) {
            mappedBatchLoaderWithContext = batchLoader;
        }
        MappedBatchLoaderWithContext<?, ?> extendedBatchLoader = mappedBatchLoaderWithContext;
        return DataLoader.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options2);
    }

    public DgsDataLoaderProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
        Logger logger = LoggerFactory.getLogger(DgsDataLoaderProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026aderProvider::class.java)");
        this.logger = logger;
        boolean bl = false;
        this.batchLoaders = new ArrayList();
        bl = false;
        this.batchLoadersWithContext = new ArrayList();
        bl = false;
        this.mappedBatchLoaders = new ArrayList();
        bl = false;
        this.mappedBatchLoadersWithContext = new ArrayList();
    }
}

