/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.exceptions;

import com.netflix.graphql.dgs.exceptions.DgsBadRequestException;
import com.netflix.graphql.dgs.exceptions.DgsEntityNotFoundException;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "()V", "logger", "Lorg/slf4j/Logger;", "onException", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "graphql-dgs"})
public final class DefaultDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    private final Logger logger;

    @NotNull
    public DataFetcherExceptionHandlerResult onException(@Nullable DataFetcherExceptionHandlerParameters handlerParameters) {
        boolean bl;
        DataFetcherExceptionHandlerParameters dataFetcherExceptionHandlerParameters = handlerParameters;
        Intrinsics.checkNotNull((Object)dataFetcherExceptionHandlerParameters);
        Throwable exception = dataFetcherExceptionHandlerParameters.getException();
        this.logger.error("Exception while executing data fetcher for " + handlerParameters.getPath() + ": " + exception.getMessage(), exception);
        try {
            Class.forName("org.springframework.security.access.AccessDeniedException");
            bl = true;
        }
        catch (ClassNotFoundException ex) {
            bl = false;
        }
        boolean springSecurityAvailable = bl;
        TypedGraphQLError graphqlError = springSecurityAvailable && exception instanceof AccessDeniedException ? TypedGraphQLError.newPermissionDeniedBuilder().message("%s: %s", new Object[]{exception.getClass().getName(), exception.getMessage()}).path(handlerParameters.getPath()).build() : (exception instanceof DgsEntityNotFoundException ? TypedGraphQLError.newNotFoundBuilder().message("%s: %s", new Object[]{exception.getClass().getName(), ((DgsEntityNotFoundException)exception).getMessage()}).path(handlerParameters.getPath()).build() : (exception instanceof DgsBadRequestException ? TypedGraphQLError.newBadRequestBuilder().message("%s: %s", new Object[]{exception.getClass().getName(), ((DgsBadRequestException)exception).getMessage()}).path(handlerParameters.getPath()).build() : TypedGraphQLError.newInternalErrorBuilder().message("%s: %s", new Object[]{exception.getClass().getName(), exception.getMessage()}).path(handlerParameters.getPath()).build()));
        DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)graphqlError).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherExceptionHandlerResult, (String)"DataFetcherExceptionHand\u2026ror)\n            .build()");
        return dataFetcherExceptionHandlerResult;
    }

    public DefaultDataFetcherExceptionHandler() {
        Logger logger = LoggerFactory.getLogger(DefaultDataFetcherExceptionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026ptionHandler::class.java)");
        this.logger = logger;
    }
}

