/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.apollographql.federation.graphqljava.Federation;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsDefaultTypeResolver;
import com.netflix.graphql.dgs.DgsDirective;
import com.netflix.graphql.dgs.DgsEnableDataFetcherInstrumentation;
import com.netflix.graphql.dgs.DgsEntityFetcher;
import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.DgsScalar;
import com.netflix.graphql.dgs.DgsTypeDefinitionRegistry;
import com.netflix.graphql.dgs.DgsTypeResolver;
import com.netflix.graphql.dgs.exceptions.InvalidDgsConfigurationException;
import com.netflix.graphql.dgs.exceptions.InvalidTypeResolverException;
import com.netflix.graphql.dgs.exceptions.NoSchemaFoundException;
import com.netflix.graphql.dgs.federation.DefaultDgsFederationResolver;
import com.netflix.graphql.dgs.internal.DataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.DatafetcherReference;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider$registerDataFetcher$;
import com.netflix.graphql.dgs.internal.EntityFetcherRegistry;
import com.netflix.graphql.dgs.internal.method.MethodDataFetcherFactory;
import com.netflix.graphql.mocking.DgsSchemaTransformer;
import com.netflix.graphql.mocking.MockProvider;
import graphql.TypeResolutionEnvironment;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ReflectionUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 H2\u00020\u0001:\u0001HB\u008f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\u0012\b\u0002\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0005\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J(\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u001cH\u0002J&\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\bH\u0002J\u0018\u0010/\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00100\u001a\u000201H\u0002J\u0016\u00102\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+H\u0002J\u0018\u00103\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00100\u001a\u000201H\u0002J\u001d\u00104\u001a\b\u0012\u0004\u0012\u0002050\r2\b\b\u0002\u00106\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b7J&\u00108\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+2\u0006\u00100\u001a\u0002012\u0006\u00109\u001a\u00020\bH\u0002J \u0010:\u001a\u00020)2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-2\u0006\u0010;\u001a\u00020\bH\u0002J\u0018\u0010<\u001a\u00020)2\u0006\u0010&\u001a\u00020\u00012\u0006\u00100\u001a\u000201H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010\b2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\bH\u0002J>\u0010>\u001a\u00020)2\u0006\u0010.\u001a\u00020\b2\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010$\u001a\u00020%2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010B\u001a\u00020CH\u0002J\u001c\u0010D\u001a\u00020E2\n\b\u0003\u0010D\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010F\u001a\u00020GR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "federationResolver", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "existingTypeDefinitionRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "mockProviders", "", "Lcom/netflix/graphql/mocking/MockProvider;", "schemaLocations", "", "", "dataFetcherResultProcessors", "Lcom/netflix/graphql/dgs/internal/DataFetcherResultProcessor;", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "entityFetcherRegistry", "Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "defaultDataFetcherFactory", "Lgraphql/schema/DataFetcherFactory;", "methodDataFetcherFactory", "Lcom/netflix/graphql/dgs/internal/method/MethodDataFetcherFactory;", "(Lorg/springframework/context/ApplicationContext;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Set;Ljava/util/List;Ljava/util/List;Ljava/util/Optional;Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;Ljava/util/Optional;Lcom/netflix/graphql/dgs/internal/method/MethodDataFetcherFactory;)V", "dataFetcherInstrumentationEnabled", "", "", "getDataFetcherInstrumentationEnabled", "()Ljava/util/Map;", "dataFetchers", "", "Lcom/netflix/graphql/dgs/internal/DatafetcherReference;", "createBasicDataFetcher", "Lgraphql/schema/DataFetcher;", "method", "Ljava/lang/reflect/Method;", "dgsComponent", "isSubscription", "findDataFetchers", "", "dgsComponents", "", "codeRegistryBuilder", "Lgraphql/schema/GraphQLCodeRegistry$Builder;", "typeDefinitionRegistry", "findDirectives", "runtimeWiringBuilder", "Lgraphql/schema/idl/RuntimeWiring$Builder;", "findEntityFetchers", "findScalars", "findSchemaFiles", "Lorg/springframework/core/io/Resource;", "hasDynamicTypeRegistry", "findSchemaFiles$graphql_dgs", "findTypeResolvers", "mergedRegistry", "invokeDgsCodeRegistry", "registry", "invokeDgsRuntimeWiring", "invokeDgsTypeDefinitionRegistry", "registerDataFetcher", "dgsDataAnnotation", "Lorg/springframework/core/annotation/MergedAnnotation;", "Lcom/netflix/graphql/dgs/DgsData;", "mergedAnnotations", "Lorg/springframework/core/annotation/MergedAnnotations;", "schema", "Lgraphql/schema/GraphQLSchema;", "fieldVisibility", "Lgraphql/schema/visibility/GraphqlFieldVisibility;", "Companion", "graphql-dgs"})
public final class DgsSchemaProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final Optional<DgsFederationResolver> federationResolver;
    @NotNull
    private final Optional<TypeDefinitionRegistry> existingTypeDefinitionRegistry;
    @NotNull
    private final Set<MockProvider> mockProviders;
    @NotNull
    private final List<String> schemaLocations;
    @NotNull
    private final List<DataFetcherResultProcessor> dataFetcherResultProcessors;
    @NotNull
    private final Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler;
    @NotNull
    private final EntityFetcherRegistry entityFetcherRegistry;
    @NotNull
    private final Optional<DataFetcherFactory<?>> defaultDataFetcherFactory;
    @NotNull
    private final MethodDataFetcherFactory methodDataFetcherFactory;
    @NotNull
    private final Map<String, Boolean> dataFetcherInstrumentationEnabled;
    @NotNull
    private final List<DatafetcherReference> dataFetchers;
    @NotNull
    public static final String DEFAULT_SCHEMA_LOCATION = "classpath*:schema/**/*.graphql*";
    @NotNull
    private static final Logger logger;

    public DgsSchemaProvider(@NotNull ApplicationContext applicationContext, @NotNull Optional<DgsFederationResolver> federationResolver, @NotNull Optional<TypeDefinitionRegistry> existingTypeDefinitionRegistry, @NotNull Set<? extends MockProvider> mockProviders, @NotNull List<String> schemaLocations, @NotNull List<? extends DataFetcherResultProcessor> dataFetcherResultProcessors, @NotNull Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler, @NotNull EntityFetcherRegistry entityFetcherRegistry, @NotNull Optional<DataFetcherFactory<?>> defaultDataFetcherFactory, @NotNull MethodDataFetcherFactory methodDataFetcherFactory) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(federationResolver, (String)"federationResolver");
        Intrinsics.checkNotNullParameter(existingTypeDefinitionRegistry, (String)"existingTypeDefinitionRegistry");
        Intrinsics.checkNotNullParameter(mockProviders, (String)"mockProviders");
        Intrinsics.checkNotNullParameter(schemaLocations, (String)"schemaLocations");
        Intrinsics.checkNotNullParameter(dataFetcherResultProcessors, (String)"dataFetcherResultProcessors");
        Intrinsics.checkNotNullParameter(dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"entityFetcherRegistry");
        Intrinsics.checkNotNullParameter(defaultDataFetcherFactory, (String)"defaultDataFetcherFactory");
        Intrinsics.checkNotNullParameter((Object)methodDataFetcherFactory, (String)"methodDataFetcherFactory");
        this.applicationContext = applicationContext;
        this.federationResolver = federationResolver;
        this.existingTypeDefinitionRegistry = existingTypeDefinitionRegistry;
        this.mockProviders = mockProviders;
        this.schemaLocations = schemaLocations;
        this.dataFetcherResultProcessors = dataFetcherResultProcessors;
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
        this.entityFetcherRegistry = entityFetcherRegistry;
        this.defaultDataFetcherFactory = defaultDataFetcherFactory;
        this.methodDataFetcherFactory = methodDataFetcherFactory;
        this.dataFetcherInstrumentationEnabled = new LinkedHashMap();
        this.dataFetchers = new ArrayList();
    }

    public /* synthetic */ DgsSchemaProvider(ApplicationContext applicationContext, Optional optional, Optional optional2, Set set, List list, List list2, Optional optional3, EntityFetcherRegistry entityFetcherRegistry, Optional optional4, MethodDataFetcherFactory methodDataFetcherFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.listOf((Object)DEFAULT_SCHEMA_LOCATION);
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            Optional<DataFetcherExceptionHandler> optional5 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional5, (String)"empty()");
            optional3 = optional5;
        }
        if ((n & 0x80) != 0) {
            entityFetcherRegistry = new EntityFetcherRegistry();
        }
        if ((n & 0x100) != 0) {
            Optional<DataFetcherFactory<?>> optional6 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional6, (String)"empty()");
            optional4 = optional6;
        }
        this(applicationContext, optional, optional2, set, list, list2, optional3, entityFetcherRegistry, optional4, methodDataFetcherFactory);
    }

    @NotNull
    public final Map<String, Boolean> getDataFetcherInstrumentationEnabled() {
        return this.dataFetcherInstrumentationEnabled;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GraphQLSchema schema(@Language(value="GraphQL") @Nullable String schema2, @NotNull GraphqlFieldVisibility fieldVisibility) {
        Object dgsComponent;
        Object element$iv;
        void $this$fold$iv;
        Object object;
        Object element$iv22;
        Ref.ObjectRef mergedRegistry2;
        TypeDefinitionRegistry typeDefinitionRegistry;
        boolean bl;
        Collection dgsComponents;
        long startTime;
        block13: {
            Intrinsics.checkNotNullParameter((Object)fieldVisibility, (String)"fieldVisibility");
            startTime = System.currentTimeMillis();
            dgsComponents = this.applicationContext.getBeansWithAnnotation(DgsComponent.class).values();
            Iterable $this$any$iv = dgsComponents;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                typeDefinitionRegistry = $this$any$iv.iterator();
                while (typeDefinitionRegistry.hasNext()) {
                    boolean bl2;
                    block12: {
                        Object element$iv3;
                        Object it = element$iv3 = typeDefinitionRegistry.next();
                        boolean bl3 = false;
                        Method[] methodArray = it.getClass().getMethods();
                        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"it.javaClass.methods");
                        Object[] $this$any$iv2 = methodArray;
                        boolean $i$f$any2 = false;
                        for (Object element$iv4 : $this$any$iv2) {
                            Method m = (Method)element$iv4;
                            boolean bl4 = false;
                            if (!m.isAnnotationPresent(DgsTypeDefinitionRegistry.class)) continue;
                            bl2 = true;
                            break block12;
                        }
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        boolean hasDynamicTypeRegistry = bl;
        Ref.ObjectRef objectRef = mergedRegistry2 = new Ref.ObjectRef();
        if (schema2 == null) {
            void $this$fold$iv2;
            void initial$iv;
            Sequence $i$f$any = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.findSchemaFiles$graphql_dgs(hasDynamicTypeRegistry)), (Function1)schema.mergedRegistry.1.INSTANCE);
            typeDefinitionRegistry = new TypeDefinitionRegistry();
            Ref.ObjectRef objectRef2 = objectRef;
            boolean $i$f$fold = false;
            TypeDefinitionRegistry accumulator$iv = initial$iv;
            for (Object element$iv22 : $this$fold$iv2) {
                void b;
                TypeDefinitionRegistry $i$f$any2 = (TypeDefinitionRegistry)element$iv22;
                void a = accumulator$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)a.merge((TypeDefinitionRegistry)b), (String)"a.merge(b)");
            }
            object = accumulator$iv;
            objectRef = objectRef2;
        } else {
            object = objectRef.element = new SchemaParser().parse(schema2);
        }
        if (this.existingTypeDefinitionRegistry.isPresent()) {
            mergedRegistry2.element = ((TypeDefinitionRegistry)mergedRegistry2.element).merge(this.existingTypeDefinitionRegistry.get());
        }
        DgsFederationResolver federationResolverInstance = this.federationResolver.orElseGet(() -> DgsSchemaProvider.schema$lambda-3(this));
        DataFetcher<Object> entityFetcher = federationResolverInstance.entitiesFetcher();
        TypeResolver typeResolver = federationResolverInstance.typeResolver();
        GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry().fieldVisibility(fieldVisibility);
        if (this.defaultDataFetcherFactory.isPresent()) {
            codeRegistryBuilder.defaultDataFetcher(this.defaultDataFetcherFactory.get());
        }
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring().codeRegistry(codeRegistryBuilder).fieldVisibility(fieldVisibility);
        element$iv22 = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)dgsComponents), (Function1)((Function1)new Function1<Object, TypeDefinitionRegistry>(this, (Ref.ObjectRef<TypeDefinitionRegistry>)mergedRegistry2){
            final /* synthetic */ DgsSchemaProvider this$0;
            final /* synthetic */ Ref.ObjectRef<TypeDefinitionRegistry> $mergedRegistry;
            {
                this.this$0 = $receiver;
                this.$mergedRegistry = $mergedRegistry;
                super(1);
            }

            @Nullable
            public final TypeDefinitionRegistry invoke(Object dgsComponent) {
                Intrinsics.checkNotNullExpressionValue((Object)dgsComponent, (String)"dgsComponent");
                Object object = this.$mergedRegistry.element;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mergedRegistry");
                return DgsSchemaProvider.access$invokeDgsTypeDefinitionRegistry(this.this$0, dgsComponent, (TypeDefinitionRegistry)object);
            }
        }));
        Object initial$iv = mergedRegistry2.element;
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv5 : $this$fold$iv) {
            void b;
            TypeDefinitionRegistry bl4 = (TypeDefinitionRegistry)element$iv5;
            TypeDefinitionRegistry a = (TypeDefinitionRegistry)accumulator$iv;
            boolean bl6 = false;
            accumulator$iv = a.merge((TypeDefinitionRegistry)b);
        }
        Intrinsics.checkNotNullExpressionValue((Object)runtimeWiringBuilder, (String)"runtimeWiringBuilder");
        this.findScalars(this.applicationContext, runtimeWiringBuilder);
        this.findDirectives(this.applicationContext, runtimeWiringBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)codeRegistryBuilder, (String)"codeRegistryBuilder");
        Object object2 = mergedRegistry2.element;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"mergedRegistry");
        this.findDataFetchers(dgsComponents, codeRegistryBuilder, (TypeDefinitionRegistry)object2);
        Object object3 = mergedRegistry2.element;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"mergedRegistry");
        this.findTypeResolvers(dgsComponents, runtimeWiringBuilder, (TypeDefinitionRegistry)object3);
        this.findEntityFetchers(dgsComponents);
        Iterable $this$forEach$iv = dgsComponents;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            dgsComponent = element$iv = iterator.next();
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue(dgsComponent, (String)"dgsComponent");
            Object object4 = mergedRegistry2.element;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"mergedRegistry");
            this.invokeDgsCodeRegistry(dgsComponent, codeRegistryBuilder, (TypeDefinitionRegistry)object4);
        }
        runtimeWiringBuilder.codeRegistry(codeRegistryBuilder.build());
        $this$forEach$iv = dgsComponents;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            dgsComponent = element$iv = iterator.next();
            boolean bl8 = false;
            Intrinsics.checkNotNullExpressionValue(dgsComponent, (String)"dgsComponent");
            this.invokeDgsRuntimeWiring(dgsComponent, runtimeWiringBuilder);
        }
        GraphQLSchema graphQLSchema = Federation.transform((TypeDefinitionRegistry)((TypeDefinitionRegistry)mergedRegistry2.element), (RuntimeWiring)runtimeWiringBuilder.build()).fetchEntities(entityFetcher).resolveEntityType(typeResolver).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema, (String)"transform(mergedRegistry\u2026ype(typeResolver).build()");
        GraphQLSchema graphQLSchema2 = graphQLSchema;
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        logger.debug("DGS initialized schema in {}ms", (Object)totalTime);
        return !((Collection)this.mockProviders).isEmpty() ? new DgsSchemaTransformer().transformSchemaWithMockProviders(graphQLSchema2, this.mockProviders) : graphQLSchema2;
    }

    public static /* synthetic */ GraphQLSchema schema$default(DgsSchemaProvider dgsSchemaProvider, String string, GraphqlFieldVisibility graphqlFieldVisibility, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            DefaultGraphqlFieldVisibility defaultGraphqlFieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
            Intrinsics.checkNotNullExpressionValue((Object)defaultGraphqlFieldVisibility, (String)"DEFAULT_FIELD_VISIBILITY");
            graphqlFieldVisibility = (GraphqlFieldVisibility)defaultGraphqlFieldVisibility;
        }
        return dgsSchemaProvider.schema(string, graphqlFieldVisibility);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeDefinitionRegistry invokeDgsTypeDefinitionRegistry(Object dgsComponent, TypeDefinitionRegistry registry) {
        Object v1;
        Method[] methodArray = dgsComponent.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"dgsComponent.javaClass.methods");
        Sequence $this$reduceOrNull$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)invokeDgsTypeDefinitionRegistry.1.INSTANCE), (Function1)((Function1)new Function1<Method, TypeDefinitionRegistry>(dgsComponent, registry){
            final /* synthetic */ Object $dgsComponent;
            final /* synthetic */ TypeDefinitionRegistry $registry;
            {
                this.$dgsComponent = $dgsComponent;
                this.$registry = $registry;
                super(1);
            }

            @NotNull
            public final TypeDefinitionRegistry invoke(Method method) {
                TypeDefinitionRegistry typeDefinitionRegistry;
                if (!Intrinsics.areEqual(method.getReturnType(), TypeDefinitionRegistry.class)) {
                    throw new InvalidDgsConfigurationException("Method annotated with @DgsTypeDefinitionRegistry must have return type TypeDefinitionRegistry");
                }
                if (method.getParameterCount() == 1 && Intrinsics.areEqual(method.getParameterTypes()[0], TypeDefinitionRegistry.class)) {
                    Object[] objectArray = new Object[]{this.$registry};
                    Object object = ReflectionUtils.invokeMethod((Method)method, (Object)this.$dgsComponent, (Object[])objectArray);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type graphql.schema.idl.TypeDefinitionRegistry");
                    }
                    typeDefinitionRegistry = (TypeDefinitionRegistry)object;
                } else {
                    Object object = ReflectionUtils.invokeMethod((Method)method, (Object)this.$dgsComponent);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type graphql.schema.idl.TypeDefinitionRegistry");
                    }
                    typeDefinitionRegistry = (TypeDefinitionRegistry)object;
                }
                return typeDefinitionRegistry;
            }
        }));
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                TypeDefinitionRegistry typeDefinitionRegistry = (TypeDefinitionRegistry)iterator$iv.next();
                TypeDefinitionRegistry a = (TypeDefinitionRegistry)accumulator$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)a.merge((TypeDefinitionRegistry)b), (String)"a.merge(b)");
            }
            v1 = accumulator$iv;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    private final void invokeDgsCodeRegistry(Object dgsComponent, GraphQLCodeRegistry.Builder codeRegistryBuilder, TypeDefinitionRegistry registry) {
        void $this$forEach$iv;
        Method[] methodArray = dgsComponent.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"dgsComponent.javaClass.methods");
        Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)invokeDgsCodeRegistry.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(method.getReturnType(), GraphQLCodeRegistry.Builder.class)) {
                throw new InvalidDgsConfigurationException("Method annotated with @DgsCodeRegistry must have return type GraphQLCodeRegistry.Builder");
            }
            if (method.getParameterCount() != 2 || !Intrinsics.areEqual(method.getParameterTypes()[0], GraphQLCodeRegistry.Builder.class) || !Intrinsics.areEqual(method.getParameterTypes()[1], TypeDefinitionRegistry.class)) {
                StringBuilder stringBuilder = new StringBuilder().append("Method annotated with @DgsCodeRegistry must accept the following arguments: GraphQLCodeRegistry.Builder, TypeDefinitionRegistry. ").append(dgsComponent.getClass().getName()).append('.').append(method.getName()).append(" has the following arguments: ");
                Class<?>[] classArray = method.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"method.parameterTypes");
                throw new InvalidDgsConfigurationException(stringBuilder.append(ArraysKt.joinToString$default((Object[])classArray, null, null, null, (int)0, null, null, (int)63, null)).toString());
            }
            Object[] objectArray = new Object[]{codeRegistryBuilder, registry};
            ReflectionUtils.invokeMethod((Method)method, (Object)dgsComponent, (Object[])objectArray);
        }
    }

    private final void invokeDgsRuntimeWiring(Object dgsComponent, RuntimeWiring.Builder runtimeWiringBuilder) {
        Method[] methodArray = dgsComponent.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"dgsComponent.javaClass.methods");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)invokeDgsRuntimeWiring.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(method.getReturnType(), RuntimeWiring.Builder.class)) {
                throw new InvalidDgsConfigurationException("Method annotated with @DgsRuntimeWiring must have return type RuntimeWiring.Builder");
            }
            if (method.getParameterCount() != 1 || !Intrinsics.areEqual(method.getParameterTypes()[0], RuntimeWiring.Builder.class)) {
                StringBuilder stringBuilder = new StringBuilder().append("Method annotated with @DgsRuntimeWiring must accept an argument of type RuntimeWiring.Builder. ").append(dgsComponent.getClass().getName()).append('.').append(method.getName()).append(" has the following arguments: ");
                Class<?>[] classArray = method.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"method.parameterTypes");
                throw new InvalidDgsConfigurationException(stringBuilder.append(ArraysKt.joinToString$default((Object[])classArray, null, null, null, (int)0, null, null, (int)63, null)).toString());
            }
            Object[] objectArray = new Object[]{runtimeWiringBuilder};
            ReflectionUtils.invokeMethod((Method)method, (Object)dgsComponent, (Object[])objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findDataFetchers(Collection<? extends Object> dgsComponents, GraphQLCodeRegistry.Builder codeRegistryBuilder, TypeDefinitionRegistry typeDefinitionRegistry) {
        Iterable $this$forEach$iv = dgsComponents;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            Method[] methodArray = ReflectionUtils.getUniqueDeclaredMethods((Class)javaClass, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getUniqueDeclaredMethods\u2026ls.USER_DECLARED_METHODS)");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)findDataFetchers.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Method method = (Method)element$iv2;
                boolean bl2 = false;
                MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
                mergedAnnotations.stream(DgsData.class).forEach(arg_0 -> DgsSchemaProvider.findDataFetchers$lambda-12$lambda-11$lambda-10(this, typeDefinitionRegistry, codeRegistryBuilder, dgsComponent, method, mergedAnnotations, arg_0));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerDataFetcher(TypeDefinitionRegistry typeDefinitionRegistry, GraphQLCodeRegistry.Builder codeRegistryBuilder, Object dgsComponent, Method method, MergedAnnotation<DgsData> dgsDataAnnotation, MergedAnnotations mergedAnnotations) {
        boolean bl;
        CharSequence charSequence;
        CharSequence charSequence2 = dgsDataAnnotation.getString("field");
        if (charSequence2.length() == 0) {
            boolean bl2 = false;
            charSequence = method.getName();
        } else {
            charSequence = charSequence2;
        }
        String field = (String)charSequence;
        String parentType = dgsDataAnnotation.getString("parentType");
        Intrinsics.checkNotNullExpressionValue((Object)parentType, (String)"parentType");
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
        this.dataFetchers.add(new DatafetcherReference(dgsComponent, method, mergedAnnotations, parentType, field));
        if (method.isAnnotationPresent(DgsEnableDataFetcherInstrumentation.class)) {
            DgsEnableDataFetcherInstrumentation dgsEnableDataFetcherInstrumentation = method.getAnnotation(DgsEnableDataFetcherInstrumentation.class);
            bl = dgsEnableDataFetcherInstrumentation.value();
        } else {
            bl = !Intrinsics.areEqual(method.getReturnType(), CompletionStage.class) && !Intrinsics.areEqual(method.getReturnType(), CompletableFuture.class);
        }
        boolean enableInstrumentation = bl;
        Boolean bl3 = enableInstrumentation;
        this.dataFetcherInstrumentationEnabled.put(parentType + '.' + field, bl3);
        try {
            if (!typeDefinitionRegistry.getType(parentType).isPresent()) {
                logger.error("Parent type " + parentType + " not found, but it was referenced in " + this.getClass().getName() + " in @DgsData annotation for field " + field);
                throw new InvalidDgsConfigurationException("Parent type " + parentType + " not found, but it was referenced on " + this.getClass().getName() + " in @DgsData annotation for field " + field);
            }
            Object t = typeDefinitionRegistry.getType(parentType).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"typeDefinitionRegistry.getType(parentType).get()");
            TypeDefinition type = (TypeDefinition)t;
            if (type instanceof InterfaceTypeDefinition) {
                List implementationsOf = typeDefinitionRegistry.getImplementationsOf((InterfaceTypeDefinition)type);
                Intrinsics.checkNotNullExpressionValue((Object)implementationsOf, (String)"implementationsOf");
                Iterable $this$forEach$iv = implementationsOf;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ObjectTypeDefinition implType = (ObjectTypeDefinition)element$iv;
                    boolean bl4 = false;
                    DataFetcher<Object> dataFetcher = this.createBasicDataFetcher(method, dgsComponent, Intrinsics.areEqual((Object)parentType, (Object)"Subscription"));
                    codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)implType.getName(), (String)field), dataFetcher);
                    Boolean bl5 = enableInstrumentation;
                    this.dataFetcherInstrumentationEnabled.put(implType.getName() + '.' + field, bl5);
                }
            } else if (type instanceof UnionTypeDefinition) {
                void $this$forEach$iv;
                List list = ((UnionTypeDefinition)type).getMemberTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"type.memberTypes");
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)list);
                boolean $i$f$filterIsInstance = false;
                $this$filterIsInstance$iv = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)registerDataFetcher$$inlined$filterIsInstance$1.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TypeName memberType = (TypeName)element$iv;
                    boolean bl6 = false;
                    DataFetcher<Object> dataFetcher = this.createBasicDataFetcher(method, dgsComponent, Intrinsics.areEqual((Object)parentType, (Object)"Subscription"));
                    codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)memberType.getName(), (String)field), dataFetcher);
                    Boolean bl7 = enableInstrumentation;
                    this.dataFetcherInstrumentationEnabled.put(memberType.getName() + '.' + field, bl7);
                }
            } else {
                DataFetcher<Object> dataFetcher = this.createBasicDataFetcher(method, dgsComponent, Intrinsics.areEqual((Object)parentType, (Object)"Subscription"));
                codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)parentType, (String)field), dataFetcher);
            }
        }
        catch (Exception ex) {
            logger.error("Invalid parent type " + parentType);
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findEntityFetchers(Collection<? extends Object> dgsComponents) {
        Iterable $this$forEach$iv = dgsComponents;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            Method[] methodArray = ReflectionUtils.getDeclaredMethods((Class)javaClass);
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(javaClass)");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)findEntityFetchers.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Method method = (Method)element$iv2;
                boolean bl2 = false;
                DgsEntityFetcher dgsEntityFetcherAnnotation = method.getAnnotation(DgsEntityFetcher.class);
                DgsEnableDataFetcherInstrumentation dgsEnableDataFetcherInstrumentation = method.getAnnotation(DgsEnableDataFetcherInstrumentation.class);
                boolean enableInstrumentation = dgsEnableDataFetcherInstrumentation != null ? dgsEnableDataFetcherInstrumentation.value() : false;
                Boolean bl3 = enableInstrumentation;
                this.dataFetcherInstrumentationEnabled.put("__entities." + dgsEntityFetcherAnnotation.name(), bl3);
                this.entityFetcherRegistry.getEntityFetchers().put(dgsEntityFetcherAnnotation.name(), (Pair<Object, Method>)TuplesKt.to(dgsComponent, (Object)method));
            }
        }
    }

    private final DataFetcher<Object> createBasicDataFetcher(Method method, Object dgsComponent, boolean isSubscription) {
        DataFetcher<Object> dataFetcher = this.methodDataFetcherFactory.createDataFetcher(dgsComponent, method);
        if (isSubscription) {
            return dataFetcher;
        }
        DataFetcher dataFetcher2 = DataFetcherFactories.wrapDataFetcher(dataFetcher, (arg_0, arg_1) -> DgsSchemaProvider.createBasicDataFetcher$lambda-20(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcher2, (String)"wrapDataFetcher(dataFetc\u2026t\n            }\n        }");
        return dataFetcher2;
    }

    /*
     * WARNING - void declaration
     */
    private final void findTypeResolvers(Collection<? extends Object> dgsComponents, RuntimeWiring.Builder runtimeWiringBuilder, TypeDefinitionRegistry mergedRegistry2) {
        Sequence unregisteredTypes2;
        Set registeredTypeResolvers = new LinkedHashSet();
        Iterable $this$forEach$iv = dgsComponents;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            Method[] methodArray = javaClass.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"javaClass.methods");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)findTypeResolvers.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DgsDefaultTypeResolver defaultTypeResolver;
                boolean overrideTypeResolver;
                DgsTypeResolver annotation;
                Method method;
                block12: {
                    method = (Method)element$iv2;
                    boolean bl2 = false;
                    annotation = method.getAnnotation(DgsTypeResolver.class);
                    if (!Intrinsics.areEqual(method.getReturnType(), String.class)) {
                        throw new InvalidTypeResolverException("@DgsTypeResolvers must return String");
                    }
                    if (method.getParameterCount() != 1) {
                        throw new InvalidTypeResolverException("@DgsTypeResolvers must take exactly one parameter");
                    }
                    if (!mergedRegistry2.hasType(new TypeName(annotation.name()))) {
                        throw new InvalidTypeResolverException("could not find type name '" + annotation.name() + "' in schema");
                    }
                    overrideTypeResolver = false;
                    defaultTypeResolver = method.getAnnotation(DgsDefaultTypeResolver.class);
                    if (defaultTypeResolver != null) {
                        boolean bl3;
                        Iterable $this$any$iv = dgsComponents;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            Iterator iterator2 = $this$any$iv.iterator();
                            while (iterator2.hasNext()) {
                                boolean bl4;
                                block11: {
                                    Object element$iv3;
                                    Object component = element$iv3 = iterator2.next();
                                    boolean bl5 = false;
                                    Method[] methodArray2 = component.getClass().getMethods();
                                    Intrinsics.checkNotNullExpressionValue((Object)methodArray2, (String)"component.javaClass.methods");
                                    Object[] $this$any$iv2 = methodArray2;
                                    boolean $i$f$any2 = false;
                                    for (Object element$iv4 : $this$any$iv2) {
                                        Method method2 = (Method)element$iv4;
                                        boolean bl6 = false;
                                        boolean bl7 = method2.isAnnotationPresent(DgsTypeResolver.class) && Intrinsics.areEqual((Object)method2.getAnnotation(DgsTypeResolver.class).name(), (Object)annotation.name()) && !Intrinsics.areEqual(component, dgsComponent);
                                        if (!bl7) continue;
                                        bl4 = true;
                                        break block11;
                                    }
                                    bl4 = false;
                                }
                                if (!bl4) continue;
                                bl3 = true;
                                break block12;
                            }
                            bl3 = overrideTypeResolver = false;
                        }
                    }
                }
                if (defaultTypeResolver != null && overrideTypeResolver) continue;
                registeredTypeResolvers.add(annotation.name());
                runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)annotation.name()).typeResolver(arg_0 -> DgsSchemaProvider.findTypeResolvers$lambda-25$lambda-24$lambda-23(method, dgsComponent, arg_0)));
            }
        }
        Map map = mergedRegistry2.types();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"mergedRegistry.types()");
        Sequence $this$forEach$iv3 = unregisteredTypes2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence((Map)map), (Function1)findTypeResolvers.unregisteredTypes.1.INSTANCE), (Function1)findTypeResolvers.unregisteredTypes.2.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>((Set<String>)registeredTypeResolvers){
            final /* synthetic */ Set<String> $registeredTypeResolvers;
            {
                this.$registeredTypeResolvers = $registeredTypeResolvers;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return !this.$registeredTypeResolvers.contains(it);
            }
        }));
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            String it = (String)element$iv;
            boolean bl = false;
            runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)it).typeResolver(DgsSchemaProvider::findTypeResolvers$lambda-27$lambda-26));
        }
    }

    private final void findScalars(ApplicationContext applicationContext, RuntimeWiring.Builder runtimeWiringBuilder) {
        Map map = applicationContext.getBeansWithAnnotation(DgsScalar.class);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"applicationContext.getBe\u2026on(DgsScalar::class.java)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Object scalarComponent = entry.getValue();
            DgsScalar annotation = scalarComponent.getClass().getAnnotation(DgsScalar.class);
            if (scalarComponent instanceof Coercing) {
                runtimeWiringBuilder.scalar(GraphQLScalarType.newScalar().name(annotation.name()).coercing((Coercing)scalarComponent).build());
                continue;
            }
            throw new RuntimeException("Invalid @DgsScalar type: the class must implement graphql.schema.Coercing");
        }
    }

    private final void findDirectives(ApplicationContext applicationContext, RuntimeWiring.Builder runtimeWiringBuilder) {
        Map map = applicationContext.getBeansWithAnnotation(DgsDirective.class);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"applicationContext.getBe\u2026DgsDirective::class.java)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Object directiveComponent = entry.getValue();
            DgsDirective annotation = directiveComponent.getClass().getAnnotation(DgsDirective.class);
            if (directiveComponent instanceof SchemaDirectiveWiring) {
                if (!StringsKt.isBlank((CharSequence)annotation.name())) {
                    runtimeWiringBuilder.directive(annotation.name(), (SchemaDirectiveWiring)directiveComponent);
                    continue;
                }
                runtimeWiringBuilder.directiveWiring((SchemaDirectiveWiring)directiveComponent);
                continue;
            }
            throw new RuntimeException("Invalid @DgsDirective type: the class must implement graphql.schema.idl.SchemaDirectiveWiring");
        }
    }

    @NotNull
    public final List<Resource> findSchemaFiles$graphql_dgs(boolean hasDynamicTypeRegistry) {
        Object[] objectArray;
        List resources2;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(cl);
        try {
            resources2 = SequencesKt.toMutableList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.schemaLocations), (Function1)((Function1)new Function1<String, Sequence<? extends Resource>>(resolver){
                final /* synthetic */ PathMatchingResourcePatternResolver $resolver;
                {
                    this.$resolver = $resolver;
                    super(1);
                }

                @NotNull
                public final Sequence<Resource> invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Resource[] resourceArray = this.$resolver.getResources(it);
                    Intrinsics.checkNotNullExpressionValue((Object)resourceArray, (String)"resolver.getResources(it)");
                    return ArraysKt.asSequence((Object[])resourceArray);
                }
            }))));
            if (resources2.isEmpty()) {
                throw new NoSchemaFoundException();
            }
        }
        catch (Exception ex) {
            if (!this.existingTypeDefinitionRegistry.isPresent() && !hasDynamicTypeRegistry) {
                logger.error("No schema files found in " + this.schemaLocations + ". Define schema locations with property dgs.graphql.schema-locations");
                throw new NoSchemaFoundException();
            }
            logger.info("No schema files found, but a schema was provided as an TypeDefinitionRegistry");
            resources2 = new ArrayList();
        }
        List schemas2 = resources2;
        try {
            objectArray = resolver.getResources("classpath*:META-INF/schema/**/*.graphql*");
        }
        catch (Exception ex) {
            objectArray = new Resource[]{};
        }
        Object[] metaInfSchemas = objectArray;
        Collection collection = schemas2;
        Intrinsics.checkNotNullExpressionValue((Object)metaInfSchemas, (String)"metaInfSchemas");
        CollectionsKt.addAll((Collection)collection, (Object[])metaInfSchemas);
        return schemas2;
    }

    public static /* synthetic */ List findSchemaFiles$graphql_dgs$default(DgsSchemaProvider dgsSchemaProvider, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return dgsSchemaProvider.findSchemaFiles$graphql_dgs(bl);
    }

    private static final DgsFederationResolver schema$lambda-3(DgsSchemaProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new DefaultDgsFederationResolver(this$0.entityFetcherRegistry, this$0.dataFetcherExceptionHandler);
    }

    private static final void findDataFetchers$lambda-12$lambda-11$lambda-10(DgsSchemaProvider this$0, TypeDefinitionRegistry $typeDefinitionRegistry, GraphQLCodeRegistry.Builder $codeRegistryBuilder, Object $dgsComponent, Method $method, MergedAnnotations $mergedAnnotations, MergedAnnotation dgsDataAnnotation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$typeDefinitionRegistry, (String)"$typeDefinitionRegistry");
        Intrinsics.checkNotNullParameter((Object)$codeRegistryBuilder, (String)"$codeRegistryBuilder");
        Intrinsics.checkNotNullParameter((Object)$dgsComponent, (String)"$dgsComponent");
        Intrinsics.checkNotNullExpressionValue((Object)$method, (String)"method");
        Intrinsics.checkNotNullExpressionValue((Object)dgsDataAnnotation, (String)"dgsDataAnnotation");
        Intrinsics.checkNotNullExpressionValue((Object)$mergedAnnotations, (String)"mergedAnnotations");
        this$0.registerDataFetcher($typeDefinitionRegistry, $codeRegistryBuilder, $dgsComponent, $method, (MergedAnnotation<DgsData>)dgsDataAnnotation, $mergedAnnotations);
    }

    private static final Object createBasicDataFetcher$lambda-20(DgsSchemaProvider this$0, DataFetchingEnvironment dfe, Object result) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object2 = result;
        if (object2 != null) {
            Object v1;
            DgsDataFetchingEnvironment env;
            block4: {
                Object it = object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)dfe, (String)"dfe");
                env = new DgsDataFetchingEnvironment(dfe);
                Iterable iterable = this$0.dataFetcherResultProcessors;
                for (Object t : iterable) {
                    DataFetcherResultProcessor it2 = (DataFetcherResultProcessor)t;
                    boolean bl2 = false;
                    if (!it2.supportsType(result)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            if ((object = (DataFetcherResultProcessor)v1) == null || (object = object.process(result, env)) == null) {
                object = result;
            }
        } else {
            object = null;
        }
        return object;
    }

    private static final GraphQLObjectType findTypeResolvers$lambda-25$lambda-24$lambda-23(Method $method, Object $dgsComponent, TypeResolutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)$dgsComponent, (String)"$dgsComponent");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Object[] objectArray = new Object[]{env.getObject()};
        Object object = ReflectionUtils.invokeMethod((Method)$method, (Object)$dgsComponent, (Object[])objectArray);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String typeName = (String)object;
        return env.getSchema().getObjectType(typeName);
    }

    private static final GraphQLObjectType findTypeResolvers$lambda-27$lambda-26(TypeResolutionEnvironment env) {
        GraphQLObjectType resolvedType;
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Object instance = env.getObject();
        GraphQLObjectType graphQLObjectType = resolvedType = env.getSchema().getObjectType(instance.getClass().getSimpleName());
        if (graphQLObjectType == null) {
            throw new InvalidTypeResolverException("The default type resolver could not find a suitable Java type for GraphQL type `" + instance.getClass().getSimpleName() + ". Provide a @DgsTypeResolver.`");
        }
        return graphQLObjectType;
    }

    public static final /* synthetic */ TypeDefinitionRegistry access$invokeDgsTypeDefinitionRegistry(DgsSchemaProvider $this, Object dgsComponent, TypeDefinitionRegistry registry) {
        return $this.invokeDgsTypeDefinitionRegistry(dgsComponent, registry);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsSchemaProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsSchemaProvider::class.java)");
        DgsSchemaProvider.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider$Companion;", "", "()V", "DEFAULT_SCHEMA_LOCATION", "", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

