/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.method;

import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.MethodParameter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/internal/method/ArgumentResolverComposite;", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "argumentResolvers", "", "(Ljava/util/List;)V", "argumentResolverCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/springframework/core/MethodParameter;", "getArgumentResolver", "parameter", "resolveArgument", "", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "supportsParameter", "", "graphql-dgs"})
public final class ArgumentResolverComposite
implements ArgumentResolver {
    @NotNull
    private final List<ArgumentResolver> argumentResolvers;
    @NotNull
    private final ConcurrentMap<MethodParameter, ArgumentResolver> argumentResolverCache;

    public ArgumentResolverComposite(@NotNull List<? extends ArgumentResolver> argumentResolvers) {
        Intrinsics.checkNotNullParameter(argumentResolvers, (String)"argumentResolvers");
        this.argumentResolvers = argumentResolvers;
        this.argumentResolverCache = new ConcurrentHashMap();
    }

    @Override
    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return this.getArgumentResolver(parameter) != null;
    }

    @Override
    @Nullable
    public Object resolveArgument(@NotNull MethodParameter parameter, @NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ArgumentResolver argumentResolver = this.getArgumentResolver(parameter);
        if (argumentResolver == null) {
            throw new IllegalArgumentException("Unsupported parameter type [" + parameter.getParameterType().getName() + "]. supportsParameter should be called first.");
        }
        ArgumentResolver resolver = argumentResolver;
        return resolver.resolveArgument(parameter, dfe);
    }

    private final ArgumentResolver getArgumentResolver(MethodParameter parameter) {
        ArgumentResolver cachedResolver = (ArgumentResolver)this.argumentResolverCache.get(parameter);
        if (cachedResolver != null) {
            return cachedResolver;
        }
        for (ArgumentResolver resolver : this.argumentResolvers) {
            if (!resolver.supportsParameter(parameter)) continue;
            ((Map)this.argumentResolverCache).put(parameter, resolver);
            return resolver;
        }
        return null;
    }
}

