/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.method;

import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.exceptions.DgsInvalidInputArgumentException;
import com.netflix.graphql.dgs.internal.InputObjectMapper;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/netflix/graphql/dgs/internal/method/InputArgumentResolver;", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "inputObjectMapper", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "argumentNameCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/springframework/core/MethodParameter;", "", "conversionService", "Lorg/springframework/core/convert/support/DefaultConversionService;", "convertValue", "", "source", "target", "Lorg/springframework/core/convert/TypeDescriptor;", "getArgumentName", "parameter", "resolveArgument", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "supportsParameter", "", "Companion", "ObjectMapperConverter", "graphql-dgs"})
public final class InputArgumentResolver
implements ArgumentResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<MethodParameter, String> argumentNameCache;
    @NotNull
    private final DefaultConversionService conversionService;
    @NotNull
    private static final Logger logger;

    public InputArgumentResolver(@NotNull InputObjectMapper inputObjectMapper) {
        Intrinsics.checkNotNullParameter((Object)inputObjectMapper, (String)"inputObjectMapper");
        this.argumentNameCache = new ConcurrentHashMap();
        this.conversionService = new DefaultConversionService();
        this.conversionService.addConverter((GenericConverter)new ObjectMapperConverter(inputObjectMapper));
    }

    @Override
    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return parameter.hasParameterAnnotation(InputArgument.class);
    }

    @Override
    @Nullable
    public Object resolveArgument(@NotNull MethodParameter parameter, @NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        String argumentName = this.getArgumentName(parameter);
        Object value = dfe.getArgument(argumentName);
        TypeDescriptor typeDescriptor = new TypeDescriptor(parameter);
        Object convertedValue = this.convertValue(value, typeDescriptor);
        if (convertedValue == null) {
            boolean bl;
            block5: {
                List list = dfe.getFieldDefinition().getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dfe.fieldDefinition.arguments");
                Iterable $this$none$iv = list;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        GraphQLArgument it = (GraphQLArgument)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)argumentName)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                logger.warn("Unknown argument '{}'", (Object)argumentName);
            }
        }
        return convertedValue;
    }

    private final String getArgumentName(MethodParameter parameter) {
        CharSequence charSequence;
        String cachedName = (String)this.argumentNameCache.get(parameter);
        if (cachedName != null) {
            return cachedName;
        }
        InputArgument inputArgument = (InputArgument)parameter.getParameterAnnotation(InputArgument.class);
        if (inputArgument == null) {
            throw new IllegalArgumentException("Unsupported parameter type [" + parameter.getParameterType().getName() + "]. supportsParameter should be called first.");
        }
        InputArgument annotation = inputArgument;
        InputArgument mergedAnnotation = (InputArgument)MergedAnnotation.from((Annotation)annotation).synthesize();
        CharSequence charSequence2 = mergedAnnotation.name();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = parameter.getParameterName();
        } else {
            charSequence = charSequence2;
        }
        String string = (String)charSequence;
        if (string == null) {
            throw new IllegalArgumentException("Name for argument of type [" + parameter.getNestedParameterType().getName() + "} not specified, and parameter name information not found in class file either.");
        }
        String name = string;
        ((Map)this.argumentNameCache).put(parameter, name);
        return name;
    }

    private final Object convertValue(Object source, TypeDescriptor target) {
        if (source == null) {
            return Intrinsics.areEqual((Object)target.getType(), Optional.class) ? Optional.empty() : null;
        }
        if (target.getResolvableType().isInstance(source)) {
            return source;
        }
        if (Intrinsics.areEqual((Object)target.getType(), Optional.class)) {
            int[] nArray = new int[]{0};
            TypeDescriptor elementType = TypeDescriptor.valueOf((Class)target.getResolvableType().getGeneric(nArray).toClass());
            Intrinsics.checkNotNullExpressionValue((Object)elementType, (String)"elementType");
            return Optional.ofNullable(this.convertValue(source, elementType));
        }
        TypeDescriptor sourceType = TypeDescriptor.forObject((Object)source);
        if (this.conversionService.canConvert(sourceType, target)) {
            return this.conversionService.convert(source, sourceType, target);
        }
        throw new DgsInvalidInputArgumentException("Unable to convert from " + source.getClass() + " to " + target.getType(), null, 2, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(InputArgumentResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(InputArgumentResolver::class.java)");
        InputArgumentResolver.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/internal/method/InputArgumentResolver$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/internal/method/InputArgumentResolver$ObjectMapperConverter;", "Lorg/springframework/core/convert/converter/ConditionalGenericConverter;", "inputObjectMapper", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "convert", "", "source", "sourceType", "Lorg/springframework/core/convert/TypeDescriptor;", "targetType", "getConvertibleTypes", "", "Lorg/springframework/core/convert/converter/GenericConverter$ConvertiblePair;", "matches", "", "graphql-dgs"})
    private static final class ObjectMapperConverter
    implements ConditionalGenericConverter {
        @NotNull
        private final InputObjectMapper inputObjectMapper;

        public ObjectMapperConverter(@NotNull InputObjectMapper inputObjectMapper) {
            Intrinsics.checkNotNullParameter((Object)inputObjectMapper, (String)"inputObjectMapper");
            this.inputObjectMapper = inputObjectMapper;
        }

        @NotNull
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return SetsKt.setOf((Object)new GenericConverter.ConvertiblePair(Map.class, Object.class));
        }

        public boolean matches(@NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            return sourceType.isMap() && !targetType.isMap();
        }

        @NotNull
        public Object convert(@Nullable Object source, @NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
            Object t;
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Object object = source;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            }
            Map mapInput = (Map)object;
            if (KotlinDetector.isKotlinType((Class)targetType.getType())) {
                Class clazz = targetType.getType();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"targetType.type");
                t = this.inputObjectMapper.mapToKotlinObject(mapInput, JvmClassMappingKt.getKotlinClass((Class)clazz));
            } else {
                Class clazz = targetType.getType();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"targetType.type");
                t = this.inputObjectMapper.mapToJavaObject(mapInput, clazz);
            }
            Object t2 = t;
            Intrinsics.checkNotNullExpressionValue(t2, (String)"if (KotlinDetector.isKot\u2026tType.type)\n            }");
            return t2;
        }
    }
}

