/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jt\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/netflix/graphql/dgs/internal/BaseDgsQueryExecutor;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "parseContext", "Lcom/jayway/jsonpath/ParseContext;", "getParseContext", "()Lcom/jayway/jsonpath/ParseContext;", "baseExecute", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/ExecutionResult;", "query", "", "variables", "", "operationName", "dgsContext", "Lcom/netflix/graphql/dgs/context/DgsContext;", "graphQLSchema", "Lgraphql/schema/GraphQLSchema;", "dataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "chainedInstrumentation", "Lgraphql/execution/instrumentation/ChainedInstrumentation;", "queryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "mutationExecutionStrategy", "idProvider", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionIdProvider;", "graphql-dgs"})
public final class BaseDgsQueryExecutor {
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final ParseContext parseContext;
    @NotNull
    public static final BaseDgsQueryExecutor INSTANCE;

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @NotNull
    public final ParseContext getParseContext() {
        return parseContext;
    }

    @NotNull
    public final CompletableFuture<? extends ExecutionResult> baseExecute(@NotNull String query, @Nullable Map<String, ? extends Object> variables, @Nullable String operationName, @NotNull DgsContext dgsContext, @NotNull GraphQLSchema graphQLSchema2, @NotNull DgsDataLoaderProvider dataLoaderProvider, @NotNull ChainedInstrumentation chainedInstrumentation, @NotNull ExecutionStrategy queryExecutionStrategy, @NotNull ExecutionStrategy mutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider) {
        CompletableFuture<ExecutionResultImpl> completableFuture;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)dgsContext, (String)"dgsContext");
        Intrinsics.checkNotNullParameter((Object)graphQLSchema2, (String)"graphQLSchema");
        Intrinsics.checkNotNullParameter((Object)dataLoaderProvider, (String)"dataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)chainedInstrumentation, (String)"chainedInstrumentation");
        Intrinsics.checkNotNullParameter((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        GraphQL.Builder graphQLBuilder = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema2).instrumentation((Instrumentation)chainedInstrumentation).queryExecutionStrategy(queryExecutionStrategy).mutationExecutionStrategy(mutationExecutionStrategy).subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy());
        if (idProvider.isPresent()) {
            graphQLBuilder.executionIdProvider(idProvider.get());
        }
        GraphQL graphQL = graphQLBuilder.build();
        DataLoaderRegistry dataLoaderRegistry2 = dataLoaderProvider.buildRegistryWithContextSupplier(new Supplier<DgsContext>(dgsContext){
            final /* synthetic */ DgsContext $dgsContext;

            @NotNull
            public final DgsContext get() {
                return this.$dgsContext;
            }
            {
                this.$dgsContext = dgsContext;
            }
        });
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).dataLoaderRegistry(dataLoaderRegistry2).variables(variables).operationName(operationName).context((Object)dgsContext).build();
        Intrinsics.checkNotNullExpressionValue((Object)executionInput, (String)"ExecutionInput.newExecut\u2026ext)\n            .build()");
        ExecutionInput executionInput2 = executionInput;
        try {
            CompletableFuture<ExecutionResultImpl> completableFuture2 = graphQL.executeAsync(executionInput2);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture2, (String)"graphQL.executeAsync(executionInput)");
            completableFuture = completableFuture2;
        }
        catch (Exception e) {
            logger.error("Encountered an exception while handling query " + query, (Throwable)e);
            List errors = e instanceof GraphQLError ? CollectionsKt.listOf((Object)e) : CollectionsKt.emptyList();
            CompletableFuture<ExecutionResultImpl> completableFuture3 = CompletableFuture.completedFuture(new ExecutionResultImpl(null, errors));
            Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"CompletableFuture.comple\u2026ResultImpl(null, errors))");
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    private BaseDgsQueryExecutor() {
    }

    static {
        BaseDgsQueryExecutor baseDgsQueryExecutor;
        INSTANCE = baseDgsQueryExecutor = new BaseDgsQueryExecutor();
        logger = LoggerFactory.getLogger(BaseDgsQueryExecutor.class);
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule()).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        Intrinsics.checkNotNull((Object)objectMapper);
        BaseDgsQueryExecutor.objectMapper = objectMapper;
        ParseContext parseContext = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(ExtensionsKt.jacksonObjectMapper())).mappingProvider((MappingProvider)new JacksonMappingProvider(BaseDgsQueryExecutor.objectMapper)).build().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}));
        Intrinsics.checkNotNullExpressionValue((Object)parseContext, (String)"JsonPath.using(\n        \u2026H_LEAF_TO_NULL)\n        )");
        BaseDgsQueryExecutor.parseContext = parseContext;
    }
}

