/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.DgsDataLoaderRegistryConsumer;
import com.netflix.graphql.dgs.exceptions.InvalidDataLoaderTypeException;
import com.netflix.graphql.dgs.exceptions.UnsupportedSecuredDataLoaderException;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider$sam$org_dataloader_BatchLoaderContextProvider$0;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderContextProvider;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cJ:\u0010\u001d\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0018H\u0002JN\u0010\u001d\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001e\"\u0004\b\u0000\u0010\u001a2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\u0006\u0010 \u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010!\u001a\u00020\u0018H\u0002J:\u0010\u001d\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0018H\u0002JN\u0010\u001d\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001e\"\u0004\b\u0000\u0010\u001a2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00132\u0006\u0010 \u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010!\u001a\u00020\u0018H\u0002J\r\u0010#\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b$J&\u0010%\u001a\u0002H\u001a\"\u0006\b\u0000\u0010\u001a\u0018\u00012\u0006\u0010&\u001a\u0002H\u001a2\u0006\u0010'\u001a\u00020(H\u0082\b\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0005\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lorg/springframework/context/ApplicationContext;)V", "batchLoaders", "", "Lkotlin/Pair;", "Lorg/dataloader/BatchLoader;", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "batchLoadersWithContext", "Lorg/dataloader/BatchLoaderWithContext;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "mappedBatchLoaders", "Lorg/dataloader/MappedBatchLoader;", "mappedBatchLoadersWithContext", "Lorg/dataloader/MappedBatchLoaderWithContext;", "addDataLoaderComponents", "", "addDataLoaderFields", "buildRegistry", "Lorg/dataloader/DataLoaderRegistry;", "buildRegistryWithContextSupplier", "T", "contextSupplier", "Ljava/util/function/Supplier;", "createDataLoader", "Lorg/dataloader/DataLoader;", "batchLoader", "dgsDataLoader", "dataLoaderRegistry", "supplier", "findDataLoaders", "findDataLoaders$graphql_dgs", "wrappedDataLoader", "loader", "name", "", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "graphql-dgs"})
public final class DgsDataLoaderProvider {
    @NotNull
    private final Logger logger;
    private final List<Pair<BatchLoader<?, ?>, DgsDataLoader>> batchLoaders;
    private final List<Pair<BatchLoaderWithContext<?, ?>, DgsDataLoader>> batchLoadersWithContext;
    private final List<Pair<MappedBatchLoader<?, ?>, DgsDataLoader>> mappedBatchLoaders;
    private final List<Pair<MappedBatchLoaderWithContext<?, ?>, DgsDataLoader>> mappedBatchLoadersWithContext;
    private final ApplicationContext applicationContext;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final DataLoaderRegistry buildRegistry() {
        return this.buildRegistryWithContextSupplier(buildRegistry.1.INSTANCE);
    }

    @NotNull
    public final <T> DataLoaderRegistry buildRegistryWithContextSupplier(@NotNull Supplier<T> contextSupplier) {
        Pair it;
        Intrinsics.checkNotNullParameter(contextSupplier, (String)"contextSupplier");
        long startTime = System.currentTimeMillis();
        DataLoaderRegistry dataLoaderRegistry2 = new DataLoaderRegistry();
        Iterable $this$forEach$iv = this.batchLoaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry2.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((BatchLoader)it.getFirst(), (DgsDataLoader)it.getSecond(), dataLoaderRegistry2));
        }
        $this$forEach$iv = this.mappedBatchLoaders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry2.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((MappedBatchLoader)it.getFirst(), (DgsDataLoader)it.getSecond(), dataLoaderRegistry2));
        }
        $this$forEach$iv = this.batchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry2.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((BatchLoaderWithContext)it.getFirst(), (DgsDataLoader)it.getSecond(), contextSupplier, dataLoaderRegistry2));
        }
        $this$forEach$iv = this.mappedBatchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            dataLoaderRegistry2.register(((DgsDataLoader)it.getSecond()).name(), this.createDataLoader((MappedBatchLoaderWithContext)it.getFirst(), (DgsDataLoader)it.getSecond(), contextSupplier, dataLoaderRegistry2));
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        this.logger.debug("Created DGS dataloader registry in {}ms", (Object)totalTime);
        return dataLoaderRegistry2;
    }

    @PostConstruct
    public final void findDataLoaders$graphql_dgs() {
        this.addDataLoaderComponents();
        this.addDataLoaderFields();
    }

    /*
     * WARNING - void declaration
     */
    private final void addDataLoaderFields() {
        Iterable $this$forEach$iv = this.applicationContext.getBeansWithAnnotation(DgsComponent.class).values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Class javaClass;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class clazz = javaClass = AopUtils.getTargetClass(dgsComponent);
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"javaClass");
            Object[] objectArray = clazz.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"javaClass.declaredFields");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)addDataLoaderFields.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl2 = false;
                if (AopUtils.isAopProxy(dgsComponent)) {
                    throw (Throwable)new UnsupportedSecuredDataLoaderException(dgsComponent.getClass());
                }
                DgsDataLoader annotation = field.getAnnotation(DgsDataLoader.class);
                ReflectionUtils.makeAccessible((Field)field);
                Object get = field.get(dgsComponent);
                if (get instanceof BatchLoader) {
                    this.batchLoaders.add(TuplesKt.to((Object)get, (Object)annotation));
                    continue;
                }
                if (get instanceof BatchLoaderWithContext) {
                    this.batchLoadersWithContext.add(TuplesKt.to((Object)get, (Object)annotation));
                    continue;
                }
                if (get instanceof MappedBatchLoader) {
                    this.mappedBatchLoaders.add(TuplesKt.to((Object)get, (Object)annotation));
                    continue;
                }
                if (get instanceof MappedBatchLoaderWithContext) {
                    this.mappedBatchLoadersWithContext.add(TuplesKt.to((Object)get, (Object)annotation));
                    continue;
                }
                throw (Throwable)new InvalidDataLoaderTypeException(dgsComponent.getClass());
            }
        }
    }

    private final void addDataLoaderComponents() {
        Map dataLoaders = this.applicationContext.getBeansWithAnnotation(DgsDataLoader.class);
        Iterable $this$forEach$iv = dataLoaders.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            DgsDataLoader annotation = javaClass.getAnnotation(DgsDataLoader.class);
            Object t = dgsComponent;
            if (t instanceof BatchLoader) {
                this.batchLoaders.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            if (t instanceof BatchLoaderWithContext) {
                this.batchLoadersWithContext.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            if (t instanceof MappedBatchLoader) {
                this.mappedBatchLoaders.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            if (t instanceof MappedBatchLoaderWithContext) {
                this.mappedBatchLoadersWithContext.add(new Pair(dgsComponent, (Object)annotation));
                continue;
            }
            throw (Throwable)new InvalidDataLoaderTypeException(dgsComponent.getClass());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final DataLoader<? extends Object, ? extends Object> createDataLoader(BatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, DataLoaderRegistry dataLoaderRegistry2) {
        BatchLoader extendedBatchLoader;
        BatchLoader batchLoader2;
        DataLoaderOptions options2;
        block11: {
            block12: {
                void this_$iv;
                options2 = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setCachingEnabled(dgsDataLoader.caching());
                if (dgsDataLoader.maxBatchSize() > 0) {
                    options2.setMaxBatchSize(dgsDataLoader.maxBatchSize());
                }
                DgsDataLoaderProvider dgsDataLoaderProvider = this;
                String name$iv = dgsDataLoader.name();
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    Stream stream$iv = ((DgsDataLoaderProvider)this_$iv).applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    BatchLoader batchLoader3 = batchLoader;
                    if (batchLoader3 instanceof BatchLoader) {
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = batchLoader;
                        stream$iv.forEach((Consumer)new Consumer<DataLoaderInstrumentationExtensionProvider>(wrappedBatchLoader$iv, name$iv){
                            final /* synthetic */ Ref.ObjectRef $wrappedBatchLoader;
                            final /* synthetic */ String $name;

                            public final void accept(DataLoaderInstrumentationExtensionProvider it) {
                                this.$wrappedBatchLoader.element = it.provide((BatchLoader)this.$wrappedBatchLoader.element, this.$name);
                            }
                            {
                                this.$wrappedBatchLoader = objectRef;
                                this.$name = string;
                            }
                        });
                        batchLoader2 = (BatchLoader)wrappedBatchLoader$iv.element;
                        if (batchLoader2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        break block11;
                    }
                    if (batchLoader3 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = (BatchLoaderWithContext)batchLoader;
                        stream$iv.forEach((Consumer)new Consumer<DataLoaderInstrumentationExtensionProvider>(wrappedBatchLoader$iv, name$iv){
                            final /* synthetic */ Ref.ObjectRef $wrappedBatchLoader;
                            final /* synthetic */ String $name;

                            public final void accept(DataLoaderInstrumentationExtensionProvider it) {
                                this.$wrappedBatchLoader.element = it.provide((BatchLoaderWithContext)this.$wrappedBatchLoader.element, this.$name);
                            }
                            {
                                this.$wrappedBatchLoader = objectRef;
                                this.$name = string;
                            }
                        });
                        BatchLoaderWithContext batchLoaderWithContext = (BatchLoaderWithContext)wrappedBatchLoader$iv.element;
                        if (batchLoaderWithContext == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = (BatchLoader)batchLoaderWithContext;
                        break block11;
                    }
                    if (batchLoader3 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = (MappedBatchLoader)batchLoader;
                        stream$iv.forEach((Consumer)new Consumer<DataLoaderInstrumentationExtensionProvider>(wrappedBatchLoader$iv, name$iv){
                            final /* synthetic */ Ref.ObjectRef $wrappedBatchLoader;
                            final /* synthetic */ String $name;

                            public final void accept(DataLoaderInstrumentationExtensionProvider it) {
                                this.$wrappedBatchLoader.element = it.provide((MappedBatchLoader)this.$wrappedBatchLoader.element, this.$name);
                            }
                            {
                                this.$wrappedBatchLoader = objectRef;
                                this.$name = string;
                            }
                        });
                        MappedBatchLoader mappedBatchLoader = (MappedBatchLoader)wrappedBatchLoader$iv.element;
                        if (mappedBatchLoader == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = (BatchLoader)mappedBatchLoader;
                        break block11;
                    }
                    if (!(batchLoader3 instanceof MappedBatchLoaderWithContext)) break block12;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = (MappedBatchLoaderWithContext)batchLoader;
                    stream$iv.forEach((Consumer)new Consumer<DataLoaderInstrumentationExtensionProvider>(wrappedBatchLoader$iv, name$iv){
                        final /* synthetic */ Ref.ObjectRef $wrappedBatchLoader;
                        final /* synthetic */ String $name;

                        public final void accept(DataLoaderInstrumentationExtensionProvider it) {
                            this.$wrappedBatchLoader.element = it.provide((MappedBatchLoaderWithContext)this.$wrappedBatchLoader.element, this.$name);
                        }
                        {
                            this.$wrappedBatchLoader = objectRef;
                            this.$name = string;
                        }
                    });
                    MappedBatchLoaderWithContext mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)wrappedBatchLoader$iv.element;
                    if (mappedBatchLoaderWithContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                    }
                    batchLoader2 = (BatchLoader)mappedBatchLoaderWithContext;
                    break block11;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    this_$iv.getLogger().debug("Unable to wrap the [{} : {}]", new Object[]{name$iv, batchLoader, ex$iv});
                }
            }
            batchLoader2 = batchLoader;
        }
        if ((extendedBatchLoader = batchLoader2) instanceof DgsDataLoaderRegistryConsumer) {
            ((DgsDataLoaderRegistryConsumer)extendedBatchLoader).setDataLoaderRegistry(dataLoaderRegistry2);
        }
        return DataLoader.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options2);
    }

    /*
     * WARNING - void declaration
     */
    private final DataLoader<? extends Object, ? extends Object> createDataLoader(MappedBatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, DataLoaderRegistry dataLoaderRegistry2) {
        MappedBatchLoader extendedBatchLoader;
        DataLoaderOptions options2;
        block11: {
            MappedBatchLoader mappedBatchLoader;
            block12: {
                void this_$iv;
                options2 = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setCachingEnabled(dgsDataLoader.caching());
                if (dgsDataLoader.maxBatchSize() > 0) {
                    options2.setMaxBatchSize(dgsDataLoader.maxBatchSize());
                }
                DgsDataLoaderProvider dgsDataLoaderProvider = this;
                String name$iv = dgsDataLoader.name();
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    Stream stream$iv = ((DgsDataLoaderProvider)this_$iv).applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    MappedBatchLoader mappedBatchLoader2 = batchLoader;
                    if (mappedBatchLoader2 instanceof BatchLoader) {
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = (BatchLoader)batchLoader;
                        stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                        BatchLoader batchLoader2 = (BatchLoader)wrappedBatchLoader$iv.element;
                        if (batchLoader2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = (MappedBatchLoader)batchLoader2;
                        break block11;
                    }
                    if (mappedBatchLoader2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = (BatchLoaderWithContext)batchLoader;
                        stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                        BatchLoaderWithContext batchLoaderWithContext = (BatchLoaderWithContext)wrappedBatchLoader$iv.element;
                        if (batchLoaderWithContext == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = (MappedBatchLoader)batchLoaderWithContext;
                        break block11;
                    }
                    if (mappedBatchLoader2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                        mappedBatchLoader = (MappedBatchLoader)wrappedBatchLoader$iv.element;
                        if (mappedBatchLoader == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        break block11;
                    }
                    if (!(mappedBatchLoader2 instanceof MappedBatchLoaderWithContext)) break block12;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = (MappedBatchLoaderWithContext)batchLoader;
                    stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                    MappedBatchLoaderWithContext mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)wrappedBatchLoader$iv.element;
                    if (mappedBatchLoaderWithContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                    }
                    mappedBatchLoader = (MappedBatchLoader)mappedBatchLoaderWithContext;
                    break block11;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    this_$iv.getLogger().debug("Unable to wrap the [{} : {}]", new Object[]{name$iv, batchLoader, ex$iv});
                }
            }
            mappedBatchLoader = extendedBatchLoader = batchLoader;
        }
        if (extendedBatchLoader instanceof DgsDataLoaderRegistryConsumer) {
            ((DgsDataLoaderRegistryConsumer)extendedBatchLoader).setDataLoaderRegistry(dataLoaderRegistry2);
        }
        return DataLoader.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options2);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> DataLoader<? extends Object, ? extends Object> createDataLoader(BatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry2) {
        BatchLoaderWithContext extendedBatchLoader;
        DataLoaderOptions options2;
        block11: {
            BatchLoaderWithContext batchLoaderWithContext;
            block12: {
                void this_$iv;
                Function0 function0 = new Function0<T>(supplier){

                    public final T invoke() {
                        return ((Supplier)this.receiver).get();
                    }
                };
                options2 = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setBatchLoaderContextProvider((BatchLoaderContextProvider)new DgsDataLoaderProvider$sam$org_dataloader_BatchLoaderContextProvider$0(function0)).setCachingEnabled(dgsDataLoader.caching());
                if (dgsDataLoader.maxBatchSize() > 0) {
                    options2.setMaxBatchSize(dgsDataLoader.maxBatchSize());
                }
                DgsDataLoaderProvider dgsDataLoaderProvider = this;
                String name$iv = dgsDataLoader.name();
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    Stream stream$iv = ((DgsDataLoaderProvider)this_$iv).applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    BatchLoaderWithContext batchLoaderWithContext2 = batchLoader;
                    if (batchLoaderWithContext2 instanceof BatchLoader) {
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = (BatchLoader)batchLoader;
                        stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                        BatchLoader batchLoader2 = (BatchLoader)wrappedBatchLoader$iv.element;
                        if (batchLoader2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = (BatchLoaderWithContext)batchLoader2;
                        break block11;
                    }
                    if (batchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                        batchLoaderWithContext = (BatchLoaderWithContext)wrappedBatchLoader$iv.element;
                        if (batchLoaderWithContext == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        break block11;
                    }
                    if (batchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = (MappedBatchLoader)batchLoader;
                        stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                        MappedBatchLoader mappedBatchLoader = (MappedBatchLoader)wrappedBatchLoader$iv.element;
                        if (mappedBatchLoader == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = (BatchLoaderWithContext)mappedBatchLoader;
                        break block11;
                    }
                    if (!(batchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block12;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = (MappedBatchLoaderWithContext)batchLoader;
                    stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                    MappedBatchLoaderWithContext mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)wrappedBatchLoader$iv.element;
                    if (mappedBatchLoaderWithContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                    }
                    batchLoaderWithContext = (BatchLoaderWithContext)mappedBatchLoaderWithContext;
                    break block11;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    this_$iv.getLogger().debug("Unable to wrap the [{} : {}]", new Object[]{name$iv, batchLoader, ex$iv});
                }
            }
            batchLoaderWithContext = extendedBatchLoader = batchLoader;
        }
        if (extendedBatchLoader instanceof DgsDataLoaderRegistryConsumer) {
            ((DgsDataLoaderRegistryConsumer)extendedBatchLoader).setDataLoaderRegistry(dataLoaderRegistry2);
        }
        return DataLoader.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options2);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> DataLoader<? extends Object, ? extends Object> createDataLoader(MappedBatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry2) {
        MappedBatchLoaderWithContext extendedBatchLoader;
        DataLoaderOptions options2;
        block11: {
            MappedBatchLoaderWithContext mappedBatchLoaderWithContext;
            block12: {
                void this_$iv;
                Function0 function0 = new Function0<T>(supplier){

                    public final T invoke() {
                        return ((Supplier)this.receiver).get();
                    }
                };
                options2 = DataLoaderOptions.newOptions().setBatchingEnabled(dgsDataLoader.batching()).setBatchLoaderContextProvider((BatchLoaderContextProvider)new DgsDataLoaderProvider$sam$org_dataloader_BatchLoaderContextProvider$0(function0)).setCachingEnabled(dgsDataLoader.caching());
                if (dgsDataLoader.maxBatchSize() > 0) {
                    options2.setMaxBatchSize(dgsDataLoader.maxBatchSize());
                }
                DgsDataLoaderProvider dgsDataLoaderProvider = this;
                String name$iv = dgsDataLoader.name();
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    Stream stream$iv = ((DgsDataLoaderProvider)this_$iv).applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    MappedBatchLoaderWithContext mappedBatchLoaderWithContext2 = batchLoader;
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoader) {
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = (BatchLoader)batchLoader;
                        stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                        BatchLoader batchLoader2 = (BatchLoader)wrappedBatchLoader$iv.element;
                        if (batchLoader2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)batchLoader2;
                        break block11;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = (BatchLoaderWithContext)batchLoader;
                        stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                        BatchLoaderWithContext batchLoaderWithContext = (BatchLoaderWithContext)wrappedBatchLoader$iv.element;
                        if (batchLoaderWithContext == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)batchLoaderWithContext;
                        break block11;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = (MappedBatchLoader)batchLoader;
                        stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                        MappedBatchLoader mappedBatchLoader = (MappedBatchLoader)wrappedBatchLoader$iv.element;
                        if (mappedBatchLoader == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)mappedBatchLoader;
                        break block11;
                    }
                    if (!(mappedBatchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block12;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = batchLoader;
                    stream$iv.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                    mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)wrappedBatchLoader$iv.element;
                    if (mappedBatchLoaderWithContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                    }
                    break block11;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    this_$iv.getLogger().debug("Unable to wrap the [{} : {}]", new Object[]{name$iv, batchLoader, ex$iv});
                }
            }
            mappedBatchLoaderWithContext = extendedBatchLoader = batchLoader;
        }
        if (extendedBatchLoader instanceof DgsDataLoaderRegistryConsumer) {
            ((DgsDataLoaderRegistryConsumer)extendedBatchLoader).setDataLoaderRegistry(dataLoaderRegistry2);
        }
        return DataLoader.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options2);
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ <T> T wrappedDataLoader(T loader, String name) {
        int $i$f$wrappedDataLoader = 0;
        try {
            Stream stream = this.applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
            T t = loader;
            if (t instanceof BatchLoader) {
                void wrappedBatchLoader;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = (BatchLoader)loader;
                stream.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                BatchLoader batchLoader = (BatchLoader)wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)batchLoader;
            }
            if (t instanceof BatchLoaderWithContext) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = (BatchLoaderWithContext)loader;
                stream.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                BatchLoaderWithContext batchLoaderWithContext = (BatchLoaderWithContext)wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)batchLoaderWithContext;
            }
            if (t instanceof MappedBatchLoader) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = (MappedBatchLoader)loader;
                stream.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                MappedBatchLoader mappedBatchLoader = (MappedBatchLoader)wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)mappedBatchLoader;
            }
            if (t instanceof MappedBatchLoaderWithContext) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = (MappedBatchLoaderWithContext)loader;
                stream.forEach((Consumer)new /* invalid duplicate definition of identical inner class */);
                MappedBatchLoaderWithContext mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)mappedBatchLoaderWithContext;
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.getLogger().debug("Unable to wrap the [{} : {}]", new Object[]{name, loader, ex});
        }
        return loader;
    }

    public DgsDataLoaderProvider(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
        Logger logger = LoggerFactory.getLogger(DgsDataLoaderProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026aderProvider::class.java)");
        this.logger = logger;
        boolean bl = false;
        this.batchLoaders = new ArrayList();
        bl = false;
        this.batchLoadersWithContext = new ArrayList();
        bl = false;
        this.mappedBatchLoaders = new ArrayList();
        bl = false;
        this.mappedBatchLoadersWithContext = new ArrayList();
    }
}

