/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.DgsQueryExecutionDataExtractionException;
import com.netflix.graphql.dgs.exceptions.QueryException;
import com.netflix.graphql.dgs.internal.BaseDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.DgsWebMvcRequestData;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.context.request.WebRequest;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001;BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014JX\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$\u0018\u00010#2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010!2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J7\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#H\u0016\u00a2\u0006\u0002\u0010.J+\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016\u00a2\u0006\u0002\u0010/JO\u00100\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H,022\b\u0010&\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u00103JO\u00100\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H,052\b\u0010&\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u00106J$\u00107\u001a\u0002082\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#H\u0016J.\u00107\u001a\u0002082\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$092\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J0\u0010:\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00030\u00030\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor;", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "defaultSchema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "contextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "chainedInstrumentation", "Lgraphql/execution/instrumentation/ChainedInstrumentation;", "queryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "mutationExecutionStrategy", "idProvider", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionIdProvider;", "reloadIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "(Lgraphql/schema/GraphQLSchema;Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;Lgraphql/execution/instrumentation/ChainedInstrumentation;Lgraphql/execution/ExecutionStrategy;Lgraphql/execution/ExecutionStrategy;Ljava/util/Optional;Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "schema", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "getSchema", "()Ljava/util/concurrent/atomic/AtomicReference;", "execute", "Lgraphql/ExecutionResult;", "query", "", "variables", "", "", "extensions", "headers", "Lorg/springframework/http/HttpHeaders;", "operationName", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "executeAndExtractJsonPath", "T", "jsonPath", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/http/HttpHeaders;)Ljava/lang/Object;", "executeAndExtractJsonPathAsObject", "typeRef", "Lcom/jayway/jsonpath/TypeRef;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lcom/jayway/jsonpath/TypeRef;Lorg/springframework/http/HttpHeaders;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Class;Lorg/springframework/http/HttpHeaders;)Ljava/lang/Object;", "executeAndGetDocumentContext", "Lcom/jayway/jsonpath/DocumentContext;", "", "getJsonResult", "ReloadSchemaIndicator", "graphql-dgs"})
public final class DefaultDgsQueryExecutor
implements DgsQueryExecutor {
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicReference<GraphQLSchema> schema;
    private final DgsSchemaProvider schemaProvider;
    private final DgsDataLoaderProvider dataLoaderProvider;
    private final DefaultDgsGraphQLContextBuilder contextBuilder;
    private final ChainedInstrumentation chainedInstrumentation;
    private final ExecutionStrategy queryExecutionStrategy;
    private final ExecutionStrategy mutationExecutionStrategy;
    private final Optional<ExecutionIdProvider> idProvider;
    private final ReloadSchemaIndicator reloadIndicator;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final AtomicReference<GraphQLSchema> getSchema() {
        return this.schema;
    }

    @NotNull
    public ExecutionResult execute(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions, @Nullable HttpHeaders headers, @Nullable String operationName, @Nullable WebRequest webRequest) {
        ExecutionResult result;
        GraphQLSchema graphQLSchema2;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        if (this.reloadIndicator.reloadSchema()) {
            GraphQLSchema graphQLSchema3 = this.schema.updateAndGet(new UnaryOperator<GraphQLSchema>(this){
                final /* synthetic */ DefaultDgsQueryExecutor this$0;

                public final GraphQLSchema apply(GraphQLSchema it) {
                    return DgsSchemaProvider.schema$default(DefaultDgsQueryExecutor.access$getSchemaProvider$p(this.this$0), null, null, 3, null);
                }
                {
                    this.this$0 = defaultDgsQueryExecutor;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema3, (String)"schema.updateAndGet { schemaProvider.schema() }");
            graphQLSchema2 = graphQLSchema3;
        } else {
            GraphQLSchema graphQLSchema4 = this.schema.get();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema4, (String)"schema.get()");
            graphQLSchema2 = graphQLSchema4;
        }
        GraphQLSchema graphQLSchema5 = graphQLSchema2;
        DgsContext dgsContext = this.contextBuilder.build(new DgsWebMvcRequestData(extensions, headers, webRequest));
        CompletableFuture<? extends ExecutionResult> executionResult = BaseDgsQueryExecutor.INSTANCE.baseExecute(query, variables, operationName, dgsContext, graphQLSchema5, this.dataLoaderProvider, this.chainedInstrumentation, this.queryExecutionStrategy, this.mutationExecutionStrategy, this.idProvider);
        ExecutionResult executionResult2 = result = executionResult.get();
        Intrinsics.checkNotNullExpressionValue((Object)executionResult2, (String)"result");
        if (executionResult2.getErrors().size() > 0) {
            Object v5;
            block5: {
                List list = result.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.errors");
                Iterable iterable = list;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    GraphQLError it = (GraphQLError)t;
                    boolean bl3 = false;
                    if (!(it instanceof NonNullableFieldWasNullError)) continue;
                    v5 = t;
                    break block5;
                }
                v5 = null;
            }
            GraphQLError nullValueError = v5;
            if (nullValueError != null) {
                this.logger.error(nullValueError.getMessage());
            }
        }
        return result;
    }

    public <T> T executeAndExtractJsonPath(@NotNull String query, @NotNull String jsonPath, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return (T)JsonPath.read((String)DefaultDgsQueryExecutor.getJsonResult$default(this, query, variables, null, 4, null), (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public <T> T executeAndExtractJsonPath(@NotNull String query, @NotNull String jsonPath, @NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        return (T)JsonPath.read((String)this.getJsonResult(query, MapsKt.emptyMap(), headers), (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    public <T> T executeAndExtractJsonPathAsObject(@NotNull String query, @NotNull String jsonPath, @NotNull Map<String, ? extends Object> variables, @NotNull Class<T> clazz, @Nullable HttpHeaders headers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String jsonResult = this.getJsonResult(query, variables, headers);
        try {
            object = BaseDgsQueryExecutor.INSTANCE.getParseContext().parse(jsonResult).read(jsonPath, clazz, new Predicate[0]);
        }
        catch (MappingException ex) {
            throw (Throwable)new DgsQueryExecutionDataExtractionException(ex, jsonResult, jsonPath, clazz);
        }
        return (T)object;
    }

    public <T> T executeAndExtractJsonPathAsObject(@NotNull String query, @NotNull String jsonPath, @NotNull Map<String, ? extends Object> variables, @NotNull TypeRef<T> typeRef, @Nullable HttpHeaders headers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        String jsonResult = this.getJsonResult(query, variables, headers);
        try {
            object = BaseDgsQueryExecutor.INSTANCE.getParseContext().parse(jsonResult).read(jsonPath, typeRef);
        }
        catch (MappingException ex) {
            throw (Throwable)new DgsQueryExecutionDataExtractionException(ex, jsonResult, jsonPath, typeRef);
        }
        return (T)object;
    }

    @NotNull
    public DocumentContext executeAndGetDocumentContext(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        DocumentContext documentContext = BaseDgsQueryExecutor.INSTANCE.getParseContext().parse(DefaultDgsQueryExecutor.getJsonResult$default(this, query, variables, null, 4, null));
        Intrinsics.checkNotNullExpressionValue((Object)documentContext, (String)"parseContext.parse(getJs\u2026Result(query, variables))");
        return documentContext;
    }

    @Override
    @NotNull
    public DocumentContext executeAndGetDocumentContext(@NotNull String query, @NotNull Map<String, Object> variables, @Nullable HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        DocumentContext documentContext = BaseDgsQueryExecutor.INSTANCE.getParseContext().parse(this.getJsonResult(query, variables, headers));
        Intrinsics.checkNotNullExpressionValue((Object)documentContext, (String)"parseContext.parse(getJs\u2026ery, variables, headers))");
        return documentContext;
    }

    private final String getJsonResult(String query, Map<String, ? extends Object> variables, HttpHeaders headers) {
        ExecutionResult executionResult = this.execute(query, variables, (Map<String, ? extends Object>)null, headers, (String)null, (WebRequest)null);
        if (executionResult.getErrors().size() > 0) {
            List list = executionResult.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionResult.errors");
            throw (Throwable)new QueryException(list);
        }
        String string = BaseDgsQueryExecutor.INSTANCE.getObjectMapper().writeValueAsString((Object)executionResult.toSpecification());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BaseDgsQueryExecutor.obj\u2026Result.toSpecification())");
        return string;
    }

    static /* synthetic */ String getJsonResult$default(DefaultDgsQueryExecutor defaultDgsQueryExecutor, String string, Map map, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 4) != 0) {
            httpHeaders = null;
        }
        return defaultDgsQueryExecutor.getJsonResult(string, map, httpHeaders);
    }

    public DefaultDgsQueryExecutor(@NotNull GraphQLSchema defaultSchema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder contextBuilder, @NotNull ChainedInstrumentation chainedInstrumentation, @NotNull ExecutionStrategy queryExecutionStrategy, @NotNull ExecutionStrategy mutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull ReloadSchemaIndicator reloadIndicator) {
        Intrinsics.checkNotNullParameter((Object)defaultSchema, (String)"defaultSchema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dataLoaderProvider, (String)"dataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)contextBuilder, (String)"contextBuilder");
        Intrinsics.checkNotNullParameter((Object)chainedInstrumentation, (String)"chainedInstrumentation");
        Intrinsics.checkNotNullParameter((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadIndicator, (String)"reloadIndicator");
        this.schemaProvider = schemaProvider;
        this.dataLoaderProvider = dataLoaderProvider;
        this.contextBuilder = contextBuilder;
        this.chainedInstrumentation = chainedInstrumentation;
        this.queryExecutionStrategy = queryExecutionStrategy;
        this.mutationExecutionStrategy = mutationExecutionStrategy;
        this.idProvider = idProvider;
        this.reloadIndicator = reloadIndicator;
        Logger logger = LoggerFactory.getLogger(DefaultDgsQueryExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026ueryExecutor::class.java)");
        this.logger = logger;
        this.schema = new AtomicReference<GraphQLSchema>(defaultSchema);
    }

    public /* synthetic */ DefaultDgsQueryExecutor(GraphQLSchema graphQLSchema2, DgsSchemaProvider dgsSchemaProvider, DgsDataLoaderProvider dgsDataLoaderProvider, DefaultDgsGraphQLContextBuilder defaultDgsGraphQLContextBuilder, ChainedInstrumentation chainedInstrumentation, ExecutionStrategy executionStrategy, ExecutionStrategy executionStrategy2, Optional optional, ReloadSchemaIndicator reloadSchemaIndicator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            reloadSchemaIndicator = 1.INSTANCE;
        }
        this(graphQLSchema2, dgsSchemaProvider, dgsDataLoaderProvider, defaultDgsGraphQLContextBuilder, chainedInstrumentation, executionStrategy, executionStrategy2, optional, reloadSchemaIndicator);
    }

    public static final /* synthetic */ DgsSchemaProvider access$getSchemaProvider$p(DefaultDgsQueryExecutor $this) {
        return $this.schemaProvider;
    }

    @FunctionalInterface
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "", "reloadSchema", "", "graphql-dgs"})
    public static interface ReloadSchemaIndicator {
        public boolean reloadSchema();
    }
}

