/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.fasterxml.jackson.module.kotlin.KotlinModuleKt;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.DgsInvalidInputArgumentException;
import com.netflix.graphql.dgs.exceptions.DgsMissingCookieException;
import com.netflix.graphql.dgs.internal.CookieValueResolver;
import com.netflix.graphql.dgs.internal.DataFetcherInvoker;
import com.netflix.graphql.dgs.internal.DgsRequestData;
import com.netflix.graphql.dgs.internal.DgsWebMvcRequestData;
import com.netflix.graphql.dgs.internal.InputObjectMapper;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0001\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ.\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u0017H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\r\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\u000e\b\u0001\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/netflix/graphql/dgs/internal/DataFetcherInvoker;", "", "cookieValueResolver", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/internal/CookieValueResolver;", "defaultParameterNameDiscoverer", "Lorg/springframework/core/DefaultParameterNameDiscoverer;", "environment", "Lgraphql/schema/DataFetchingEnvironment;", "dgsComponent", "method", "Ljava/lang/reflect/Method;", "(Ljava/util/Optional;Lorg/springframework/core/DefaultParameterNameDiscoverer;Lgraphql/schema/DataFetchingEnvironment;Ljava/lang/Object;Ljava/lang/reflect/Method;)V", "parameterNames", "", "", "kotlin.jvm.PlatformType", "[Ljava/lang/String;", "convertValue", "parameterValue", "parameter", "Ljava/lang/reflect/Parameter;", "collectionType", "Ljava/lang/Class;", "getValueAsOptional", "value", "invokeDataFetcher", "processCookieValueArgument", "idx", "", "processInputArgument", "parameterIndex", "processRequestArgument", "processRequestHeader", "Companion", "graphql-dgs"})
public final class DataFetcherInvoker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Optional<CookieValueResolver> cookieValueResolver;
    @NotNull
    private final DataFetchingEnvironment environment;
    @NotNull
    private final Object dgsComponent;
    @NotNull
    private final Method method;
    @NotNull
    private final String[] parameterNames;
    private static final Logger logger = LoggerFactory.getLogger(DataFetcherInvoker.class);

    public DataFetcherInvoker(@NotNull Optional<CookieValueResolver> cookieValueResolver, @NotNull DefaultParameterNameDiscoverer defaultParameterNameDiscoverer, @NotNull DataFetchingEnvironment environment, @NotNull Object dgsComponent, @NotNull Method method) {
        Intrinsics.checkNotNullParameter(cookieValueResolver, (String)"cookieValueResolver");
        Intrinsics.checkNotNullParameter((Object)defaultParameterNameDiscoverer, (String)"defaultParameterNameDiscoverer");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)dgsComponent, (String)"dgsComponent");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.cookieValueResolver = cookieValueResolver;
        this.environment = environment;
        this.dgsComponent = dgsComponent;
        this.method = method;
        String[] stringArray = defaultParameterNameDiscoverer.getParameterNames(this.method);
        this.parameterNames = stringArray == null ? new String[]{} : stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object invokeDataFetcher() {
        Object object;
        boolean bl = false;
        List args = new ArrayList();
        Object[] objectArray = this.method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"method.parameters");
        Sequence $this$forEachIndexed$iv = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)invokeDataFetcher.1.INSTANCE);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter;
            int n = index$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Parameter parameter2 = (Parameter)item$iv;
            int idx = n;
            boolean bl3 = false;
            if (parameter.isAnnotationPresent(InputArgument.class)) {
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                args.add(this.processInputArgument((Parameter)parameter, idx));
                continue;
            }
            if (parameter.isAnnotationPresent(RequestHeader.class)) {
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                args.add(this.processRequestHeader(this.environment, (Parameter)parameter, idx));
                continue;
            }
            if (parameter.isAnnotationPresent(RequestParam.class)) {
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                args.add(this.processRequestArgument(this.environment, (Parameter)parameter, idx));
                continue;
            }
            if (parameter.isAnnotationPresent(CookieValue.class)) {
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                args.add(this.processCookieValueArgument(this.environment, (Parameter)parameter, idx));
                continue;
            }
            if (this.environment.containsArgument(this.parameterNames[idx])) {
                Object object2 = this.environment.getArgument(this.parameterNames[idx]);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"environment.getArgument(parameterNames[idx])");
                Object parameterValue = object2;
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                Object convertValue = this.convertValue(parameterValue, (Parameter)parameter, null);
                args.add(convertValue);
                continue;
            }
            if (Intrinsics.areEqual(parameter.getType(), DataFetchingEnvironment.class) || Intrinsics.areEqual(parameter.getType(), DgsDataFetchingEnvironment.class)) {
                args.add(this.environment);
                continue;
            }
            logger.warn("Unknown argument '" + this.parameterNames[idx] + "' on data fetcher " + this.dgsComponent.getClass().getName() + '.' + this.method.getName());
            args.add(null);
        }
        $this$forEachIndexed$iv = ReflectJvmMapping.getKotlinFunction((Method)this.method);
        if ($this$forEachIndexed$iv == null ? false : $this$forEachIndexed$iv.isSuspend()) {
            Deferred launch2 = BuildersKt.async$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, (List<Object>)args, null){
                int label;
                final /* synthetic */ DataFetcherInvoker this$0;
                final /* synthetic */ List<Object> $args;
                {
                    this.this$0 = $receiver;
                    this.$args = $args;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)DataFetcherInvoker.access$getMethod$p(this.this$0));
                            Intrinsics.checkNotNull((Object)kFunction);
                            KCallable kCallable = (KCallable)kFunction;
                            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                            spreadBuilder.add(DataFetcherInvoker.access$getDgsComponent$p(this.this$0));
                            Collection $this$toTypedArray$iv = this.$args;
                            boolean $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                            if (objectArray == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                            }
                            spreadBuilder.addSpread((Object)objectArray);
                            this.label = 1;
                            Object object3 = KCallables.callSuspend((KCallable)kCallable, (Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()]), (Continuation)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<Object> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            object = FutureKt.asCompletableFuture((Deferred)launch2);
        } else {
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            if (objectArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray = objectArray2;
            object = ReflectionUtils.invokeMethod((Method)this.method, (Object)this.dgsComponent, (Object[])Arrays.copyOf(objectArray, objectArray.length));
        }
        return object;
    }

    private final Object processCookieValueArgument(DataFetchingEnvironment environment, Parameter parameter, int idx) {
        String value;
        String string;
        String string2;
        CharSequence charSequence;
        DgsRequestData requestData = DgsContext.Companion.getRequestData(environment);
        Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)parameter, CookieValue.class);
        Intrinsics.checkNotNull((Object)annotation);
        CookieValue annotation2 = (CookieValue)annotation;
        Object v = AnnotationUtils.getAnnotationAttributes((Annotation)((Annotation)annotation2)).get("name");
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String name = (String)v;
        CharSequence charSequence2 = name;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl2 = false;
            charSequence = this.parameterNames[idx];
        } else {
            charSequence = charSequence2;
        }
        String parameterName = (String)charSequence;
        if (this.cookieValueResolver.isPresent()) {
            Intrinsics.checkNotNullExpressionValue((Object)parameterName, (String)"parameterName");
            string2 = this.cookieValueResolver.get().getCookieValue(parameterName, requestData);
        } else {
            string2 = string = (String)null;
        }
        String string3 = string == null ? (!Intrinsics.areEqual((Object)annotation2.defaultValue(), (Object)"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") ? annotation2.defaultValue() : null) : (value = string);
        if (value == null && annotation2.required()) {
            Intrinsics.checkNotNullExpressionValue((Object)parameterName, (String)"parameterName");
            throw new DgsMissingCookieException(parameterName);
        }
        return this.getValueAsOptional(value, parameter);
    }

    private final Object processRequestArgument(DataFetchingEnvironment environment, Parameter parameter, int idx) {
        CharSequence charSequence;
        DgsRequestData requestData = DgsContext.Companion.getRequestData(environment);
        Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)parameter, RequestParam.class);
        Intrinsics.checkNotNull((Object)annotation);
        RequestParam annotation2 = (RequestParam)annotation;
        Object v = AnnotationUtils.getAnnotationAttributes((Annotation)((Annotation)annotation2)).get("name");
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String name = (String)v;
        CharSequence charSequence2 = name;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl2 = false;
            charSequence = this.parameterNames[idx];
        } else {
            charSequence = charSequence2;
        }
        String parameterName = (String)charSequence;
        if (requestData instanceof DgsWebMvcRequestData) {
            String value;
            Object object;
            WebRequest webRequest = ((DgsWebMvcRequestData)requestData).getWebRequest();
            WebRequest webRequest2 = webRequest;
            if (webRequest2 == null) {
                object = null;
            } else {
                Map map = webRequest2.getParameterMap();
                if (map == null) {
                    object = null;
                } else {
                    Object[] objectArray = (String[])map.get(parameterName);
                    if (objectArray == null) {
                        object = null;
                    } else {
                        Object[] objectArray2 = objectArray;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        Object[] it = objectArray2;
                        boolean bl5 = false;
                        object = parameter.getType().isAssignableFrom(List.class) ? (Serializable)it : (Serializable)((Object)ArraysKt.joinToString$default((Object[])it, null, null, null, (int)0, null, null, (int)63, null));
                    }
                }
            }
            String string = object;
            String string2 = string == null ? (!Intrinsics.areEqual((Object)annotation2.defaultValue(), (Object)"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") ? annotation2.defaultValue() : null) : (value = string);
            if (value == null && annotation2.required()) {
                throw new DgsInvalidInputArgumentException("Required request parameter '" + parameterName + "' was not provided", null, 2, null);
            }
            return this.getValueAsOptional(value, parameter);
        }
        logger.warn("@RequestParam is not supported when using WebFlux");
        return null;
    }

    private final Object processRequestHeader(DataFetchingEnvironment environment, Parameter parameter, int idx) {
        String value;
        Object object;
        CharSequence charSequence;
        DgsRequestData requestData = DgsContext.Companion.getRequestData(environment);
        Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)parameter, RequestHeader.class);
        Intrinsics.checkNotNull((Object)annotation);
        RequestHeader annotation2 = (RequestHeader)annotation;
        Object v = AnnotationUtils.getAnnotationAttributes((Annotation)((Annotation)annotation2)).get("name");
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String name = (String)v;
        CharSequence charSequence2 = name;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl2 = false;
            charSequence = this.parameterNames[idx];
        } else {
            charSequence = charSequence2;
        }
        String parameterName = (String)charSequence;
        DgsRequestData dgsRequestData = requestData;
        if (dgsRequestData == null) {
            object = null;
        } else {
            HttpHeaders httpHeaders = dgsRequestData.getHeaders();
            if (httpHeaders == null) {
                object = null;
            } else {
                List list = (List)httpHeaders.get((Object)parameterName);
                if (list == null) {
                    object = null;
                } else {
                    List list2 = list;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    List it = list2;
                    boolean bl5 = false;
                    if (parameter.getType().isAssignableFrom(List.class)) {
                        List list3 = it;
                        object = list3;
                    } else {
                        object = CollectionsKt.joinToString$default((Iterable)it, null, null, null, (int)0, null, null, (int)63, null);
                    }
                }
            }
        }
        String string = object;
        String string2 = string == null ? (!Intrinsics.areEqual((Object)annotation2.defaultValue(), (Object)"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") ? annotation2.defaultValue() : null) : (value = string);
        if (value == null && annotation2.required()) {
            throw new DgsInvalidInputArgumentException("Required header '" + parameterName + "' was not provided", null, 2, null);
        }
        return this.getValueAsOptional(value, parameter);
    }

    /*
     * WARNING - void declaration
     */
    private final Object processInputArgument(Parameter parameter, int parameterIndex) {
        Object object;
        Object $this$mapTo$iv$iv;
        Object destination$iv$iv;
        CharSequence charSequence;
        Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)parameter, InputArgument.class);
        Intrinsics.checkNotNull((Object)annotation);
        InputArgument annotation2 = (InputArgument)annotation;
        Object v = AnnotationUtils.getAnnotationAttributes((Annotation)annotation2).get("name");
        if (v == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String name = (String)v;
        CharSequence charSequence2 = name;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl2 = false;
            charSequence = this.parameterNames[parameterIndex];
        } else {
            charSequence = charSequence2;
        }
        String parameterName = (String)charSequence;
        Class<?> collectionType = annotation2.collectionType();
        Object parameterValue = this.environment.getArgument(parameterName);
        if (parameterValue instanceof List && !Intrinsics.areEqual(collectionType, Object.class)) {
            Iterable $this$map$iv;
            try {
                $this$map$iv = (Iterable)parameterValue;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void item;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Object object2 = this.convertValue(item, parameter, collectionType);
                    collection.add(object2);
                }
                $this$map$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            }
            catch (Exception ex) {
                throw new DgsInvalidInputArgumentException("Specified type '" + collectionType + "' is invalid for " + parameterName + '.', ex);
            }
            object = $this$map$iv;
        } else {
            object = parameterValue instanceof Map && parameter.getType().isAssignableFrom(Map.class) ? parameterValue : this.convertValue(parameterValue, parameter, collectionType);
        }
        Object convertValue = object;
        Class<?> paramType = parameter.getType();
        Object optionalValue = this.getValueAsOptional(convertValue, parameter);
        if (optionalValue != null && !paramType.isPrimitive() && !paramType.isAssignableFrom(optionalValue.getClass())) {
            throw new DgsInvalidInputArgumentException("Specified type '" + parameter.getType() + "' is invalid. Found " + (($this$mapTo$iv$iv = parameterValue) == null ? null : ((destination$iv$iv = $this$mapTo$iv$iv.getClass()) == null ? null : ((Class)destination$iv$iv).getName())) + " instead.", null, 2, null);
        }
        if (convertValue == null) {
            boolean bl4;
            block14: {
                $this$mapTo$iv$iv = this.environment.getFieldDefinition().getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv, (String)"environment.fieldDefinition.arguments");
                Iterable $this$none$iv = (Iterable)$this$mapTo$iv$iv;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        GraphQLArgument it = (GraphQLArgument)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)parameterName)) continue;
                        bl4 = false;
                        break block14;
                    }
                    bl4 = true;
                }
            }
            if (bl4) {
                logger.warn("Unknown argument '" + parameterName + "' on data fetcher " + this.dgsComponent.getClass().getName() + '.' + this.method.getName());
            }
        }
        return optionalValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object convertValue(Object parameterValue, Parameter parameter, Class<? extends Object> collectionType) {
        Enum[] targetType2;
        Object object;
        if (parameterValue instanceof Map) {
            Object object2;
            if (parameter.getType().isAssignableFrom(Optional.class) || parameter.getType().isAssignableFrom(List.class) || parameter.getType().isAssignableFrom(Set.class)) {
                if (collectionType == null) throw new DgsInvalidInputArgumentException("When " + parameter.getType().getSimpleName() + "<T> is used, the type must be specified using the collectionType argument of the @InputArgument annotation.", null, 2, null);
                if (Intrinsics.areEqual((Object)collectionType, Object.class)) throw new DgsInvalidInputArgumentException("When " + parameter.getType().getSimpleName() + "<T> is used, the type must be specified using the collectionType argument of the @InputArgument annotation.", null, 2, null);
                object2 = collectionType;
            } else {
                object2 = parameter.getType();
            }
            Enum[] targetType2 = object2;
            Intrinsics.checkNotNullExpressionValue((Object)targetType2, (String)"targetType");
            object = KotlinModuleKt.isKotlinClass((Class)targetType2) ? InputObjectMapper.INSTANCE.mapToKotlinObject((Map)parameterValue, JvmClassMappingKt.getKotlinClass((Class)targetType2)) : InputObjectMapper.INSTANCE.mapToJavaObject((Map)parameterValue, targetType2);
            return object;
        }
        if ((parameter.getType().isEnum() || ((targetType2 = collectionType) == null ? false : targetType2.isEnum())) && parameterValue != null) {
            Enum enum_;
            block19: {
                Enum enum_2;
                Enum[] enumConstants;
                Enum[] enumArray;
                Enum[] enumArray2;
                if (parameter.getType().isEnum()) {
                    ?[] objArray = parameter.getType().getEnumConstants();
                    if (objArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                    }
                    enumArray2 = (Enum[])objArray;
                } else {
                    T[] TArray;
                    enumArray = collectionType;
                    T[] TArray2 = TArray = enumArray == null ? null : enumArray.getEnumConstants();
                    if (TArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                    }
                    enumArray2 = (Enum[])TArray;
                }
                enumArray = enumConstants = enumArray2;
                boolean bl = false;
                Enum[] enumArray3 = enumArray;
                boolean bl2 = false;
                Enum[] enumArray4 = enumArray3;
                int n = enumArray4.length;
                for (int i = 0; i < n; ++i) {
                    Enum enum_3;
                    Enum it = enum_3 = enumArray4[i];
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)parameterValue)) continue;
                    enum_2 = enum_3;
                    break block19;
                }
                enum_2 = enum_ = null;
            }
            if (enum_ == null) {
                throw new DgsInvalidInputArgumentException("Invalid enum value '" + parameterValue + " for enum type " + parameter.getType().getName(), null, 2, null);
            }
            object = enum_;
            return object;
        }
        if (Intrinsics.areEqual(parameter.getType(), Optional.class)) {
            Object object3;
            if (!Intrinsics.areEqual((Object)collectionType, Object.class)) {
                object3 = collectionType;
                Intrinsics.checkNotNull((Object)collectionType);
            } else {
                Type type = parameter.getParameterizedType();
                if (type == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (type2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                object3 = targetType2 = (Class)type2;
            }
            if (targetType2.isEnum()) {
                T[] TArray = targetType2.getEnumConstants();
                if (TArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                }
                Enum[] enumArray = (Enum[])TArray;
                boolean bl = false;
                Enum[] enumArray5 = enumArray;
                boolean bl4 = false;
                Enum[] enumArray6 = enumArray5;
                int n = enumArray6.length;
                int n2 = 0;
                while (n2 < n) {
                    Enum enum_;
                    Enum it = enum_ = enumArray6[n2];
                    boolean bl5 = false;
                    if (Intrinsics.areEqual((Object)it.name(), (Object)parameterValue)) {
                        object = enum_;
                        return object;
                    }
                    ++n2;
                }
                return null;
            }
            object = parameterValue;
            return object;
        }
        object = parameterValue instanceof List && Intrinsics.areEqual(parameter.getType(), Set.class) ? CollectionsKt.toSet((Iterable)((Iterable)parameterValue)) : parameterValue;
        return object;
    }

    private final Object getValueAsOptional(Object value, Parameter parameter) {
        return parameter.getType().isAssignableFrom(Optional.class) ? Optional.ofNullable(value) : value;
    }

    public static final /* synthetic */ Method access$getMethod$p(DataFetcherInvoker $this) {
        return $this.method;
    }

    public static final /* synthetic */ Object access$getDgsComponent$p(DataFetcherInvoker $this) {
        return $this.dgsComponent;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/internal/DataFetcherInvoker$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

