/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.fasterxml.jackson.module.kotlin.KotlinModuleKt;
import com.netflix.graphql.dgs.exceptions.DgsInvalidInputArgumentException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J1\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u0018\u0012\u0002\b\u00030\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00150\t\u00a2\u0006\u0002\u0010\u0019J5\u0010\u001a\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00012\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u0018\u0012\u0002\b\u00030\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00150\u000b\u00a2\u0006\u0002\u0010\u001bJ$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u00012\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "", "()V", "logger", "Lorg/slf4j/Logger;", "convertList", "", "input", "targetClass", "Ljava/lang/Class;", "nestedClass", "Lkotlin/reflect/KClass;", "nestedType", "Ljava/lang/reflect/Type;", "getFieldType", "field", "Ljava/lang/reflect/Field;", "isObjectOrAny", "", "nestedTarget", "mapToJavaObject", "T", "inputMap", "", "", "(Ljava/util/Map;Ljava/lang/Class;)Ljava/lang/Object;", "mapToKotlinObject", "(Ljava/util/Map;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "trySetField", "", "declaredField", "instance", "value", "graphql-dgs"})
public final class InputObjectMapper {
    @NotNull
    public static final InputObjectMapper INSTANCE = new InputObjectMapper();
    @NotNull
    private static final Logger logger;

    private InputObjectMapper() {
    }

    @NotNull
    public final <T> T mapToKotlinObject(@NotNull Map<String, ?> inputMap, @NotNull KClass<T> targetClass) {
        Object object;
        Intrinsics.checkNotNullParameter(inputMap, (String)"inputMap");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        KFunction kFunction = KClasses.getPrimaryConstructor(targetClass);
        Intrinsics.checkNotNull((Object)kFunction);
        List params = kFunction.getParameters();
        boolean bl = false;
        List inputValues = new ArrayList();
        Iterable $this$forEach$iv = params;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KParameter parameter = (KParameter)element$iv;
            boolean bl2 = false;
            Map<String, ?> map = inputMap;
            Object object2 = parameter.getName();
            boolean bl3 = false;
            Object input = map.get(object2);
            if (input instanceof Map) {
                KClass nestedTarget = KTypesJvm.getJvmErasure((KType)parameter.getType());
                Object subValue = INSTANCE.isObjectOrAny(nestedTarget) ? input : (KotlinModuleKt.isKotlinClass((Class)JvmClassMappingKt.getJavaClass((KClass)nestedTarget)) ? INSTANCE.mapToKotlinObject((Map)input, nestedTarget) : INSTANCE.mapToJavaObject((Map)input, JvmClassMappingKt.getJavaClass((KClass)nestedTarget)));
                inputValues.add(subValue);
                continue;
            }
            if (JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)parameter.getType())).isEnum() && input != null) {
                Object e;
                block13: {
                    object2 = JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)parameter.getType())).getEnumConstants();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                    }
                    object2 = (Enum[])object2;
                    bl3 = false;
                    Object[] objectArray = object2;
                    boolean bl4 = false;
                    Object[] objectArray2 = objectArray;
                    int n = objectArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Object t;
                        Object enumValue = t = objectArray2[i];
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)((Enum)enumValue).name(), input)) continue;
                        e = t;
                        break block13;
                    }
                    e = null;
                }
                Object enumValue = e;
                inputValues.add(enumValue);
                continue;
            }
            if (input instanceof List) {
                Type type;
                List list = (List)input;
                Class clazz = JvmClassMappingKt.getJavaClass(targetClass);
                KType kType = ((KTypeProjection)parameter.getType().getArguments().get(0)).getType();
                Intrinsics.checkNotNull((Object)kType);
                KClass kClass = KTypesJvm.getJvmErasure((KType)kType);
                KType kType2 = ((KTypeProjection)parameter.getType().getArguments().get(0)).getType();
                Intrinsics.checkNotNull((Object)kType2);
                object2 = kType2.getArguments();
                bl3 = false;
                if (!object2.isEmpty()) {
                    KType kType3 = ((KTypeProjection)parameter.getType().getArguments().get(0)).getType();
                    Intrinsics.checkNotNull((Object)kType3);
                    object2 = ((KTypeProjection)kType3.getArguments().get(0)).getType();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KType");
                    }
                    type = ReflectJvmMapping.getJavaType((KType)object2);
                } else {
                    type = null;
                }
                List<?> newList = INSTANCE.convertList(list, clazz, kClass, type);
                if (Intrinsics.areEqual((Object)KTypesJvm.getJvmErasure((KType)parameter.getType()), (Object)Reflection.getOrCreateKotlinClass(Set.class))) {
                    inputValues.add(CollectionsKt.toSet((Iterable)newList));
                    continue;
                }
                inputValues.add(newList);
                continue;
            }
            inputValues.add(input);
        }
        try {
            KFunction kFunction2 = KClasses.getPrimaryConstructor(targetClass);
            Intrinsics.checkNotNull((Object)kFunction2);
            Collection $this$toTypedArray$iv = inputValues;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            object = objectArray;
            object = kFunction2.call(Arrays.copyOf(object, ((Object[])object).length));
        }
        catch (Exception ex) {
            throw new DgsInvalidInputArgumentException("Provided input arguments `" + inputValues + "` do not match arguments of data class `" + targetClass + '`', null, 2, null);
        }
        return (T)object;
    }

    public final <T> T mapToJavaObject(@NotNull Map<String, ?> inputMap, @NotNull Class<T> targetClass) {
        Intrinsics.checkNotNullParameter(inputMap, (String)"inputMap");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        if (Intrinsics.areEqual(targetClass, Object.class) || Intrinsics.areEqual(targetClass, Map.class)) {
            return (T)inputMap;
        }
        Constructor ctor = ReflectionUtils.accessibleConstructor(targetClass, (Class[])new Class[0]);
        ReflectionUtils.makeAccessible((Constructor)ctor);
        Object instance = ctor.newInstance(new Object[0]);
        int nrOfFieldErrors = 0;
        Map<String, ?> $this$forEach$iv = inputMap;
        boolean $i$f$forEach = false;
        Map<String, ?> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> element$iv;
            Map.Entry<String, ?> it = element$iv = iterator.next();
            boolean bl2 = false;
            Field declaredField = ReflectionUtils.findField(targetClass, (String)it.getKey());
            if (declaredField != null) {
                Object object;
                Pair pair;
                Type fieldType = INSTANCE.getFieldType(declaredField, targetClass);
                Type type = fieldType;
                if (type instanceof ParameterizedType) {
                    Type type2 = ((ParameterizedType)fieldType).getRawType();
                    if (type2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                    }
                    pair = TuplesKt.to((Object)((Class)type2), (Object)((ParameterizedType)fieldType).getActualTypeArguments()[0]);
                } else {
                    pair = type instanceof Class ? TuplesKt.to((Object)fieldType, null) : TuplesKt.to(Class.forName(fieldType.getTypeName()), null);
                }
                Pair pair2 = pair;
                Class fieldClass = (Class)pair2.component1();
                Type fieldArgumentType = (Type)pair2.component2();
                if (it.getValue() instanceof Map) {
                    T t;
                    if (KotlinModuleKt.isKotlinClass((Class)fieldClass)) {
                        object = it.getValue();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                        }
                        t = INSTANCE.mapToKotlinObject((Map)object, JvmClassMappingKt.getKotlinClass((Class)fieldClass));
                    } else {
                        object = it.getValue();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                        }
                        t = INSTANCE.mapToJavaObject((Map)object, fieldClass);
                    }
                    T mappedValue = t;
                    INSTANCE.trySetField(declaredField, instance, mappedValue);
                    continue;
                }
                if (it.getValue() instanceof List) {
                    object = it.getValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
                    }
                    List<?> newList = INSTANCE.convertList((List)object, targetClass, JvmClassMappingKt.getKotlinClass((Class)fieldClass), fieldArgumentType);
                    if (Intrinsics.areEqual(declaredField.getType(), Set.class)) {
                        INSTANCE.trySetField(declaredField, instance, CollectionsKt.toSet((Iterable)newList));
                        continue;
                    }
                    INSTANCE.trySetField(declaredField, instance, newList);
                    continue;
                }
                if (fieldClass.isEnum()) {
                    Object v2;
                    block18: {
                        object = fieldClass.getEnumConstants();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                        }
                        object = (Enum[])object;
                        boolean bl3 = false;
                        Object object2 = object;
                        boolean bl4 = false;
                        Object object3 = object2;
                        int n = ((?)object3).length;
                        for (int i = 0; i < n; ++i) {
                            Object obj;
                            Object enumValue = obj = object3[i];
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual((Object)((Enum)enumValue).name(), it.getValue())) continue;
                            v2 = obj;
                            break block18;
                        }
                        v2 = null;
                    }
                    Object enumValue = v2;
                    INSTANCE.trySetField(declaredField, instance, enumValue);
                    continue;
                }
                INSTANCE.trySetField(declaredField, instance, it.getValue());
                continue;
            }
            logger.warn("Field '" + it.getKey() + "' was not found on Input object of type '" + targetClass + '\'');
            int n = nrOfFieldErrors;
            nrOfFieldErrors = n + 1;
        }
        Map<String, ?> map2 = inputMap;
        boolean bl6 = false;
        if (!map2.isEmpty() && nrOfFieldErrors == inputMap.size()) {
            throw new DgsInvalidInputArgumentException("Input argument type '" + targetClass + "' doesn't match input " + inputMap, null, 2, null);
        }
        return instance;
    }

    private final void trySetField(Field declaredField, Object instance, Object value) {
        try {
            declaredField.setAccessible(true);
            declaredField.set(instance, value);
        }
        catch (Exception ex) {
            Class<?> clazz;
            Object object = instance;
            throw new DgsInvalidInputArgumentException("Invalid input argument `" + value + "` for field `" + declaredField.getName() + "` on type `" + (object == null ? null : ((clazz = object.getClass()) == null ? null : clazz.getName())) + '`', null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Type getFieldType(Field field, Class<?> targetClass) {
        Type type;
        Type genericSuperclass = targetClass.getGenericSuperclass();
        Type type2 = field.getGenericType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"field.genericType");
        Class<?> fieldType = type2;
        if (fieldType instanceof ParameterizedType && ((ParameterizedType)((Object)fieldType)).getActualTypeArguments().length == 1) {
            type2 = ((ParameterizedType)((Object)fieldType)).getActualTypeArguments()[0];
            Intrinsics.checkNotNullExpressionValue(type2, (String)"{\n            fieldType.\u2026ypeArguments[0]\n        }");
            type = type2;
        } else if (genericSuperclass instanceof ParameterizedType && !Intrinsics.areEqual(field.getType(), (Object)field.getGenericType())) {
            int n;
            block7: {
                Type type3 = ((ParameterizedType)genericSuperclass).getRawType();
                if (type3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                TypeVariable<Class<T>>[] typeParameters = ((Class)type3).getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(typeParameters, (String)"typeParameters");
                TypeVariable<Class<T>>[] $this$indexOfFirst$iv = typeParameters;
                boolean $i$f$indexOfFirst = false;
                int n2 = 0;
                int n3 = $this$indexOfFirst$iv.length;
                while (n2 < n3) {
                    void index$iv;
                    TypeVariable it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)fieldType.getTypeName())) {
                        n = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int indexOfTypeParameter = n;
            type2 = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[indexOfTypeParameter];
            Intrinsics.checkNotNullExpressionValue(type2, (String)"{\n            val typePa\u2026fTypeParameter]\n        }");
            type = type2;
        } else {
            type2 = field.getType();
            Intrinsics.checkNotNullExpressionValue(type2, (String)"{\n            field.type\n        }");
            type = type2;
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    private final List<?> convertList(List<?> input, Class<?> targetClass, KClass<?> nestedClass, Type nestedType) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)input);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Collection collection;
            block21: {
                Object it;
                int n;
                Object[] objectArray;
                T[] TArray;
                void listItem;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                if (listItem instanceof List) {
                    TArray = nestedType;
                    if (TArray instanceof ParameterizedType) {
                        Type type = ((ParameterizedType)nestedType).getRawType();
                        if (type == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                        }
                        object = INSTANCE.convertList((List)listItem, targetClass, JvmClassMappingKt.getKotlinClass((Class)((Class)type)), ((ParameterizedType)nestedType).getActualTypeArguments()[0]);
                    } else if (TArray instanceof TypeVariable) {
                        int n2;
                        block20: {
                            void $this$indexOfFirst$iv;
                            Type type = targetClass.getGenericSuperclass();
                            if (type == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                            }
                            Type type2 = ((ParameterizedType)type).getRawType();
                            if (type2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                            }
                            objectArray = ((Class)type2).getTypeParameters();
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"(targetClass.genericSupe\u2026          .typeParameters");
                            boolean $i$f$indexOfFirst = false;
                            n = 0;
                            int n3 = ((void)$this$indexOfFirst$iv).length;
                            while (n < n3) {
                                void index$iv;
                                it = (TypeVariable)$this$indexOfFirst$iv[index$iv];
                                boolean bl2 = false;
                                if (Intrinsics.areEqual((Object)it.getName(), (Object)((TypeVariable)nestedType).getTypeName())) {
                                    n2 = index$iv;
                                    break block20;
                                }
                                ++index$iv;
                            }
                            n2 = -1;
                        }
                        int indexOfGeneric = n2;
                        Type type = targetClass.getGenericSuperclass();
                        if (type == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                        }
                        Type parameterType = ((ParameterizedType)type).getActualTypeArguments()[indexOfGeneric];
                        if (parameterType == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                        }
                        object = InputObjectMapper.convertList$default(INSTANCE, (List)listItem, targetClass, JvmClassMappingKt.getKotlinClass((Class)((Class)parameterType)), null, 8, null);
                    } else if (TArray instanceof WildcardType) {
                        Type indexOfGeneric = ((WildcardType)nestedType).getUpperBounds()[0];
                        if (indexOfGeneric == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                        }
                        object = InputObjectMapper.convertList$default(INSTANCE, (List)listItem, targetClass, JvmClassMappingKt.getKotlinClass((Class)((Class)indexOfGeneric)), null, 8, null);
                    } else {
                        object = TArray instanceof Class ? InputObjectMapper.convertList$default(INSTANCE, (List)listItem, targetClass, JvmClassMappingKt.getKotlinClass((Class)((Class)nestedType)), null, 8, null) : (List)listItem;
                    }
                } else {
                    if (JvmClassMappingKt.getJavaClass(nestedClass).isEnum()) {
                        TArray = JvmClassMappingKt.getJavaClass(nestedClass).getEnumConstants();
                        if (TArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                        }
                        Enum[] $this$first$iv = (Enum[])TArray;
                        boolean $i$f$first = false;
                        objectArray = $this$first$iv;
                        int n4 = objectArray.length;
                        for (n = 0; n < n4; ++n) {
                            Object element$iv;
                            it = element$iv = objectArray[n];
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)((Enum)it).name(), (Object)listItem)) continue;
                            object = element$iv;
                            break block21;
                        }
                        throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                    }
                    object = listItem instanceof Map ? (INSTANCE.isObjectOrAny(nestedClass) ? listItem : (KotlinModuleKt.isKotlinClass((Class)JvmClassMappingKt.getJavaClass(nestedClass)) ? INSTANCE.mapToKotlinObject((Map)listItem, nestedClass) : INSTANCE.mapToJavaObject((Map)listItem, JvmClassMappingKt.getJavaClass(nestedClass)))) : listItem;
                }
            }
            void var24_31 = object;
            collection.add(var24_31);
        }
        List mappedList = (List)destination$iv$iv;
        return mappedList;
    }

    static /* synthetic */ List convertList$default(InputObjectMapper inputObjectMapper, List list, Class clazz, KClass kClass, Type type, int n, Object object) {
        if ((n & 8) != 0) {
            type = null;
        }
        return inputObjectMapper.convertList(list, clazz, kClass, type);
    }

    private final boolean isObjectOrAny(KClass<?> nestedTarget) {
        return Intrinsics.areEqual((Object)JvmClassMappingKt.getJavaClass(nestedTarget), Object.class) || Intrinsics.areEqual(nestedTarget, (Object)Reflection.getOrCreateKotlinClass(Object.class));
    }

    static {
        Logger logger = LoggerFactory.getLogger(InputObjectMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(InputObjectMapper::class.java)");
        InputObjectMapper.logger = logger;
    }
}

