/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.exceptions;

import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.dgs.exceptions.DgsBadRequestException;
import com.netflix.graphql.dgs.exceptions.DgsEntityNotFoundException;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "()V", "onException", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "Companion", "graphql-dgs"})
public final class DefaultDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy<Boolean> springSecurityAvailable$delegate;

    @NotNull
    public DataFetcherExceptionHandlerResult onException(@Nullable DataFetcherExceptionHandlerParameters handlerParameters) {
        TypedGraphQLError typedGraphQLError;
        Object[] objectArray;
        DataFetcherExceptionHandlerParameters dataFetcherExceptionHandlerParameters = handlerParameters;
        Intrinsics.checkNotNull((Object)dataFetcherExceptionHandlerParameters);
        Throwable exception = dataFetcherExceptionHandlerParameters.getException();
        logger.error("Exception while executing data fetcher for " + handlerParameters.getPath() + ": " + exception.getMessage(), exception);
        if (DefaultDataFetcherExceptionHandler.Companion.getSpringSecurityAvailable() && DefaultDataFetcherExceptionHandler.Companion.isSpringSecurityAccessException(exception)) {
            objectArray = new Object[]{exception.getClass().getName(), exception.getMessage()};
            typedGraphQLError = TypedGraphQLError.newPermissionDeniedBuilder().message("%s: %s", objectArray).path(handlerParameters.getPath()).build();
        } else if (exception instanceof DgsEntityNotFoundException) {
            objectArray = new Object[]{exception.getClass().getName(), ((DgsEntityNotFoundException)exception).getMessage()};
            typedGraphQLError = TypedGraphQLError.newNotFoundBuilder().message("%s: %s", objectArray).path(handlerParameters.getPath()).build();
        } else if (exception instanceof DgsBadRequestException) {
            objectArray = new Object[]{exception.getClass().getName(), ((DgsBadRequestException)exception).getMessage()};
            typedGraphQLError = TypedGraphQLError.newBadRequestBuilder().message("%s: %s", objectArray).path(handlerParameters.getPath()).build();
        } else {
            objectArray = new Object[]{exception.getClass().getName(), exception.getMessage()};
            typedGraphQLError = TypedGraphQLError.newInternalErrorBuilder().message("%s: %s", objectArray).path(handlerParameters.getPath()).build();
        }
        TypedGraphQLError graphqlError = typedGraphQLError;
        objectArray = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)graphqlError).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"newResult()\n            .error(graphqlError)\n            .build()");
        return objectArray;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDataFetcherExceptionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DefaultDataFetcherExceptionHandler::class.java)");
        DefaultDataFetcherExceptionHandler.logger = logger;
        springSecurityAvailable$delegate = LazyKt.lazy((Function0)Companion.springSecurityAvailable.2.INSTANCE);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "springSecurityAvailable", "", "getSpringSecurityAvailable", "()Z", "springSecurityAvailable$delegate", "Lkotlin/Lazy;", "isSpringSecurityAccessException", "exception", "", "graphql-dgs"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final boolean getSpringSecurityAvailable() {
            Lazy lazy = springSecurityAvailable$delegate;
            boolean bl = false;
            return (Boolean)lazy.getValue();
        }

        private final boolean isSpringSecurityAccessException(Throwable exception) {
            try {
                return exception instanceof AccessDeniedException;
            }
            catch (Throwable e) {
                logger.trace("Unable to verify if {} is a Spring Security's AccessDeniedException.", (Object)exception, (Object)e);
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "springSecurityAvailable", "getSpringSecurityAvailable()Z")))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

