/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.types.errors.ErrorType;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0094\u0001\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Lcom/netflix/graphql/dgs/internal/BaseDgsQueryExecutor;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "parseContext", "Lcom/jayway/jsonpath/ParseContext;", "getParseContext", "()Lcom/jayway/jsonpath/ParseContext;", "baseExecute", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/ExecutionResult;", "query", "", "variables", "", "extensions", "operationName", "dgsContext", "Lcom/netflix/graphql/dgs/context/DgsContext;", "graphQLSchema", "Lgraphql/schema/GraphQLSchema;", "dataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "chainedInstrumentation", "Lgraphql/execution/instrumentation/ChainedInstrumentation;", "queryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "mutationExecutionStrategy", "idProvider", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionIdProvider;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "graphql-dgs"})
public final class BaseDgsQueryExecutor {
    @NotNull
    public static final BaseDgsQueryExecutor INSTANCE = new BaseDgsQueryExecutor();
    private static final Logger logger = LoggerFactory.getLogger(BaseDgsQueryExecutor.class);
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final ParseContext parseContext;

    private BaseDgsQueryExecutor() {
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @NotNull
    public final ParseContext getParseContext() {
        return parseContext;
    }

    @NotNull
    public final CompletableFuture<? extends ExecutionResult> baseExecute(@Nullable String query, @Nullable Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions, @Nullable String operationName, @NotNull DgsContext dgsContext, @NotNull GraphQLSchema graphQLSchema, @NotNull DgsDataLoaderProvider dataLoaderProvider, @NotNull ChainedInstrumentation chainedInstrumentation, @NotNull ExecutionStrategy queryExecutionStrategy, @NotNull ExecutionStrategy mutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull PreparsedDocumentProvider preparsedDocumentProvider) {
        Intrinsics.checkNotNullParameter((Object)dgsContext, (String)"dgsContext");
        Intrinsics.checkNotNullParameter((Object)graphQLSchema, (String)"graphQLSchema");
        Intrinsics.checkNotNullParameter((Object)dataLoaderProvider, (String)"dataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)chainedInstrumentation, (String)"chainedInstrumentation");
        Intrinsics.checkNotNullParameter((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        if (!StringUtils.hasText((String)query)) {
            CompletableFuture<ExecutionResultImpl> completableFuture = CompletableFuture.completedFuture(ExecutionResultImpl.newExecutionResult().addError((GraphQLError)TypedGraphQLError.newBadRequestBuilder().message("The query is null or empty.", new Object[0]).errorType(ErrorType.BAD_REQUEST).build()).build());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(\n       \u2026  ).build()\n            )");
            return completableFuture;
        }
        GraphQL.Builder graphQLBuilder = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).preparsedDocumentProvider(preparsedDocumentProvider).instrumentation((Instrumentation)chainedInstrumentation).queryExecutionStrategy(queryExecutionStrategy).mutationExecutionStrategy(mutationExecutionStrategy).subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy());
        if (idProvider.isPresent()) {
            graphQLBuilder.executionIdProvider(idProvider.get());
        }
        GraphQL graphQL = graphQLBuilder.build();
        DataLoaderRegistry dataLoaderRegistry = dataLoaderProvider.buildRegistryWithContextSupplier(() -> BaseDgsQueryExecutor.baseExecute$lambda-0(dgsContext));
        Object object = ExecutionInput.newExecutionInput().query(query).operationName(operationName).variables(variables).dataLoaderRegistry(dataLoaderRegistry).context((Object)dgsContext).graphQLContext(arg_0 -> BaseDgsQueryExecutor.baseExecute$lambda-1(dgsContext, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newExecutionInput()\n    \u2026ESPACE_KEY, dgsContext) }");
        ExecutionInput.Builder executionInputBuilder = object;
        if (extensions != null) {
            executionInputBuilder.extensions(extensions);
        }
        try {
            object = graphQL.executeAsync(executionInputBuilder.build());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            graphQL.ex\u2026uilder.build())\n        }");
        }
        catch (Exception e) {
            logger.error(Intrinsics.stringPlus((String)"Encountered an exception while handling query ", (Object)query), (Throwable)e);
            List errors = e instanceof GraphQLError ? CollectionsKt.listOf((Object)e) : CollectionsKt.emptyList();
            CompletableFuture<ExecutionResultImpl> completableFuture = CompletableFuture.completedFuture(new ExecutionResultImpl(null, errors));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"{\n            logger.err\u2026(null, errors))\n        }");
            object = completableFuture;
        }
        return object;
    }

    private static final DgsContext baseExecute$lambda-0(DgsContext $dgsContext) {
        Intrinsics.checkNotNullParameter((Object)$dgsContext, (String)"$dgsContext");
        return $dgsContext;
    }

    private static final void baseExecute$lambda-1(DgsContext $dgsContext, GraphQLContext.Builder b) {
        Intrinsics.checkNotNullParameter((Object)$dgsContext, (String)"$dgsContext");
        b.of((Object)"netflix.graphql.dgs", (Object)$dgsContext);
    }

    static {
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule()).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        Intrinsics.checkNotNull((Object)objectMapper);
        BaseDgsQueryExecutor.objectMapper = objectMapper;
        Option[] optionArray = new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL};
        ParseContext parseContext = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(ExtensionsKt.jacksonObjectMapper())).mappingProvider((MappingProvider)new JacksonMappingProvider(BaseDgsQueryExecutor.objectMapper)).build().addOptions(optionArray));
        Intrinsics.checkNotNullExpressionValue((Object)parseContext, (String)"using(\n            Confi\u2026H_LEAF_TO_NULL)\n        )");
        BaseDgsQueryExecutor.parseContext = parseContext;
    }
}

