/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.internal.method.ArgumentResolverComposite;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0002R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/netflix/graphql/dgs/internal/DataFetcherInvoker;", "Lgraphql/schema/DataFetcher;", "", "dgsComponent", "method", "Ljava/lang/reflect/Method;", "resolvers", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolverComposite;", "parameterNameDiscoverer", "Lorg/springframework/core/ParameterNameDiscoverer;", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Lcom/netflix/graphql/dgs/internal/method/ArgumentResolverComposite;Lorg/springframework/core/ParameterNameDiscoverer;)V", "bridgedMethod", "isSuspending", "", "methodParameters", "", "Lorg/springframework/core/MethodParameter;", "formatArgumentError", "", "param", "message", "get", "environment", "Lgraphql/schema/DataFetchingEnvironment;", "graphql-dgs"})
public final class DataFetcherInvoker
implements DataFetcher<Object> {
    @NotNull
    private final Object dgsComponent;
    @NotNull
    private final ArgumentResolverComposite resolvers;
    @NotNull
    private final Method bridgedMethod;
    private final boolean isSuspending;
    @NotNull
    private final List<MethodParameter> methodParameters;

    /*
     * WARNING - void declaration
     */
    public DataFetcherInvoker(@NotNull Object dgsComponent, @NotNull Method method, @NotNull ArgumentResolverComposite resolvers, @NotNull ParameterNameDiscoverer parameterNameDiscoverer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)dgsComponent, (String)"dgsComponent");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)resolvers, (String)"resolvers");
        Intrinsics.checkNotNullParameter((Object)parameterNameDiscoverer, (String)"parameterNameDiscoverer");
        this.dgsComponent = dgsComponent;
        this.resolvers = resolvers;
        Method method2 = BridgeMethodResolver.findBridgedMethod((Method)method);
        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"findBridgedMethod(method)");
        this.bridgedMethod = method2;
        this.isSuspending = KotlinDetector.isSuspendingFunction((Method)this.bridgedMethod);
        Parameter[] parameterArray = this.bridgedMethod.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"bridgedMethod.parameters");
        Object[] objectArray = parameterArray;
        DataFetcherInvoker dataFetcherInvoker = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void parameter;
            Parameter parameter2 = (Parameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SynthesizingMethodParameter methodParameter = SynthesizingMethodParameter.forParameter((Parameter)parameter);
            methodParameter.initParameterNameDiscovery(parameterNameDiscoverer);
            collection.add(methodParameter);
        }
        dataFetcherInvoker.methodParameters = (List)destination$iv$iv;
        ReflectionUtils.makeAccessible((Method)this.bridgedMethod);
    }

    @Nullable
    public Object get(@NotNull DataFetchingEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (this.methodParameters.isEmpty()) {
            return ReflectionUtils.invokeMethod((Method)this.bridgedMethod, (Object)this.dgsComponent);
        }
        Object[] args = new Object[this.methodParameters.size()];
        Iterator<MethodParameter> iterator = this.methodParameters.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            MethodParameter parameter = iterator.next();
            if (!this.resolvers.supportsParameter(parameter)) {
                throw new IllegalStateException(this.formatArgumentError(parameter, "No suitable resolver"));
            }
            args[idx] = this.resolvers.resolveArgument(parameter, environment);
        }
        return this.isSuspending ? CoroutinesUtils.invokeSuspendingFunction((Method)this.bridgedMethod, (Object)this.dgsComponent, (Object[])Arrays.copyOf(args, args.length)) : ReflectionUtils.invokeMethod((Method)this.bridgedMethod, (Object)this.dgsComponent, (Object[])Arrays.copyOf(args, args.length));
    }

    private final String formatArgumentError(MethodParameter param, String message) {
        return "Could not resolve parameter [" + param.getParameterIndex() + "] in " + param.getExecutable().toGenericString() + (((CharSequence)message).length() > 0 ? ": " + message : "");
    }
}

