/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.method;

import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.internal.InputObjectMapper;
import com.netflix.graphql.dgs.internal.method.AbstractInputArgumentResolver;
import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.MergedAnnotation;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/internal/method/InputArgumentResolver;", "Lcom/netflix/graphql/dgs/internal/method/AbstractInputArgumentResolver;", "inputObjectMapper", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "resolveArgumentName", "", "parameter", "Lorg/springframework/core/MethodParameter;", "supportsParameter", "", "graphql-dgs"})
public final class InputArgumentResolver
extends AbstractInputArgumentResolver {
    public InputArgumentResolver(@NotNull InputObjectMapper inputObjectMapper) {
        Intrinsics.checkNotNullParameter((Object)inputObjectMapper, (String)"inputObjectMapper");
        super(inputObjectMapper);
    }

    @Override
    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return parameter.hasParameterAnnotation(InputArgument.class);
    }

    @Override
    @Nullable
    protected String resolveArgumentName(@NotNull MethodParameter parameter) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        InputArgument inputArgument = (InputArgument)parameter.getParameterAnnotation(InputArgument.class);
        if (inputArgument == null) {
            throw new IllegalArgumentException("Unsupported parameter type [" + parameter.getParameterType().getName() + "]. supportsParameter should be called first.");
        }
        InputArgument annotation = inputArgument;
        InputArgument mergedAnnotation = (InputArgument)MergedAnnotation.from((Annotation)annotation).synthesize();
        CharSequence charSequence2 = mergedAnnotation.name();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = parameter.getParameterName();
        } else {
            charSequence = charSequence2;
        }
        String string = (String)charSequence;
        if (string == null) {
            throw new IllegalArgumentException("Name for argument of type [" + parameter.getNestedParameterType().getName() + "} not specified, and parameter name information not found in class file either.");
        }
        return string;
    }
}

