/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.exceptions;

import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.dgs.exceptions.DgsBadRequestException;
import com.netflix.graphql.dgs.exceptions.DgsEntityNotFoundException;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import java.util.concurrent.CompletableFuture;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "()V", "doHandleException", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "handleException", "Ljava/util/concurrent/CompletableFuture;", "onException", "Companion", "graphql-dgs"})
public final class DefaultDataFetcherExceptionHandler
implements DataFetcherExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy<Boolean> springSecurityAvailable$delegate;

    @Deprecated(message="Deprecated in GraphQL Java", replaceWith=@ReplaceWith(expression="handleException(handlerParameters)", imports={}))
    @NotNull
    public DataFetcherExceptionHandlerResult onException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        return this.doHandleException(handlerParameters);
    }

    @NotNull
    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        CompletableFuture<DataFetcherExceptionHandlerResult> completableFuture = CompletableFuture.completedFuture(this.doHandleException(handlerParameters));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(doHandle\u2026ption(handlerParameters))");
        return completableFuture;
    }

    private final DataFetcherExceptionHandlerResult doHandleException(DataFetcherExceptionHandlerParameters handlerParameters) {
        TypedGraphQLError typedGraphQLError;
        Object[] objectArray;
        Throwable exception = handlerParameters.getException();
        logger.error("Exception while executing data fetcher for " + handlerParameters.getPath() + ": " + exception.getMessage(), exception);
        if (DefaultDataFetcherExceptionHandler.Companion.getSpringSecurityAvailable() && DefaultDataFetcherExceptionHandler.Companion.isSpringSecurityAccessException(exception)) {
            objectArray = new Object[]{exception.getClass().getName(), exception.getMessage()};
            typedGraphQLError = TypedGraphQLError.newPermissionDeniedBuilder().message("%s: %s", objectArray).path(handlerParameters.getPath()).build();
        } else if (exception instanceof DgsEntityNotFoundException) {
            objectArray = new Object[]{exception.getClass().getName(), ((DgsEntityNotFoundException)exception).getMessage()};
            typedGraphQLError = TypedGraphQLError.newNotFoundBuilder().message("%s: %s", objectArray).path(handlerParameters.getPath()).build();
        } else if (exception instanceof DgsBadRequestException) {
            objectArray = new Object[]{exception.getClass().getName(), ((DgsBadRequestException)exception).getMessage()};
            typedGraphQLError = TypedGraphQLError.newBadRequestBuilder().message("%s: %s", objectArray).path(handlerParameters.getPath()).build();
        } else {
            objectArray = new Object[]{exception.getClass().getName(), exception.getMessage()};
            typedGraphQLError = TypedGraphQLError.newInternalErrorBuilder().message("%s: %s", objectArray).path(handlerParameters.getPath()).build();
        }
        TypedGraphQLError graphqlError = typedGraphQLError;
        DataFetcherExceptionHandlerResult dataFetcherExceptionHandlerResult = DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)graphqlError).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherExceptionHandlerResult, (String)"newResult()\n            \u2026ror)\n            .build()");
        return dataFetcherExceptionHandlerResult;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDataFetcherExceptionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DefaultDataFet\u2026ptionHandler::class.java)");
        DefaultDataFetcherExceptionHandler.logger = logger;
        springSecurityAvailable$delegate = LazyKt.lazy((Function0)Companion.springSecurityAvailable.2.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "springSecurityAvailable", "", "getSpringSecurityAvailable", "()Z", "springSecurityAvailable$delegate", "Lkotlin/Lazy;", "isSpringSecurityAccessException", "exception", "", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getSpringSecurityAvailable() {
            Lazy lazy = springSecurityAvailable$delegate;
            return (Boolean)lazy.getValue();
        }

        private final boolean isSpringSecurityAccessException(Throwable exception) {
            try {
                return exception instanceof AccessDeniedException;
            }
            catch (Throwable e) {
                logger.trace("Unable to verify if {} is a Spring Security's AccessDeniedException.", (Object)exception, (Object)e);
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

