/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.types.errors.ErrorType;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0096\u0001\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010$\u001a\u0004\u0018\u00010%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lcom/netflix/graphql/dgs/internal/BaseDgsQueryExecutor;", "", "()V", "logger", "Lorg/slf4j/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "parseContext", "Lcom/jayway/jsonpath/ParseContext;", "getParseContext", "()Lcom/jayway/jsonpath/ParseContext;", "baseExecute", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/ExecutionResult;", "query", "", "variables", "", "extensions", "operationName", "dgsContext", "Lcom/netflix/graphql/dgs/context/DgsContext;", "graphQLSchema", "Lgraphql/schema/GraphQLSchema;", "dataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "instrumentation", "Lgraphql/execution/instrumentation/Instrumentation;", "queryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "mutationExecutionStrategy", "idProvider", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionIdProvider;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "graphql-dgs"})
public final class BaseDgsQueryExecutor {
    @NotNull
    public static final BaseDgsQueryExecutor INSTANCE = new BaseDgsQueryExecutor();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final ParseContext parseContext;

    private BaseDgsQueryExecutor() {
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @NotNull
    public final ParseContext getParseContext() {
        return parseContext;
    }

    @NotNull
    public final CompletableFuture<ExecutionResult> baseExecute(@Nullable String query, @Nullable Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions, @Nullable String operationName, @NotNull DgsContext dgsContext, @NotNull GraphQLSchema graphQLSchema, @NotNull DgsDataLoaderProvider dataLoaderProvider, @Nullable Instrumentation instrumentation, @NotNull ExecutionStrategy queryExecutionStrategy, @NotNull ExecutionStrategy mutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @Nullable PreparsedDocumentProvider preparsedDocumentProvider) {
        CompletableFuture<ExecutionResultImpl> completableFuture;
        PreparsedDocumentProvider it;
        Map<String, ? extends Object> inputVariables;
        Intrinsics.checkNotNullParameter((Object)dgsContext, (String)"dgsContext");
        Intrinsics.checkNotNullParameter((Object)graphQLSchema, (String)"graphQLSchema");
        Intrinsics.checkNotNullParameter((Object)dataLoaderProvider, (String)"dataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Map<String, Object> map = variables;
        if (map == null) {
            map = inputVariables = Collections.emptyMap();
        }
        if (!StringUtils.hasText((String)query)) {
            CompletableFuture<ExecutionResultImpl> completableFuture2 = CompletableFuture.completedFuture(ExecutionResultImpl.newExecutionResult().addError((GraphQLError)TypedGraphQLError.newBadRequestBuilder().message("The query is null or empty.", new Object[0]).errorType(ErrorType.BAD_REQUEST).build()).build());
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(\n       \u2026  ).build()\n            )");
            return completableFuture2;
        }
        GraphQL.Builder graphQLBuilder = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).queryExecutionStrategy(queryExecutionStrategy).mutationExecutionStrategy(mutationExecutionStrategy);
        PreparsedDocumentProvider preparsedDocumentProvider2 = preparsedDocumentProvider;
        if (preparsedDocumentProvider2 != null) {
            it = preparsedDocumentProvider2;
            boolean bl = false;
            graphQLBuilder.preparsedDocumentProvider(it);
        }
        Instrumentation instrumentation2 = instrumentation;
        if (instrumentation2 != null) {
            it = instrumentation2;
            boolean bl = false;
            graphQLBuilder.instrumentation((Instrumentation)it);
        }
        idProvider.ifPresent(arg_0 -> BaseDgsQueryExecutor.baseExecute$lambda-2(graphQLBuilder, arg_0));
        GraphQL graphQL = graphQLBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"graphQLBuilder.build()");
        GraphQL graphQL2 = graphQL;
        DataLoaderRegistry dataLoaderRegistry = dataLoaderProvider.buildRegistryWithContextSupplier(() -> BaseDgsQueryExecutor.baseExecute$lambda-3(dgsContext));
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput().query(query).operationName(operationName).variables(inputVariables).dataLoaderRegistry(dataLoaderRegistry).context((Object)dgsContext).graphQLContext((Consumer)dgsContext);
        Map map2 = extensions;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        ExecutionInput.Builder builder2 = builder.extensions(map2);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newExecutionInput()\n    \u2026ons(extensions.orEmpty())");
        ExecutionInput.Builder executionInputBuilder = builder2;
        try {
            CompletableFuture<ExecutionResultImpl> completableFuture3 = graphQL2.executeAsync(executionInputBuilder.build());
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture3, (String)"{\n            graphQL.ex\u2026uilder.build())\n        }");
            completableFuture = completableFuture3;
        }
        catch (Exception e) {
            logger.error("Encountered an exception while handling query " + query, (Throwable)e);
            List errors = e instanceof GraphQLError ? CollectionsKt.listOf((Object)e) : CollectionsKt.emptyList();
            CompletableFuture<ExecutionResultImpl> completableFuture4 = CompletableFuture.completedFuture(new ExecutionResultImpl(null, errors));
            Intrinsics.checkNotNullExpressionValue(completableFuture4, (String)"{\n            logger.err\u2026(null, errors))\n        }");
            completableFuture = completableFuture4;
        }
        return completableFuture;
    }

    private static final void baseExecute$lambda-2(GraphQL.Builder $graphQLBuilder, ExecutionIdProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $graphQLBuilder.executionIdProvider(it);
    }

    private static final DgsContext baseExecute$lambda-3(DgsContext $dgsContext) {
        Intrinsics.checkNotNullParameter((Object)$dgsContext, (String)"$dgsContext");
        return $dgsContext;
    }

    static {
        Logger logger = LoggerFactory.getLogger(BaseDgsQueryExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(BaseDgsQueryExecutor::class.java)");
        BaseDgsQueryExecutor.logger = logger;
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule()).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"jacksonObjectMapper()\n  \u2026IL_ON_UNKNOWN_PROPERTIES)");
        BaseDgsQueryExecutor.objectMapper = objectMapper;
        Option[] optionArray = new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL};
        ParseContext parseContext = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(ExtensionsKt.jacksonObjectMapper())).mappingProvider((MappingProvider)new JacksonMappingProvider(BaseDgsQueryExecutor.objectMapper)).build().addOptions(optionArray));
        Intrinsics.checkNotNullExpressionValue((Object)parseContext, (String)"using(\n            Confi\u2026H_LEAF_TO_NULL)\n        )");
        BaseDgsQueryExecutor.parseContext = parseContext;
    }
}

