/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.DgsDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.DgsDataLoaderRegistryConsumer;
import com.netflix.graphql.dgs.DgsDispatchPredicate;
import com.netflix.graphql.dgs.exceptions.DgsUnnamedDataLoaderOnFieldException;
import com.netflix.graphql.dgs.exceptions.InvalidDataLoaderTypeException;
import com.netflix.graphql.dgs.exceptions.UnsupportedSecuredDataLoaderException;
import com.netflix.graphql.dgs.internal.DefaultDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsDataLoaderRegistry;
import com.netflix.graphql.dgs.internal.utils.DataLoaderNameUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.registries.DispatchPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 12\u00020\u0001:\u000212B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J=\u0010\u0014\u001a\u00020\u0012\"\b\b\u0000\u0010\u0015*\u00020\u00012\u0006\u0010\u0016\u001a\u0002H\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u00020\u001f\"\u0004\b\u0000\u0010\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00150\"J8\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001fH\u0002JL\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$\"\u0004\b\u0000\u0010\u00152\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u00150\"2\u0006\u0010)\u001a\u00020\u001fH\u0002J8\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001fH\u0002JL\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$\"\u0004\b\u0000\u0010\u00152\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00102\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u00150\"2\u0006\u0010)\u001a\u00020\u001fH\u0002J\r\u0010+\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b,J&\u0010-\u001a\u0002H\u0015\"\u0006\b\u0000\u0010\u0015\u0018\u00012\u0006\u0010.\u001a\u0002H\u00152\u0006\u0010/\u001a\u00020(H\u0082\b\u00a2\u0006\u0002\u00100R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00100\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dataLoaderOptionsProvider", "Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;", "(Lorg/springframework/context/ApplicationContext;Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;)V", "batchLoaders", "", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$LoaderHolder;", "Lorg/dataloader/BatchLoader;", "batchLoadersWithContext", "Lorg/dataloader/BatchLoaderWithContext;", "mappedBatchLoaders", "Lorg/dataloader/MappedBatchLoader;", "mappedBatchLoadersWithContext", "Lorg/dataloader/MappedBatchLoaderWithContext;", "addDataLoaderComponents", "", "addDataLoaderFields", "addDataLoaders", "T", "dgsComponent", "targetClass", "Ljava/lang/Class;", "annotation", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "(Ljava/lang/Object;Ljava/lang/Class;Lcom/netflix/graphql/dgs/DgsDataLoader;Lorg/dataloader/registries/DispatchPredicate;)V", "buildRegistry", "Lorg/dataloader/DataLoaderRegistry;", "buildRegistryWithContextSupplier", "contextSupplier", "Ljava/util/function/Supplier;", "createDataLoader", "Lorg/dataloader/DataLoader;", "batchLoader", "dgsDataLoader", "dataLoaderName", "", "dataLoaderRegistry", "supplier", "findDataLoaders", "findDataLoaders$graphql_dgs", "wrappedDataLoader", "loader", "name", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "Companion", "LoaderHolder", "graphql-dgs"})
public final class DgsDataLoaderProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final DgsDataLoaderOptionsProvider dataLoaderOptionsProvider;
    @NotNull
    private final List<LoaderHolder<BatchLoader<?, ?>>> batchLoaders;
    @NotNull
    private final List<LoaderHolder<BatchLoaderWithContext<?, ?>>> batchLoadersWithContext;
    @NotNull
    private final List<LoaderHolder<MappedBatchLoader<?, ?>>> mappedBatchLoaders;
    @NotNull
    private final List<LoaderHolder<MappedBatchLoaderWithContext<?, ?>>> mappedBatchLoadersWithContext;
    @Deprecated
    @NotNull
    private static final Logger logger;

    public DgsDataLoaderProvider(@NotNull ApplicationContext applicationContext, @NotNull DgsDataLoaderOptionsProvider dataLoaderOptionsProvider) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)dataLoaderOptionsProvider, (String)"dataLoaderOptionsProvider");
        this.applicationContext = applicationContext;
        this.dataLoaderOptionsProvider = dataLoaderOptionsProvider;
        this.batchLoaders = new ArrayList();
        this.batchLoadersWithContext = new ArrayList();
        this.mappedBatchLoaders = new ArrayList();
        this.mappedBatchLoadersWithContext = new ArrayList();
    }

    public /* synthetic */ DgsDataLoaderProvider(ApplicationContext applicationContext, DgsDataLoaderOptionsProvider dgsDataLoaderOptionsProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dgsDataLoaderOptionsProvider = new DefaultDataLoaderOptionsProvider();
        }
        this(applicationContext, dgsDataLoaderOptionsProvider);
    }

    @NotNull
    public final DataLoaderRegistry buildRegistry() {
        return this.buildRegistryWithContextSupplier(buildRegistry.1.INSTANCE);
    }

    @NotNull
    public final <T> DataLoaderRegistry buildRegistryWithContextSupplier(@NotNull Supplier<T> contextSupplier) {
        LoaderHolder it;
        Intrinsics.checkNotNullParameter(contextSupplier, (String)"contextSupplier");
        long startTime = System.currentTimeMillis();
        DgsDataLoaderRegistry dgsDataLoaderRegistry = new DgsDataLoaderRegistry();
        Iterable $this$forEach$iv = this.batchLoaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl = false;
            if (it.getDispatchPredicate() == null) {
                dgsDataLoaderRegistry.register(it.getName(), this.createDataLoader((BatchLoader)it.getTheLoader(), it.getAnnotation(), it.getName(), (DataLoaderRegistry)dgsDataLoaderRegistry));
                continue;
            }
            dgsDataLoaderRegistry.registerWithDispatchPredicate(it.getName(), this.createDataLoader((BatchLoader)it.getTheLoader(), it.getAnnotation(), it.getName(), (DataLoaderRegistry)dgsDataLoaderRegistry), it.getDispatchPredicate());
        }
        $this$forEach$iv = this.mappedBatchLoaders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl = false;
            if (it.getDispatchPredicate() == null) {
                dgsDataLoaderRegistry.register(it.getName(), this.createDataLoader((MappedBatchLoader)it.getTheLoader(), it.getAnnotation(), it.getName(), (DataLoaderRegistry)dgsDataLoaderRegistry));
                continue;
            }
            dgsDataLoaderRegistry.registerWithDispatchPredicate(it.getName(), this.createDataLoader((MappedBatchLoader)it.getTheLoader(), it.getAnnotation(), it.getName(), (DataLoaderRegistry)dgsDataLoaderRegistry), it.getDispatchPredicate());
        }
        $this$forEach$iv = this.batchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl = false;
            if (it.getDispatchPredicate() == null) {
                dgsDataLoaderRegistry.register(it.getName(), this.createDataLoader((BatchLoaderWithContext)it.getTheLoader(), it.getAnnotation(), it.getName(), contextSupplier, (DataLoaderRegistry)dgsDataLoaderRegistry));
                continue;
            }
            dgsDataLoaderRegistry.registerWithDispatchPredicate(it.getName(), this.createDataLoader((BatchLoaderWithContext)it.getTheLoader(), it.getAnnotation(), it.getName(), contextSupplier, (DataLoaderRegistry)dgsDataLoaderRegistry), it.getDispatchPredicate());
        }
        $this$forEach$iv = this.mappedBatchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl = false;
            if (it.getDispatchPredicate() == null) {
                dgsDataLoaderRegistry.register(it.getName(), this.createDataLoader((MappedBatchLoaderWithContext)it.getTheLoader(), it.getAnnotation(), it.getName(), contextSupplier, (DataLoaderRegistry)dgsDataLoaderRegistry));
                continue;
            }
            dgsDataLoaderRegistry.registerWithDispatchPredicate(it.getName(), this.createDataLoader((MappedBatchLoaderWithContext)it.getTheLoader(), it.getAnnotation(), it.getName(), contextSupplier, (DataLoaderRegistry)dgsDataLoaderRegistry), it.getDispatchPredicate());
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        logger.debug("Created DGS dataloader registry in {}ms", (Object)totalTime);
        return dgsDataLoaderRegistry;
    }

    @PostConstruct
    public final void findDataLoaders$graphql_dgs() {
        this.addDataLoaderComponents();
        this.addDataLoaderFields();
    }

    /*
     * WARNING - void declaration
     */
    private final void addDataLoaderFields() {
        Iterable $this$forEach$iv = this.applicationContext.getBeansWithAnnotation(DgsComponent.class).values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            Field[] fieldArray = javaClass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"javaClass.declaredFields");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])fieldArray), (Function1)addDataLoaderFields.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl2 = false;
                if (AopUtils.isAopProxy(dgsComponent)) {
                    throw new UnsupportedSecuredDataLoaderException(dgsComponent.getClass());
                }
                DgsDataLoader annotation = field.getAnnotation(DgsDataLoader.class);
                ReflectionUtils.makeAccessible((Field)field);
                if (Intrinsics.areEqual((Object)annotation.name(), (Object)"NETFLIX_DGS_GENERATE_DATALOADER_NAME")) {
                    Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
                    throw new DgsUnnamedDataLoaderOnFieldException(field);
                }
                Object get = field.get(dgsComponent);
                if (get instanceof BatchLoader) {
                    this.batchLoaders.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$5$lambda$4$createHolder(annotation, get));
                    continue;
                }
                if (get instanceof BatchLoaderWithContext) {
                    this.batchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$5$lambda$4$createHolder(annotation, get));
                    continue;
                }
                if (get instanceof MappedBatchLoader) {
                    this.mappedBatchLoaders.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$5$lambda$4$createHolder(annotation, get));
                    continue;
                }
                if (get instanceof MappedBatchLoaderWithContext) {
                    this.mappedBatchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$5$lambda$4$createHolder(annotation, get));
                    continue;
                }
                throw new InvalidDataLoaderTypeException(dgsComponent.getClass());
            }
        }
    }

    private final void addDataLoaderComponents() {
        Map dataLoaders = this.applicationContext.getBeansWithAnnotation(DgsDataLoader.class);
        Iterable $this$forEach$iv = dataLoaders.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object v1;
            DgsDataLoader annotation;
            Class javaClass;
            Object dgsComponent;
            block3: {
                Object element$iv;
                dgsComponent = element$iv = iterator.next();
                boolean bl = false;
                javaClass = AopUtils.getTargetClass(dgsComponent);
                annotation = javaClass.getAnnotation(DgsDataLoader.class);
                Field[] fieldArray = javaClass.getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"javaClass.declaredFields");
                Sequence sequence = ArraysKt.asSequence((Object[])fieldArray);
                for (Object e : sequence) {
                    Field it = (Field)e;
                    boolean bl2 = false;
                    if (!it.isAnnotationPresent(DgsDispatchPredicate.class)) continue;
                    v1 = e;
                    break block3;
                }
                v1 = null;
            }
            Field predicateField = v1;
            if (predicateField != null) {
                ReflectionUtils.makeAccessible((Field)predicateField);
                Object dispatchPredicate = predicateField.get(dgsComponent);
                if (!(dispatchPredicate instanceof DispatchPredicate)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)javaClass, (String)"javaClass");
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
                this.addDataLoaders(dgsComponent, javaClass, annotation, (DispatchPredicate)dispatchPredicate);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
            this.addDataLoaders(dgsComponent, javaClass, annotation, null);
        }
    }

    private final <T> void addDataLoaders(T dgsComponent, Class<?> targetClass, DgsDataLoader annotation, DispatchPredicate dispatchPredicate) {
        T t = dgsComponent;
        if (t instanceof BatchLoader) {
            this.batchLoaders.add(DgsDataLoaderProvider.addDataLoaders$createHolder$8(annotation, targetClass, dispatchPredicate, dgsComponent));
        } else if (t instanceof BatchLoaderWithContext) {
            this.batchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaders$createHolder$8(annotation, targetClass, dispatchPredicate, dgsComponent));
        } else if (t instanceof MappedBatchLoader) {
            this.mappedBatchLoaders.add(DgsDataLoaderProvider.addDataLoaders$createHolder$8(annotation, targetClass, dispatchPredicate, dgsComponent));
        } else if (t instanceof MappedBatchLoaderWithContext) {
            this.mappedBatchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaders$createHolder$8(annotation, targetClass, dispatchPredicate, dgsComponent));
        } else {
            throw new InvalidDataLoaderTypeException(dgsComponent.getClass());
        }
    }

    private final DataLoader<?, ?> createDataLoader(BatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, DataLoaderRegistry dataLoaderRegistry) {
        BatchLoader batchLoader2;
        DataLoaderOptions options;
        block10: {
            block11: {
                BatchLoader batchLoader3;
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Function1 function1;
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    Stream stream$iv = this_$iv.applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    batchLoader3 = batchLoader;
                    if (batchLoader3 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new Function1<DataLoaderInstrumentationExtensionProvider, Unit>(wrappedBatchLoader$iv, dataLoaderName){
                            final /* synthetic */ Ref.ObjectRef<BatchLoader<?, ?>> $wrappedBatchLoader;
                            final /* synthetic */ String $name;
                            {
                                this.$wrappedBatchLoader = $wrappedBatchLoader;
                                this.$name = $name;
                                super(1);
                            }

                            public final void invoke(DataLoaderInstrumentationExtensionProvider it) {
                                this.$wrappedBatchLoader.element = it.provide((BatchLoader)this.$wrappedBatchLoader.element, this.$name);
                            }
                        };
                        stream$iv.forEach(new Consumer(function1){
                            private final /* synthetic */ Function1 function;
                            {
                                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                                this.function = function;
                            }

                            public final /* synthetic */ void accept(Object p0) {
                                this.function.invoke(p0);
                            }
                        });
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = (BatchLoader)object;
                        break block10;
                    }
                    if (batchLoader3 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new Function1<DataLoaderInstrumentationExtensionProvider, Unit>(wrappedBatchLoader$iv, dataLoaderName){
                            final /* synthetic */ Ref.ObjectRef<BatchLoaderWithContext<?, ?>> $wrappedBatchLoader;
                            final /* synthetic */ String $name;
                            {
                                this.$wrappedBatchLoader = $wrappedBatchLoader;
                                this.$name = $name;
                                super(1);
                            }

                            public final void invoke(DataLoaderInstrumentationExtensionProvider it) {
                                this.$wrappedBatchLoader.element = it.provide((BatchLoaderWithContext)this.$wrappedBatchLoader.element, this.$name);
                            }
                        };
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = (BatchLoader)object;
                        break block10;
                    }
                    if (batchLoader3 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new Function1<DataLoaderInstrumentationExtensionProvider, Unit>(wrappedBatchLoader$iv, dataLoaderName){
                            final /* synthetic */ Ref.ObjectRef<MappedBatchLoader<?, ?>> $wrappedBatchLoader;
                            final /* synthetic */ String $name;
                            {
                                this.$wrappedBatchLoader = $wrappedBatchLoader;
                                this.$name = $name;
                                super(1);
                            }

                            public final void invoke(DataLoaderInstrumentationExtensionProvider it) {
                                this.$wrappedBatchLoader.element = it.provide((MappedBatchLoader)this.$wrappedBatchLoader.element, this.$name);
                            }
                        };
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = (BatchLoader)object;
                        break block10;
                    }
                    if (!(batchLoader3 instanceof MappedBatchLoaderWithContext)) break block11;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = batchLoader;
                    function1 = (Function1)new Function1<DataLoaderInstrumentationExtensionProvider, Unit>(wrappedBatchLoader$iv, dataLoaderName){
                        final /* synthetic */ Ref.ObjectRef<MappedBatchLoaderWithContext<?, ?>> $wrappedBatchLoader;
                        final /* synthetic */ String $name;
                        {
                            this.$wrappedBatchLoader = $wrappedBatchLoader;
                            this.$name = $name;
                            super(1);
                        }

                        public final void invoke(DataLoaderInstrumentationExtensionProvider it) {
                            this.$wrappedBatchLoader.element = it.provide((MappedBatchLoaderWithContext)this.$wrappedBatchLoader.element, this.$name);
                        }
                    };
                    stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                    Object object = wrappedBatchLoader$iv.element;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                    }
                    batchLoader2 = (BatchLoader)object;
                    break block10;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    batchLoader3 = new BatchLoader[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", batchLoader3);
                }
            }
            batchLoader2 = batchLoader;
        }
        BatchLoader extendedBatchLoader = batchLoader2;
        DataLoader dataLoader = DataLoaderFactory.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newDataLoader(extendedBatchLoader, options)");
        return dataLoader;
    }

    private final DataLoader<?, ?> createDataLoader(MappedBatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, DataLoaderRegistry dataLoaderRegistry) {
        MappedBatchLoader mappedBatchLoader;
        DataLoaderOptions options;
        block10: {
            block11: {
                MappedBatchLoader mappedBatchLoader2;
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Function1 function1;
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    Stream stream$iv = this_$iv.applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    mappedBatchLoader2 = batchLoader;
                    if (mappedBatchLoader2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = (MappedBatchLoader)object;
                        break block10;
                    }
                    if (mappedBatchLoader2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = (MappedBatchLoader)object;
                        break block10;
                    }
                    if (mappedBatchLoader2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = (MappedBatchLoader)object;
                        break block10;
                    }
                    if (!(mappedBatchLoader2 instanceof MappedBatchLoaderWithContext)) break block11;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = batchLoader;
                    function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                    stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                    Object object = wrappedBatchLoader$iv.element;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                    }
                    mappedBatchLoader = (MappedBatchLoader)object;
                    break block10;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    mappedBatchLoader2 = new MappedBatchLoader[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", mappedBatchLoader2);
                }
            }
            mappedBatchLoader = batchLoader;
        }
        MappedBatchLoader extendedBatchLoader = mappedBatchLoader;
        DataLoader dataLoader = DataLoaderFactory.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newMappedDataLoader(extendedBatchLoader, options)");
        return dataLoader;
    }

    private final <T> DataLoader<?, ?> createDataLoader(BatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry) {
        BatchLoaderWithContext batchLoaderWithContext;
        DataLoaderOptions options;
        block10: {
            block11: {
                BatchLoaderWithContext batchLoaderWithContext2;
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader).setBatchLoaderContextProvider(supplier::get);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Function1 function1;
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    Stream stream$iv = this_$iv.applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    batchLoaderWithContext2 = batchLoader;
                    if (batchLoaderWithContext2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = (BatchLoaderWithContext)object;
                        break block10;
                    }
                    if (batchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = (BatchLoaderWithContext)object;
                        break block10;
                    }
                    if (batchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = (BatchLoaderWithContext)object;
                        break block10;
                    }
                    if (!(batchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block11;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = batchLoader;
                    function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                    stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                    Object object = wrappedBatchLoader$iv.element;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                    }
                    batchLoaderWithContext = (BatchLoaderWithContext)object;
                    break block10;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    batchLoaderWithContext2 = new BatchLoaderWithContext[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", batchLoaderWithContext2);
                }
            }
            batchLoaderWithContext = batchLoader;
        }
        BatchLoaderWithContext extendedBatchLoader = batchLoaderWithContext;
        DataLoader dataLoader = DataLoaderFactory.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newDataLoader(extendedBatchLoader, options)");
        return dataLoader;
    }

    private final <T> DataLoader<?, ?> createDataLoader(MappedBatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry) {
        MappedBatchLoaderWithContext mappedBatchLoaderWithContext;
        DataLoaderOptions options;
        block10: {
            block11: {
                MappedBatchLoaderWithContext mappedBatchLoaderWithContext2;
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader).setBatchLoaderContextProvider(supplier::get);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    Function1 function1;
                    Ref.ObjectRef wrappedBatchLoader$iv;
                    Stream stream$iv = this_$iv.applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
                    mappedBatchLoaderWithContext2 = batchLoader;
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)object;
                        break block10;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)object;
                        break block10;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = new Ref.ObjectRef();
                        wrappedBatchLoader$iv.element = batchLoader;
                        function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                        stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                        Object object = wrappedBatchLoader$iv.element;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)object;
                        break block10;
                    }
                    if (!(mappedBatchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block11;
                    wrappedBatchLoader$iv = new Ref.ObjectRef();
                    wrappedBatchLoader$iv.element = batchLoader;
                    function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                    stream$iv.forEach(new /* invalid duplicate definition of identical inner class */);
                    Object object = wrappedBatchLoader$iv.element;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                    }
                    mappedBatchLoaderWithContext = (MappedBatchLoaderWithContext)object;
                    break block10;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    mappedBatchLoaderWithContext2 = new MappedBatchLoaderWithContext[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", mappedBatchLoaderWithContext2);
                }
            }
            mappedBatchLoaderWithContext = batchLoader;
        }
        MappedBatchLoaderWithContext extendedBatchLoader = mappedBatchLoaderWithContext;
        DataLoader dataLoader = DataLoaderFactory.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newMappedDataLoader(extendedBatchLoader, options)");
        return dataLoader;
    }

    private final /* synthetic */ <T> T wrappedDataLoader(T loader, String name) {
        boolean $i$f$wrappedDataLoader = false;
        try {
            Stream stream = this.applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream();
            T t = loader;
            if (t instanceof BatchLoader) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = loader;
                Function1 function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                stream.forEach(new /* invalid duplicate definition of identical inner class */);
                Object object = wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)object;
            }
            if (t instanceof BatchLoaderWithContext) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = loader;
                Function1 function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                stream.forEach(new /* invalid duplicate definition of identical inner class */);
                Object object = wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)object;
            }
            if (t instanceof MappedBatchLoader) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = loader;
                Function1 function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                stream.forEach(new /* invalid duplicate definition of identical inner class */);
                Object object = wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)object;
            }
            if (t instanceof MappedBatchLoaderWithContext) {
                Ref.ObjectRef wrappedBatchLoader = new Ref.ObjectRef();
                wrappedBatchLoader.element = loader;
                Function1 function1 = (Function1)new /* invalid duplicate definition of identical inner class */;
                stream.forEach(new /* invalid duplicate definition of identical inner class */);
                Object object = wrappedBatchLoader.element;
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)object;
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            Object[] objectArray = new Object[]{name, loader, ex};
            logger.debug("Unable to wrap the [{} : {}]", objectArray);
        }
        return loader;
    }

    private static final <T> LoaderHolder<T> addDataLoaderFields$lambda$5$lambda$4$createHolder(DgsDataLoader annotation, T t) {
        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"annotation");
        return new LoaderHolder(t, annotation, annotation.name(), null, 8, null);
    }

    private static final <T> LoaderHolder<T> addDataLoaders$createHolder$8(DgsDataLoader $annotation, Class<?> $targetClass, DispatchPredicate $dispatchPredicate, T t) {
        return new LoaderHolder<T>(t, $annotation, DataLoaderNameUtil.INSTANCE.getDataLoaderName($targetClass, $annotation), $dispatchPredicate);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsDataLoaderProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsDataLoaderProvider::class.java)");
        DgsDataLoaderProvider.logger = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J>\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$LoaderHolder;", "T", "", "theLoader", "annotation", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "name", "", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "(Ljava/lang/Object;Lcom/netflix/graphql/dgs/DgsDataLoader;Ljava/lang/String;Lorg/dataloader/registries/DispatchPredicate;)V", "getAnnotation", "()Lcom/netflix/graphql/dgs/DgsDataLoader;", "getDispatchPredicate", "()Lorg/dataloader/registries/DispatchPredicate;", "getName", "()Ljava/lang/String;", "getTheLoader", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;Lcom/netflix/graphql/dgs/DgsDataLoader;Ljava/lang/String;Lorg/dataloader/registries/DispatchPredicate;)Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$LoaderHolder;", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs"})
    private static final class LoaderHolder<T> {
        private final T theLoader;
        @NotNull
        private final DgsDataLoader annotation;
        @NotNull
        private final String name;
        @Nullable
        private final DispatchPredicate dispatchPredicate;

        public LoaderHolder(T theLoader, @NotNull DgsDataLoader annotation, @NotNull String name, @Nullable DispatchPredicate dispatchPredicate) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.theLoader = theLoader;
            this.annotation = annotation;
            this.name = name;
            this.dispatchPredicate = dispatchPredicate;
        }

        public /* synthetic */ LoaderHolder(Object object, DgsDataLoader dgsDataLoader, String string, DispatchPredicate dispatchPredicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                dispatchPredicate = null;
            }
            this(object, dgsDataLoader, string, dispatchPredicate);
        }

        public final T getTheLoader() {
            return this.theLoader;
        }

        @NotNull
        public final DgsDataLoader getAnnotation() {
            return this.annotation;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final DispatchPredicate getDispatchPredicate() {
            return this.dispatchPredicate;
        }

        public final T component1() {
            return this.theLoader;
        }

        @NotNull
        public final DgsDataLoader component2() {
            return this.annotation;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @Nullable
        public final DispatchPredicate component4() {
            return this.dispatchPredicate;
        }

        @NotNull
        public final LoaderHolder<T> copy(T theLoader, @NotNull DgsDataLoader annotation, @NotNull String name, @Nullable DispatchPredicate dispatchPredicate) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new LoaderHolder<T>(theLoader, annotation, name, dispatchPredicate);
        }

        public static /* synthetic */ LoaderHolder copy$default(LoaderHolder loaderHolder, Object object, DgsDataLoader dgsDataLoader, String string, DispatchPredicate dispatchPredicate, int n, Object object2) {
            if ((n & 1) != 0) {
                object = loaderHolder.theLoader;
            }
            if ((n & 2) != 0) {
                dgsDataLoader = loaderHolder.annotation;
            }
            if ((n & 4) != 0) {
                string = loaderHolder.name;
            }
            if ((n & 8) != 0) {
                dispatchPredicate = loaderHolder.dispatchPredicate;
            }
            return loaderHolder.copy(object, dgsDataLoader, string, dispatchPredicate);
        }

        @NotNull
        public String toString() {
            return "LoaderHolder(theLoader=" + this.theLoader + ", annotation=" + this.annotation + ", name=" + this.name + ", dispatchPredicate=" + this.dispatchPredicate + ')';
        }

        public int hashCode() {
            int result2 = this.theLoader == null ? 0 : this.theLoader.hashCode();
            result2 = result2 * 31 + this.annotation.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + (this.dispatchPredicate == null ? 0 : this.dispatchPredicate.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoaderHolder)) {
                return false;
            }
            LoaderHolder loaderHolder = (LoaderHolder)other;
            if (!Intrinsics.areEqual(this.theLoader, loaderHolder.theLoader)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.annotation, (Object)loaderHolder.annotation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)loaderHolder.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dispatchPredicate, (Object)loaderHolder.dispatchPredicate);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

