/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.DgsQueryExecutionDataExtractionException;
import com.netflix.graphql.dgs.exceptions.QueryException;
import com.netflix.graphql.dgs.internal.BaseDgsQueryExecutor;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.DgsWebMvcRequestData;
import com.netflix.graphql.dgs.internal.QueryValueCustomizer;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0004\u0018\u0000 >2\u00020\u0001:\u0002>?Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018JZ\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$\u0018\u00010#2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010!2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J7\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#H\u0016\u00a2\u0006\u0002\u0010.J+\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016\u00a2\u0006\u0002\u0010/J+\u0010+\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0006\u00100\u001a\u000201H\u0016\u00a2\u0006\u0002\u00102JO\u00103\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H,052\b\u0010&\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u00106JO\u00103\u001a\u0002H,\"\u0004\b\u0000\u0010,2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H,082\b\u0010&\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u00109J$\u0010:\u001a\u00020;2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#H\u0016J.\u0010:\u001a\u00020;2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0<2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J<\u0010=\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020$0#2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00030\u00030\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor;", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "defaultSchema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "contextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "instrumentation", "Lgraphql/execution/instrumentation/Instrumentation;", "queryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "mutationExecutionStrategy", "idProvider", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionIdProvider;", "reloadIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "queryValueCustomizer", "Lcom/netflix/graphql/dgs/internal/QueryValueCustomizer;", "(Lgraphql/schema/GraphQLSchema;Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;Lgraphql/execution/instrumentation/Instrumentation;Lgraphql/execution/ExecutionStrategy;Lgraphql/execution/ExecutionStrategy;Ljava/util/Optional;Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;Lgraphql/execution/preparsed/PreparsedDocumentProvider;Lcom/netflix/graphql/dgs/internal/QueryValueCustomizer;)V", "schema", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "getSchema", "()Ljava/util/concurrent/atomic/AtomicReference;", "execute", "Lgraphql/ExecutionResult;", "query", "", "variables", "", "", "extensions", "headers", "Lorg/springframework/http/HttpHeaders;", "operationName", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "executeAndExtractJsonPath", "T", "jsonPath", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/http/HttpHeaders;)Ljava/lang/Object;", "servletWebRequest", "Lorg/springframework/web/context/request/ServletWebRequest;", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/web/context/request/ServletWebRequest;)Ljava/lang/Object;", "executeAndExtractJsonPathAsObject", "typeRef", "Lcom/jayway/jsonpath/TypeRef;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lcom/jayway/jsonpath/TypeRef;Lorg/springframework/http/HttpHeaders;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Class;Lorg/springframework/http/HttpHeaders;)Ljava/lang/Object;", "executeAndGetDocumentContext", "Lcom/jayway/jsonpath/DocumentContext;", "", "getJsonResult", "Companion", "ReloadSchemaIndicator", "graphql-dgs"})
public final class DefaultDgsQueryExecutor
implements DgsQueryExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsSchemaProvider schemaProvider;
    @NotNull
    private final DgsDataLoaderProvider dataLoaderProvider;
    @NotNull
    private final DefaultDgsGraphQLContextBuilder contextBuilder;
    @Nullable
    private final Instrumentation instrumentation;
    @NotNull
    private final ExecutionStrategy queryExecutionStrategy;
    @NotNull
    private final ExecutionStrategy mutationExecutionStrategy;
    @NotNull
    private final Optional<ExecutionIdProvider> idProvider;
    @NotNull
    private final ReloadSchemaIndicator reloadIndicator;
    @Nullable
    private final PreparsedDocumentProvider preparsedDocumentProvider;
    @NotNull
    private final QueryValueCustomizer queryValueCustomizer;
    @NotNull
    private final AtomicReference<GraphQLSchema> schema;
    @NotNull
    private static final Logger logger;

    public DefaultDgsQueryExecutor(@NotNull GraphQLSchema defaultSchema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder contextBuilder, @Nullable Instrumentation instrumentation, @NotNull ExecutionStrategy queryExecutionStrategy, @NotNull ExecutionStrategy mutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull ReloadSchemaIndicator reloadIndicator, @Nullable PreparsedDocumentProvider preparsedDocumentProvider, @NotNull QueryValueCustomizer queryValueCustomizer) {
        Intrinsics.checkNotNullParameter((Object)defaultSchema, (String)"defaultSchema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dataLoaderProvider, (String)"dataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)contextBuilder, (String)"contextBuilder");
        Intrinsics.checkNotNullParameter((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadIndicator, (String)"reloadIndicator");
        Intrinsics.checkNotNullParameter((Object)queryValueCustomizer, (String)"queryValueCustomizer");
        this.schemaProvider = schemaProvider;
        this.dataLoaderProvider = dataLoaderProvider;
        this.contextBuilder = contextBuilder;
        this.instrumentation = instrumentation;
        this.queryExecutionStrategy = queryExecutionStrategy;
        this.mutationExecutionStrategy = mutationExecutionStrategy;
        this.idProvider = idProvider;
        this.reloadIndicator = reloadIndicator;
        this.preparsedDocumentProvider = preparsedDocumentProvider;
        this.queryValueCustomizer = queryValueCustomizer;
        this.schema = new AtomicReference<GraphQLSchema>(defaultSchema);
    }

    public /* synthetic */ DefaultDgsQueryExecutor(GraphQLSchema graphQLSchema, DgsSchemaProvider dgsSchemaProvider, DgsDataLoaderProvider dgsDataLoaderProvider, DefaultDgsGraphQLContextBuilder defaultDgsGraphQLContextBuilder, Instrumentation instrumentation, ExecutionStrategy executionStrategy, ExecutionStrategy executionStrategy2, Optional optional, ReloadSchemaIndicator reloadSchemaIndicator, PreparsedDocumentProvider preparsedDocumentProvider, QueryValueCustomizer queryValueCustomizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            reloadSchemaIndicator = DefaultDgsQueryExecutor::_init_$lambda$0;
        }
        if ((n & 0x200) != 0) {
            preparsedDocumentProvider = null;
        }
        if ((n & 0x400) != 0) {
            queryValueCustomizer = DefaultDgsQueryExecutor::_init_$lambda$1;
        }
        this(graphQLSchema, dgsSchemaProvider, dgsDataLoaderProvider, defaultDgsGraphQLContextBuilder, instrumentation, executionStrategy, executionStrategy2, optional, reloadSchemaIndicator, preparsedDocumentProvider, queryValueCustomizer);
    }

    @NotNull
    public final AtomicReference<GraphQLSchema> getSchema() {
        return this.schema;
    }

    @NotNull
    public ExecutionResult execute(@Nullable String query, @NotNull Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions, @Nullable HttpHeaders headers, @Nullable String operationName, @Nullable WebRequest webRequest) {
        GraphQLSchema graphQLSchema;
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        if (this.reloadIndicator.reloadSchema()) {
            GraphQLSchema graphQLSchema2 = this.schema.updateAndGet(arg_0 -> DefaultDgsQueryExecutor.execute$lambda$2(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema2, (String)"{\n                schema\u2026.schema() }\n            }");
            graphQLSchema = graphQLSchema2;
        } else {
            GraphQLSchema graphQLSchema3 = this.schema.get();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema3, (String)"{\n                schema.get()\n            }");
            graphQLSchema = graphQLSchema3;
        }
        GraphQLSchema graphQLSchema4 = graphQLSchema;
        DgsContext dgsContext = this.contextBuilder.build(new DgsWebMvcRequestData(extensions, headers, webRequest));
        CompletableFuture<ExecutionResult> executionResult = BaseDgsQueryExecutor.INSTANCE.baseExecute(this.queryValueCustomizer.apply(query), variables, extensions, operationName, dgsContext, graphQLSchema4, this.dataLoaderProvider, this.instrumentation, this.queryExecutionStrategy, this.mutationExecutionStrategy, this.idProvider, this.preparsedDocumentProvider);
        ExecutionResult result2 = executionResult.get();
        if (result2.getErrors().size() > 0) {
            Object v4;
            block5: {
                List list = result2.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.errors");
                Iterable iterable = list;
                for (Object t : iterable) {
                    GraphQLError it = (GraphQLError)t;
                    boolean bl = false;
                    if (!(it instanceof NonNullableFieldWasNullError)) continue;
                    v4 = t;
                    break block5;
                }
                v4 = null;
            }
            GraphQLError nullValueError = v4;
            if (nullValueError != null) {
                logger.error(nullValueError.getMessage());
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
        return result2;
    }

    public <T> T executeAndExtractJsonPath(@NotNull String query, @NotNull String jsonPath, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return (T)JsonPath.read((String)DefaultDgsQueryExecutor.getJsonResult$default(this, query, variables, null, null, 12, null), (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public <T> T executeAndExtractJsonPath(@NotNull String query, @NotNull String jsonPath, @NotNull HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        return (T)JsonPath.read((String)DefaultDgsQueryExecutor.getJsonResult$default(this, query, MapsKt.emptyMap(), headers, null, 8, null), (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public <T> T executeAndExtractJsonPath(@NotNull String query, @NotNull String jsonPath, @NotNull ServletWebRequest servletWebRequest) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter((Object)servletWebRequest, (String)"servletWebRequest");
        HttpHeaders httpHeaders = new HttpHeaders();
        Iterator iterator = servletWebRequest.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"servletWebRequest.headerNames");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String name = (String)element$iv;
            boolean bl = false;
            Object[] $this$orEmpty$iv = servletWebRequest.getHeaderValues(name);
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                objectArray = new String[]{};
            }
            httpHeaders.addAll(name, ArraysKt.toList((Object[])objectArray));
        }
        return (T)JsonPath.read((String)this.getJsonResult(query, MapsKt.emptyMap(), httpHeaders, servletWebRequest), (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    public <T> T executeAndExtractJsonPathAsObject(@NotNull String query, @NotNull String jsonPath, @NotNull Map<String, ? extends Object> variables, @NotNull Class<T> clazz, @Nullable HttpHeaders headers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String jsonResult = DefaultDgsQueryExecutor.getJsonResult$default(this, query, variables, headers, null, 8, null);
        try {
            object = BaseDgsQueryExecutor.INSTANCE.getParseContext().parse(jsonResult).read(jsonPath, clazz, new Predicate[0]);
        }
        catch (MappingException ex) {
            throw new DgsQueryExecutionDataExtractionException(ex, jsonResult, jsonPath, clazz);
        }
        return (T)object;
    }

    public <T> T executeAndExtractJsonPathAsObject(@NotNull String query, @NotNull String jsonPath, @NotNull Map<String, ? extends Object> variables, @NotNull TypeRef<T> typeRef, @Nullable HttpHeaders headers) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        String jsonResult = DefaultDgsQueryExecutor.getJsonResult$default(this, query, variables, headers, null, 8, null);
        try {
            object = BaseDgsQueryExecutor.INSTANCE.getParseContext().parse(jsonResult).read(jsonPath, typeRef);
        }
        catch (MappingException ex) {
            throw new DgsQueryExecutionDataExtractionException(ex, jsonResult, jsonPath, typeRef);
        }
        return (T)object;
    }

    @NotNull
    public DocumentContext executeAndGetDocumentContext(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        DocumentContext documentContext = BaseDgsQueryExecutor.INSTANCE.getParseContext().parse(DefaultDgsQueryExecutor.getJsonResult$default(this, query, variables, null, null, 12, null));
        Intrinsics.checkNotNullExpressionValue((Object)documentContext, (String)"parseContext.parse(getJs\u2026Result(query, variables))");
        return documentContext;
    }

    @Override
    @NotNull
    public DocumentContext executeAndGetDocumentContext(@NotNull String query, @NotNull Map<String, Object> variables, @Nullable HttpHeaders headers) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        DocumentContext documentContext = BaseDgsQueryExecutor.INSTANCE.getParseContext().parse(DefaultDgsQueryExecutor.getJsonResult$default(this, query, variables, headers, null, 8, null));
        Intrinsics.checkNotNullExpressionValue((Object)documentContext, (String)"parseContext.parse(getJs\u2026ery, variables, headers))");
        return documentContext;
    }

    private final String getJsonResult(String query, Map<String, ? extends Object> variables, HttpHeaders headers, ServletWebRequest servletWebRequest) {
        ExecutionResult executionResult = this.execute(query, variables, (Map<String, ? extends Object>)null, headers, (String)null, (WebRequest)servletWebRequest);
        if (executionResult.getErrors().size() > 0) {
            List list = executionResult.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionResult.errors");
            throw new QueryException(list);
        }
        String string = BaseDgsQueryExecutor.INSTANCE.getObjectMapper().writeValueAsString((Object)executionResult.toSpecification());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BaseDgsQueryExecutor.obj\u2026Result.toSpecification())");
        return string;
    }

    static /* synthetic */ String getJsonResult$default(DefaultDgsQueryExecutor defaultDgsQueryExecutor, String string, Map map, HttpHeaders httpHeaders, ServletWebRequest servletWebRequest, int n, Object object) {
        if ((n & 4) != 0) {
            httpHeaders = null;
        }
        if ((n & 8) != 0) {
            servletWebRequest = null;
        }
        return defaultDgsQueryExecutor.getJsonResult(string, map, httpHeaders, servletWebRequest);
    }

    private static final boolean _init_$lambda$0() {
        return false;
    }

    private static final String _init_$lambda$1(String query) {
        return query;
    }

    private static final GraphQLSchema execute$lambda$2(DefaultDgsQueryExecutor this$0, GraphQLSchema it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return DgsSchemaProvider.schema$default(this$0.schemaProvider, null, null, 3, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDgsQueryExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DefaultDgsQueryExecutor::class.java)");
        DefaultDgsQueryExecutor.logger = logger;
    }

    @FunctionalInterface
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "", "reloadSchema", "", "graphql-dgs"})
    public static interface ReloadSchemaIndicator {
        public boolean reloadSchema();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

