/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.internal.DataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.ReactiveDataFetcherResultProcessorKt;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/internal/MonoDataFetcherResultProcessor;", "Lcom/netflix/graphql/dgs/internal/DataFetcherResultProcessor;", "()V", "process", "", "originalResult", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "supportsType", "", "graphql-dgs"})
public final class MonoDataFetcherResultProcessor
implements DataFetcherResultProcessor {
    @Override
    public boolean supportsType(@NotNull Object originalResult) {
        Intrinsics.checkNotNullParameter((Object)originalResult, (String)"originalResult");
        return originalResult instanceof Mono;
    }

    @Override
    @NotNull
    public Object process(@NotNull Object originalResult, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)originalResult, (String)"originalResult");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        if (originalResult instanceof Mono) {
            CompletableFuture completableFuture = ((Mono)originalResult).contextWrite(ReactiveDataFetcherResultProcessorKt.access$reactorContextFrom(dfe)).toFuture();
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"originalResult.contextWr\u2026textFrom(dfe)).toFuture()");
            return completableFuture;
        }
        throw new IllegalArgumentException("Instance passed to " + Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName() + " was not a Mono<*>. It was a " + Reflection.getOrCreateKotlinClass(originalResult.getClass()).getQualifiedName() + " instead");
    }
}

