/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.federation;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.exceptions.InvalidDgsEntityFetcher;
import com.netflix.graphql.dgs.exceptions.MissingDgsEntityFetcherException;
import com.netflix.graphql.dgs.exceptions.MissingFederatedQueryArgument;
import com.netflix.graphql.dgs.federation.DefaultDgsFederationResolver;
import com.netflix.graphql.dgs.internal.EntityFetcherRegistry;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.GraphQLError;
import graphql.TypeResolutionEnvironment;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.DataFetcherResult;
import graphql.execution.ResultPath;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.TypeResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.Try;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.core.publisher.Mono;

@DgsComponent
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ$\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00160\u00150\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001bH\u0016J\u0018\u0010\u001c\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0016J\b\u0010 \u001a\u00020!H\u0016R$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\b\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver;", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "entityFetcherRegistry", "Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "dataFetcherExceptionHandler", "Ljava/util/Optional;", "Lgraphql/execution/DataFetcherExceptionHandler;", "(Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;Ljava/util/Optional;)V", "()V", "dgsExceptionHandler", "getDgsExceptionHandler", "()Ljava/util/Optional;", "setDgsExceptionHandler", "(Ljava/util/Optional;)V", "getEntityFetcherRegistry$annotations", "getEntityFetcherRegistry", "()Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "setEntityFetcherRegistry", "(Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;)V", "dgsEntityFetchers", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/execution/DataFetcherResult;", "", "", "env", "Lgraphql/schema/DataFetchingEnvironment;", "entitiesFetcher", "Lgraphql/schema/DataFetcher;", "typeMapping", "", "Ljava/lang/Class;", "", "typeResolver", "Lgraphql/schema/TypeResolver;", "Companion", "graphql-dgs"})
public class DefaultDgsFederationResolver
implements DgsFederationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Autowired
    public EntityFetcherRegistry entityFetcherRegistry;
    @Autowired
    public Optional<DataFetcherExceptionHandler> dgsExceptionHandler;
    @NotNull
    private static final Logger logger;

    public DefaultDgsFederationResolver() {
    }

    public DefaultDgsFederationResolver(@NotNull EntityFetcherRegistry entityFetcherRegistry, @NotNull Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"entityFetcherRegistry");
        Intrinsics.checkNotNullParameter(dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        this();
        this.setEntityFetcherRegistry(entityFetcherRegistry);
        this.setDgsExceptionHandler(dataFetcherExceptionHandler);
    }

    @NotNull
    public final EntityFetcherRegistry getEntityFetcherRegistry() {
        EntityFetcherRegistry entityFetcherRegistry = this.entityFetcherRegistry;
        if (entityFetcherRegistry != null) {
            return entityFetcherRegistry;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"entityFetcherRegistry");
        return null;
    }

    public final void setEntityFetcherRegistry(@NotNull EntityFetcherRegistry entityFetcherRegistry) {
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"<set-?>");
        this.entityFetcherRegistry = entityFetcherRegistry;
    }

    public static /* synthetic */ void getEntityFetcherRegistry$annotations() {
    }

    @NotNull
    public final Optional<DataFetcherExceptionHandler> getDgsExceptionHandler() {
        Optional<DataFetcherExceptionHandler> optional = this.dgsExceptionHandler;
        if (optional != null) {
            return optional;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dgsExceptionHandler");
        return null;
    }

    public final void setDgsExceptionHandler(@NotNull Optional<DataFetcherExceptionHandler> optional) {
        Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
        this.dgsExceptionHandler = optional;
    }

    @Override
    @NotNull
    public DataFetcher<Object> entitiesFetcher() {
        return arg_0 -> DefaultDgsFederationResolver.entitiesFetcher$lambda$0(this, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<DataFetcherResult<List<Object>>> dgsEntityFetchers(DataFetchingEnvironment env) {
        void $this$mapTo$iv$iv;
        Object object = env.getArgument("representations");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getArgument<List<Map\u2026>>>(_Entity.argumentName)");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void values;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CompletableFuture)Try.tryCall(() -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$6$lambda$3((Map)values, this, env)).map(arg_0 -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$6$lambda$4(dgsEntityFetchers.resultList.1.2.INSTANCE, arg_0)).recover(DefaultDgsFederationResolver::dgsEntityFetchers$lambda$6$lambda$5).get());
        }
        List resultList2 = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = resultList2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletionStage completionStage = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenApply(arg_0 -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$7((Function1)new Function1<Void, DataFetcherResult<List<? extends Object>>>((List<? extends CompletableFuture<? extends Try<? extends Object>>>)resultList2, this, env){
            final /* synthetic */ List<CompletableFuture<? extends Try<? extends Object>>> $resultList;
            final /* synthetic */ DefaultDgsFederationResolver this$0;
            final /* synthetic */ DataFetchingEnvironment $env;
            {
                this.$resultList = $resultList;
                this.this$0 = $receiver;
                this.$env = $env;
                super(1);
            }

            public final DataFetcherResult<List<Object>> invoke(Void it) {
                Sequence trySequence2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.$resultList), (Function1)dgsEntityFetchers.trySequence.1.INSTANCE);
                return DataFetcherResult.newResult().data((Object)SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)trySequence2, (Function1)dgsEntityFetchers.1.INSTANCE), (Function1)dgsEntityFetchers.2.INSTANCE))).errors(SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)trySequence2, (Function1)dgsEntityFetchers.3.INSTANCE), (Function1)dgsEntityFetchers.4.INSTANCE), (Function1)((Function1)new Function1<Throwable, Sequence<? extends GraphQLError>>(this.this$0, this.$env){
                    final /* synthetic */ DefaultDgsFederationResolver this$0;
                    final /* synthetic */ DataFetchingEnvironment $env;
                    {
                        this.this$0 = $receiver;
                        this.$env = $env;
                        super(1);
                    }

                    @NotNull
                    public final Sequence<GraphQLError> invoke(Throwable e) {
                        Sequence sequence;
                        Throwable exception;
                        if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() != null) {
                            v0 = ((InvocationTargetException)e).getTargetException();
                        } else if (e instanceof CompletionException && e.getCause() != null) {
                            Throwable throwable = e.getCause();
                            v0 = throwable;
                            Intrinsics.checkNotNull((Object)throwable);
                        } else {
                            v0 = exception = e;
                        }
                        if (this.this$0.getDgsExceptionHandler().isPresent()) {
                            CompletableFuture res = this.this$0.getDgsExceptionHandler().get().handleException(DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(this.$env).exception(exception).build());
                            List list = ((DataFetcherExceptionHandlerResult)res.join()).getErrors();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"res.join().errors");
                            sequence = CollectionsKt.asSequence((Iterable)list);
                        } else {
                            Object[] objectArray = new TypedGraphQLError[1];
                            Object[] objectArray2 = new Object[]{exception.getClass().getName(), exception.getMessage()};
                            objectArray[0] = TypedGraphQLError.newInternalErrorBuilder().message("%s: %s", objectArray2).path(ResultPath.parse((String)"/_entities")).build();
                            sequence = SequencesKt.sequenceOf((Object[])objectArray);
                        }
                        return sequence;
                    }
                })))).build();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"private fun dgsEntityFet\u2026 .build()\n        }\n    }");
        return completionStage;
    }

    @NotNull
    public Map<Class<?>, String> typeMapping() {
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public TypeResolver typeResolver() {
        return arg_0 -> DefaultDgsFederationResolver.typeResolver$lambda$8(this, arg_0);
    }

    private static final Object entitiesFetcher$lambda$0(DefaultDgsFederationResolver this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)env, (String)"env");
        return this$0.dgsEntityFetchers(env);
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$6$lambda$3(Map $values, DefaultDgsFederationResolver this$0, DataFetchingEnvironment $env) {
        Object result;
        Object[] objectArray;
        boolean bl;
        Pair<Object, Method> fetcher;
        Object typename;
        block9: {
            boolean bl2;
            block8: {
                Intrinsics.checkNotNullParameter((Object)$values, (String)"$values");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$env, (String)"$env");
                Object v = $values.get("__typename");
                if (v == null) {
                    String[] stringArray = new String[]{"__typename"};
                    throw new MissingFederatedQueryArgument(stringArray);
                }
                typename = v;
                Pair<Object, Method> pair = this$0.getEntityFetcherRegistry().getEntityFetchers().get(typename);
                if (pair == null) {
                    throw new MissingDgsEntityFetcherException(typename.toString());
                }
                fetcher = pair;
                Class<?>[] classArray = ((Method)fetcher.getSecond()).getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"fetcher.second.parameterTypes");
                Object[] $this$any$iv = classArray;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv = $this$any$iv[i];
                    Class it = (Class)element$iv;
                    boolean bl3 = false;
                    if (!it.isAssignableFrom(Map.class)) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
            if (!bl2) {
                throw new InvalidDgsEntityFetcher("@DgsEntityFetcher " + fetcher.getFirst().getClass().getName() + "." + ((Method)fetcher.getSecond()).getName() + " is invalid. A DgsEntityFetcher must accept an argument of type Map<String, Object>");
            }
            Class<?>[] classArray = ((Method)fetcher.getSecond()).getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"fetcher.second.parameterTypes");
            Object[] $this$any$iv = classArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Class it = (Class)element$iv;
                boolean bl4 = false;
                if (!it.isAssignableFrom(DgsDataFetchingEnvironment.class)) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            objectArray = new Object[]{$values, new DgsDataFetchingEnvironment($env)};
            v6 = ((Method)fetcher.getSecond()).invoke(fetcher.getFirst(), objectArray);
        } else {
            objectArray = new Object[]{$values};
            v6 = result = ((Method)fetcher.getSecond()).invoke(fetcher.getFirst(), objectArray);
        }
        if (result == null) {
            logger.error("@DgsEntityFetcher returned null for type: " + typename);
            CompletableFuture.completedFuture(null);
        }
        return (objectArray = result) instanceof CompletionStage ? ((CompletionStage)result).toCompletableFuture() : (objectArray instanceof Mono ? ((Mono)result).toFuture() : CompletableFuture.completedFuture(result));
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$6$lambda$5(Throwable exception) {
        return CompletableFuture.completedFuture(Try.failed((Throwable)exception));
    }

    private static final DataFetcherResult dgsEntityFetchers$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataFetcherResult)$tmp0.invoke(p0);
    }

    private static final GraphQLObjectType typeResolver$lambda$8(DefaultDgsFederationResolver this$0, TypeResolutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getObject()");
        Object src = object;
        String typeName = this$0.typeMapping().containsKey(src.getClass()) ? this$0.typeMapping().get(src.getClass()) : src.getClass().getSimpleName();
        GraphQLObjectType type = env.getSchema().getObjectType(typeName);
        if (type == null) {
            logger.warn("No type definition found for {}. You probably need to provide either a type mapping,or override DefaultDgsFederationResolver.typeResolver().Alternatively make sure the type name in the schema and your Java model match", (Object)src.getClass().getName());
        }
        return type;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDgsFederationResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DefaultDgsFede\u2026tionResolver::class.java)");
        DefaultDgsFederationResolver.logger = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

