/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.method;

import com.netflix.graphql.dgs.exceptions.DgsInvalidInputArgumentException;
import com.netflix.graphql.dgs.internal.InputObjectMapper;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.internal.method.InputObjectMapperConverter;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0007H \u00a2\u0006\u0002\b\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/netflix/graphql/dgs/internal/method/AbstractInputArgumentResolver;", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "inputObjectMapper", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "argumentNameCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/springframework/core/MethodParameter;", "", "conversionService", "Lorg/springframework/core/convert/support/DefaultConversionService;", "convertValue", "", "source", "target", "Lorg/springframework/core/convert/TypeDescriptor;", "getArgumentName", "parameter", "resolveArgument", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "resolveArgumentName", "resolveArgumentName$graphql_dgs", "Companion", "graphql-dgs"})
public abstract class AbstractInputArgumentResolver
implements ArgumentResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultConversionService conversionService;
    @NotNull
    private final ConcurrentMap<MethodParameter, String> argumentNameCache;
    @NotNull
    private static final Logger logger;

    public AbstractInputArgumentResolver(@NotNull InputObjectMapper inputObjectMapper) {
        Intrinsics.checkNotNullParameter((Object)inputObjectMapper, (String)"inputObjectMapper");
        this.conversionService = new DefaultConversionService();
        this.argumentNameCache = new ConcurrentHashMap();
        this.conversionService.addConverter((GenericConverter)new InputObjectMapperConverter(inputObjectMapper));
    }

    @Override
    @Nullable
    public Object resolveArgument(@NotNull MethodParameter parameter, @NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        String argumentName = this.getArgumentName(parameter);
        Object value = dfe.getArgument(argumentName);
        TypeDescriptor typeDescriptor = new TypeDescriptor(parameter);
        Object convertedValue = this.convertValue(value, typeDescriptor);
        if (convertedValue == null) {
            boolean bl;
            block5: {
                List list = dfe.getFieldDefinition().getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dfe.fieldDefinition.arguments");
                Iterable $this$none$iv = list;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        GraphQLArgument it = (GraphQLArgument)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)argumentName)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                logger.warn("Unknown argument '{}'", (Object)argumentName);
            }
        }
        return convertedValue;
    }

    @Nullable
    public abstract String resolveArgumentName$graphql_dgs(@NotNull MethodParameter var1);

    private final String getArgumentName(MethodParameter parameter) {
        String cachedName = (String)this.argumentNameCache.get(parameter);
        if (cachedName != null) {
            return cachedName;
        }
        String name = this.resolveArgumentName$graphql_dgs(parameter);
        ((Map)this.argumentNameCache).put(parameter, name);
        return name;
    }

    private final Object convertValue(Object source, TypeDescriptor target) {
        if (target.getResolvableType().isInstance(source)) {
            return source;
        }
        TypeDescriptor sourceType = TypeDescriptor.forObject((Object)source);
        if (this.conversionService.canConvert(sourceType, target)) {
            return this.conversionService.convert(source, sourceType, target);
        }
        Object object = source;
        throw new DgsInvalidInputArgumentException("Unable to convert from " + (object != null ? object.getClass() : null) + " to " + target.getType(), null, 2, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(AbstractInputArgumentResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(AbstractInputA\u2026mentResolver::class.java)");
        AbstractInputArgumentResolver.logger = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/internal/method/AbstractInputArgumentResolver$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

