/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs;

import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.MultipleDataLoadersDefinedException;
import com.netflix.graphql.dgs.exceptions.NoDataLoaderFoundException;
import com.netflix.graphql.dgs.internal.utils.DataLoaderNameUtil;
import graphql.GraphQLContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001J8\u0010\t\u001a\n \b*\u0004\u0018\u0001H\nH\n\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010\fJH\u0010\r\u001a\n \b*\u0004\u0018\u0001H\nH\n\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u000e\u001a\n \b*\u0004\u0018\u0001H\nH\nH\u0096\u0001\u00a2\u0006\u0002\u0010\u000fJI\u0010\u0010\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00120\u0011H\u0096\u0001J(\u0010\u0013\u001a\n \b*\u0004\u0018\u0001H\nH\n\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000bH\u0097\u0001\u00a2\u0006\u0002\u0010\u0014J*\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00180\u0016\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aJ}\u0010\u0015\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u0001H\u0017H\u0017\u0012\f\u0012\n \b*\u0004\u0018\u0001H\u0018H\u0018 \b* \u0012\f\u0012\n \b*\u0004\u0018\u0001H\u0017H\u0017\u0012\f\u0012\n \b*\u0004\u0018\u0001H\u0018H\u0018\u0018\u00010\u00160\u0016\"\u0010\b\u0000\u0010\u0017*\n \b*\u0004\u0018\u00010\u000b0\u000b\"\u0010\b\u0001\u0010\u0018*\n \b*\u0004\u0018\u00010\u000b0\u000b2\u000e\u0010\u001b\u001a\n \b*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001J\u0011\u0010\u001c\u001a\n \b*\u0004\u0018\u00010\u001d0\u001dH\u0096\u0001J\u0006\u0010\u001e\u001a\u00020\u0001J\u0006\u0010\u001f\u001a\u00020 J\u0011\u0010!\u001a\n \b*\u0004\u0018\u00010\"0\"H\u0096\u0001J\u0011\u0010#\u001a\n \b*\u0004\u0018\u00010$0$H\u0096\u0001J\u0011\u0010%\u001a\n \b*\u0004\u0018\u00010&0&H\u0096\u0001J\u0011\u0010'\u001a\n \b*\u0004\u0018\u00010(0(H\u0096\u0001J\u0011\u0010)\u001a\n \b*\u0004\u0018\u00010*0*H\u0096\u0001J\u0011\u0010+\u001a\n \b*\u0004\u0018\u00010,0,H\u0096\u0001J-\u0010-\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010(0( \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010(0(\u0018\u00010/0.H\u0097\u0001JI\u00100\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010101 \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010101\u0018\u00010\u00120\u0011H\u0096\u0001J\u0011\u00102\u001a\n \b*\u0004\u0018\u00010303H\u0096\u0001J\u0011\u00104\u001a\n \b*\u0004\u0018\u00010505H\u0096\u0001J(\u00106\u001a\n \b*\u0004\u0018\u0001H\nH\n\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u0014J\u0011\u00107\u001a\n \b*\u0004\u0018\u00010808H\u0096\u0001J\u0011\u00109\u001a\n \b*\u0004\u0018\u00010:0:H\u0096\u0001J\u0011\u0010;\u001a\n \b*\u0004\u0018\u00010<0<H\u0096\u0001J\u0011\u0010=\u001a\n \b*\u0004\u0018\u00010>0>H\u0096\u0001J\u0011\u0010?\u001a\n \b*\u0004\u0018\u00010@0@H\u0096\u0001J(\u0010A\u001a\n \b*\u0004\u0018\u0001H\nH\n\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u0014J\u0011\u0010B\u001a\n \b*\u0004\u0018\u00010C0CH\u0096\u0001J(\u0010D\u001a\n \b*\u0004\u0018\u0001H\nH\n\"\u0010\b\u0000\u0010\n*\n \b*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u0014JI\u0010E\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00120\u0011H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "Lgraphql/schema/DataFetchingEnvironment;", "dfe", "(Lgraphql/schema/DataFetchingEnvironment;)V", "containsArgument", "", "name", "", "kotlin.jvm.PlatformType", "getArgument", "T", "", "(Ljava/lang/String;)Ljava/lang/Object;", "getArgumentOrDefault", "defaultValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getArguments", "", "", "getContext", "()Ljava/lang/Object;", "getDataLoader", "Lorg/dataloader/DataLoader;", "K", "V", "loaderClass", "Ljava/lang/Class;", "dataLoaderName", "getDataLoaderRegistry", "Lorg/dataloader/DataLoaderRegistry;", "getDfe", "getDgsContext", "Lcom/netflix/graphql/dgs/context/DgsContext;", "getDocument", "Lgraphql/language/Document;", "getExecutionId", "Lgraphql/execution/ExecutionId;", "getExecutionStepInfo", "Lgraphql/execution/ExecutionStepInfo;", "getField", "Lgraphql/language/Field;", "getFieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "getFieldType", "Lgraphql/schema/GraphQLOutputType;", "getFields", "", "", "getFragmentsByName", "Lgraphql/language/FragmentDefinition;", "getGraphQLSchema", "Lgraphql/schema/GraphQLSchema;", "getGraphQlContext", "Lgraphql/GraphQLContext;", "getLocalContext", "getLocale", "Ljava/util/Locale;", "getMergedField", "Lgraphql/execution/MergedField;", "getOperationDefinition", "Lgraphql/language/OperationDefinition;", "getParentType", "Lgraphql/schema/GraphQLType;", "getQueryDirectives", "Lgraphql/execution/directives/QueryDirectives;", "getRoot", "getSelectionSet", "Lgraphql/schema/DataFetchingFieldSelectionSet;", "getSource", "getVariables", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsDataFetchingEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsDataFetchingEnvironment.kt\ncom/netflix/graphql/dgs/DgsDataFetchingEnvironment\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,50:1\n3792#2:51\n4307#2,2:52\n*S KotlinDebug\n*F\n+ 1 DgsDataFetchingEnvironment.kt\ncom/netflix/graphql/dgs/DgsDataFetchingEnvironment\n*L\n40#1:51\n40#1:52,2\n*E\n"})
public final class DgsDataFetchingEnvironment
implements DataFetchingEnvironment {
    @NotNull
    private final DataFetchingEnvironment dfe;

    public DgsDataFetchingEnvironment(@NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        this.dfe = dfe;
    }

    public boolean containsArgument(String name) {
        return this.dfe.containsArgument(name);
    }

    public <T> T getArgument(String name) {
        return (T)this.dfe.getArgument(name);
    }

    public <T> T getArgumentOrDefault(String name, T defaultValue) {
        return (T)this.dfe.getArgumentOrDefault(name, defaultValue);
    }

    public Map<String, Object> getArguments() {
        return this.dfe.getArguments();
    }

    @Deprecated(message="Deprecated in Java")
    public <T> T getContext() {
        return (T)this.dfe.getContext();
    }

    public <K, V> DataLoader<K, V> getDataLoader(String dataLoaderName) {
        return this.dfe.getDataLoader(dataLoaderName);
    }

    public DataLoaderRegistry getDataLoaderRegistry() {
        return this.dfe.getDataLoaderRegistry();
    }

    public Document getDocument() {
        return this.dfe.getDocument();
    }

    public ExecutionId getExecutionId() {
        return this.dfe.getExecutionId();
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.dfe.getExecutionStepInfo();
    }

    public Field getField() {
        return this.dfe.getField();
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.dfe.getFieldDefinition();
    }

    public GraphQLOutputType getFieldType() {
        return this.dfe.getFieldType();
    }

    @Deprecated(message="Deprecated in Java")
    public List<Field> getFields() {
        return this.dfe.getFields();
    }

    public Map<String, FragmentDefinition> getFragmentsByName() {
        return this.dfe.getFragmentsByName();
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.dfe.getGraphQLSchema();
    }

    public GraphQLContext getGraphQlContext() {
        return this.dfe.getGraphQlContext();
    }

    public <T> T getLocalContext() {
        return (T)this.dfe.getLocalContext();
    }

    public Locale getLocale() {
        return this.dfe.getLocale();
    }

    public MergedField getMergedField() {
        return this.dfe.getMergedField();
    }

    public OperationDefinition getOperationDefinition() {
        return this.dfe.getOperationDefinition();
    }

    public GraphQLType getParentType() {
        return this.dfe.getParentType();
    }

    public QueryDirectives getQueryDirectives() {
        return this.dfe.getQueryDirectives();
    }

    public <T> T getRoot() {
        return (T)this.dfe.getRoot();
    }

    public DataFetchingFieldSelectionSet getSelectionSet() {
        return this.dfe.getSelectionSet();
    }

    public <T> T getSource() {
        return (T)this.dfe.getSource();
    }

    public Map<String, Object> getVariables() {
        return this.dfe.getVariables();
    }

    @NotNull
    public final DataFetchingEnvironment getDfe() {
        return this.dfe;
    }

    @NotNull
    public final DgsContext getDgsContext() {
        return DgsContext.Companion.from(this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <K, V> DataLoader<K, V> getDataLoader(@NotNull Class<?> loaderClass) {
        DataLoader dataLoader;
        Intrinsics.checkNotNullParameter(loaderClass, (String)"loaderClass");
        DgsDataLoader annotation = loaderClass.getAnnotation(DgsDataLoader.class);
        if (annotation != null) {
            DataLoader dataLoader2 = this.dfe.getDataLoader(DataLoaderNameUtil.INSTANCE.getDataLoaderName(loaderClass, annotation));
            Intrinsics.checkNotNull((Object)dataLoader2);
            dataLoader = dataLoader2;
        } else {
            void $this$filterTo$iv$iv;
            java.lang.reflect.Field[] fieldArray = loaderClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getFields(...)");
            Object[] $this$filter$iv = fieldArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                java.lang.reflect.Field it = (java.lang.reflect.Field)element$iv$iv;
                boolean bl = false;
                if (!it.isAnnotationPresent(DgsDataLoader.class)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List loaders = (List)destination$iv$iv;
            if (loaders.size() > 1) {
                throw new MultipleDataLoadersDefinedException(loaderClass);
            }
            java.lang.reflect.Field field = (java.lang.reflect.Field)CollectionsKt.firstOrNull((List)loaders);
            if (field == null) {
                throw new NoDataLoaderFoundException(loaderClass);
            }
            java.lang.reflect.Field loaderField = field;
            DgsDataLoader theAnnotation = loaderField.getAnnotation(DgsDataLoader.class);
            String loaderName = theAnnotation.name();
            DataLoader dataLoader3 = this.dfe.getDataLoader(loaderName);
            Intrinsics.checkNotNull((Object)dataLoader3);
            dataLoader = dataLoader3;
        }
        return dataLoader;
    }
}

