/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.exceptions.DgsInvalidInputArgumentException;
import com.netflix.graphql.dgs.internal.InputObjectMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J3\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\fH\u0016\u00a2\u0006\u0002\u0010\rJ7\u0010\u000e\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\u000f2\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultInputObjectMapper;", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "customInputObjectMapper", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "conversionService", "Lorg/springframework/core/convert/support/DefaultConversionService;", "mapToJavaObject", "T", "inputMap", "", "", "targetClass", "Ljava/lang/Class;", "(Ljava/util/Map;Ljava/lang/Class;)Ljava/lang/Object;", "mapToKotlinObject", "", "Lkotlin/reflect/KClass;", "(Ljava/util/Map;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "trySetField", "", "declaredField", "Ljava/lang/reflect/Field;", "instance", "value", "Companion", "Converter", "graphql-dgs"})
public final class DefaultInputObjectMapper
implements InputObjectMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultConversionService conversionService;
    @NotNull
    private static final Logger logger;

    public DefaultInputObjectMapper(@Nullable InputObjectMapper customInputObjectMapper) {
        this.conversionService = new DefaultConversionService();
        InputObjectMapper inputObjectMapper = customInputObjectMapper;
        if (inputObjectMapper == null) {
            inputObjectMapper = this;
        }
        this.conversionService.addConverter((GenericConverter)new Converter(inputObjectMapper));
    }

    public /* synthetic */ DefaultInputObjectMapper(InputObjectMapper inputObjectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            inputObjectMapper = null;
        }
        this(inputObjectMapper);
    }

    @Override
    @NotNull
    public <T> T mapToKotlinObject(@NotNull Map<String, ?> inputMap, @NotNull KClass<T> targetClass) {
        Object object;
        Intrinsics.checkNotNullParameter(inputMap, (String)"inputMap");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        KFunction kFunction = KClasses.getPrimaryConstructor(targetClass);
        if (kFunction == null) {
            throw new DgsInvalidInputArgumentException("No primary constructor found for class " + targetClass, null, 2, null);
        }
        KFunction constructor = kFunction;
        List parameters = constructor.getParameters();
        LinkedHashMap parametersByName = CollectionUtils.newLinkedHashMap((int)parameters.size());
        for (KParameter parameter : parameters) {
            Object object2;
            if (!inputMap.containsKey(parameter.getName())) {
                if (parameter.isOptional()) continue;
                if (parameter.getType().isMarkedNullable()) {
                    Intrinsics.checkNotNull((Object)parametersByName);
                    ((Map)parametersByName).put(parameter, null);
                    continue;
                }
                throw new DgsInvalidInputArgumentException("No value specified for required parameter " + parameter.getName() + " of class " + targetClass, null, 2, null);
            }
            Object input = inputMap.get(parameter.getName());
            TypeDescriptor typeDescriptor = new TypeDescriptor(ResolvableType.forType((Type)ReflectJvmMapping.getJavaType((KType)parameter.getType())), null, null);
            try {
                object2 = this.conversionService.convert(input, typeDescriptor);
            }
            catch (ConversionException exc) {
                throw new DgsInvalidInputArgumentException("Failed to convert value " + input + " to " + typeDescriptor, (Exception)((Object)exc));
            }
            Object convertedValue = object2;
            Intrinsics.checkNotNull((Object)parametersByName);
            ((Map)parametersByName).put(parameter, convertedValue);
        }
        try {
            Intrinsics.checkNotNull((Object)parametersByName);
            object = constructor.callBy((Map)parametersByName);
        }
        catch (Exception ex) {
            throw new DgsInvalidInputArgumentException("Provided input arguments do not match arguments of data class `" + targetClass + "`", ex);
        }
        return (T)object;
    }

    @Override
    public <T> T mapToJavaObject(@NotNull Map<String, ?> inputMap, @NotNull Class<T> targetClass) {
        Intrinsics.checkNotNullParameter(inputMap, (String)"inputMap");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        if (targetClass.isAssignableFrom(inputMap.getClass())) {
            return (T)inputMap;
        }
        Constructor ctor = ReflectionUtils.accessibleConstructor(targetClass, (Class[])new Class[0]);
        Object instance = ctor.newInstance(new Object[0]);
        int nrOfFieldErrors = 0;
        for (Map.Entry<String, ?> entry : inputMap.entrySet()) {
            Object object;
            String name = entry.getKey();
            Object value = entry.getValue();
            Field field = ReflectionUtils.findField(targetClass, (String)name);
            if (field == null) {
                ++nrOfFieldErrors;
                logger.warn("Field '{}' was not found on Input object of type '{}'", (Object)name, targetClass);
                continue;
            }
            TypeDescriptor fieldType = new TypeDescriptor(ResolvableType.forField((Field)field, targetClass), null, null);
            try {
                object = this.conversionService.convert(value, fieldType);
            }
            catch (ConversionException exc) {
                throw new DgsInvalidInputArgumentException("Failed to convert value " + value + " to " + fieldType, (Exception)((Object)exc));
            }
            Object convertedValue = object;
            this.trySetField(field, instance, convertedValue);
        }
        if (!inputMap.isEmpty() && nrOfFieldErrors == inputMap.size()) {
            throw new DgsInvalidInputArgumentException("Input argument type '" + targetClass + "' doesn't match input " + inputMap, null, 2, null);
        }
        return instance;
    }

    private final void trySetField(Field declaredField, Object instance, Object value) {
        try {
            ReflectionUtils.makeAccessible((Field)declaredField);
            ReflectionUtils.setField((Field)declaredField, (Object)instance, (Object)value);
        }
        catch (Exception ex) {
            Class<?> clazz;
            throw new DgsInvalidInputArgumentException("Invalid input argument `" + value + "` for field `" + declaredField.getName() + "` on type `" + ((clazz = instance) != null && (clazz = clazz.getClass()) != null ? clazz.getName() : null) + "`", null, 2, null);
        }
    }

    public DefaultInputObjectMapper() {
        this(null, 1, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(InputObjectMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DefaultInputObjectMapper.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultInputObjectMapper$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultInputObjectMapper$Converter;", "Lorg/springframework/core/convert/converter/ConditionalGenericConverter;", "mapper", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "convert", "", "source", "sourceType", "Lorg/springframework/core/convert/TypeDescriptor;", "targetType", "getConvertibleTypes", "", "Lorg/springframework/core/convert/converter/GenericConverter$ConvertiblePair;", "matches", "", "graphql-dgs"})
    private static final class Converter
    implements ConditionalGenericConverter {
        @NotNull
        private final InputObjectMapper mapper;

        public Converter(@NotNull InputObjectMapper mapper) {
            Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
            this.mapper = mapper;
        }

        @NotNull
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return SetsKt.setOf((Object)new GenericConverter.ConvertiblePair(Map.class, Object.class));
        }

        public boolean matches(@NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            if (sourceType.isMap()) {
                TypeDescriptor keyDescriptor = sourceType.getMapKeyTypeDescriptor();
                return keyDescriptor == null || Intrinsics.areEqual((Object)keyDescriptor.getType(), String.class);
            }
            return false;
        }

        @Nullable
        public Object convert(@Nullable Object source, @NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
            Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Intrinsics.checkNotNull((Object)source, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            Map sourceMap = (Map)source;
            if (KotlinDetector.isKotlinType((Class)targetType.getType())) {
                Class clazz = targetType.getType();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getType(...)");
                return this.mapper.mapToKotlinObject(sourceMap, JvmClassMappingKt.getKotlinClass((Class)clazz));
            }
            Class clazz = targetType.getType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getType(...)");
            return this.mapper.mapToJavaObject(sourceMap, clazz);
        }
    }
}

