/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.task.AsyncTaskExecutor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class VirtualThreadTaskExecutor
implements AsyncTaskExecutor {
    private final ThreadFactory threadFactory = Thread.ofVirtual().name("dgs-virtual-thread-", 0L).factory();

    public void execute(@NotNull Runnable task) {
        this.threadFactory.newThread(task).start();
    }

    @Deprecated
    public void execute(@NotNull Runnable task, long startTimeout) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future);
    }

    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future);
        return future;
    }

    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future);
        return future;
    }
}

