/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.federation;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.exceptions.InvalidDgsEntityFetcher;
import com.netflix.graphql.dgs.exceptions.MissingDgsEntityFetcherException;
import com.netflix.graphql.dgs.exceptions.MissingFederatedQueryArgument;
import com.netflix.graphql.dgs.federation.DefaultDgsFederationResolver;
import com.netflix.graphql.dgs.internal.EntityFetcherRegistry;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.TypeResolutionEnvironment;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ResultPath;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.GraphQLObjectType;
import graphql.schema.TypeResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.Try;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

@DgsComponent
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0017\u0018\u0000 .2\u00020\u0001:\u0001.B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010\u001b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001e0\u001d0\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0016J\u0018\u0010 \u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"\u0012\u0004\u0012\u00020#0!H\u0016J\b\u0010$\u001a\u00020%H\u0016Jb\u0010&\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00100!2\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00100!2 \u0010*\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u001e\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030+0!2\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020#0-H\u0002R$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lcom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver;", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "entityFetcherRegistry", "Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "dataFetcherExceptionHandler", "Ljava/util/Optional;", "Lgraphql/execution/DataFetcherExceptionHandler;", "(Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;Ljava/util/Optional;)V", "()V", "dgsExceptionHandler", "getDgsExceptionHandler", "()Ljava/util/Optional;", "setDgsExceptionHandler", "(Ljava/util/Optional;)V", "entitiesDataFetcher", "Lgraphql/schema/DataFetcher;", "", "getEntityFetcherRegistry", "()Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "setEntityFetcherRegistry", "(Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;)V", "createDataFetchingEnvironmentWithPath", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "env", "Lgraphql/schema/DataFetchingEnvironment;", "pathIndex", "", "dgsEntityFetchers", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/execution/DataFetcherResult;", "", "entitiesFetcher", "typeMapping", "", "Ljava/lang/Class;", "", "typeResolver", "Lgraphql/schema/TypeResolver;", "valuesWithMappedScalars", "graphQLContext", "Lgraphql/GraphQLContext;", "values", "scalarMappings", "Lgraphql/schema/Coercing;", "currentPath", "", "Companion", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDefaultDgsFederationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDgsFederationResolver.kt\ncom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,236:1\n453#2:237\n403#2:238\n1238#3,4:239\n1549#3:243\n1620#3,3:244\n37#4,2:247\n12474#5,2:249\n*S KotlinDebug\n*F\n+ 1 DefaultDgsFederationResolver.kt\ncom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver\n*L\n85#1:237\n85#1:238\n85#1:239,4\n108#1:243\n108#1:244,3\n149#1:247,2\n116#1:249,2\n*E\n"})
public class DefaultDgsFederationResolver
implements DgsFederationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Autowired
    public EntityFetcherRegistry entityFetcherRegistry;
    @Autowired
    public Optional<DataFetcherExceptionHandler> dgsExceptionHandler;
    @NotNull
    private final DataFetcher<Object> entitiesDataFetcher;
    @NotNull
    private static final Logger logger;

    public DefaultDgsFederationResolver() {
        this.entitiesDataFetcher = arg_0 -> DefaultDgsFederationResolver.entitiesDataFetcher$lambda$0(this, arg_0);
    }

    public DefaultDgsFederationResolver(@NotNull EntityFetcherRegistry entityFetcherRegistry, @NotNull Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"entityFetcherRegistry");
        Intrinsics.checkNotNullParameter(dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        this();
        this.setEntityFetcherRegistry(entityFetcherRegistry);
        this.setDgsExceptionHandler(dataFetcherExceptionHandler);
    }

    @NotNull
    public final EntityFetcherRegistry getEntityFetcherRegistry() {
        EntityFetcherRegistry entityFetcherRegistry = this.entityFetcherRegistry;
        if (entityFetcherRegistry != null) {
            return entityFetcherRegistry;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"entityFetcherRegistry");
        return null;
    }

    public final void setEntityFetcherRegistry(@NotNull EntityFetcherRegistry entityFetcherRegistry) {
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"<set-?>");
        this.entityFetcherRegistry = entityFetcherRegistry;
    }

    @NotNull
    public final Optional<DataFetcherExceptionHandler> getDgsExceptionHandler() {
        Optional<DataFetcherExceptionHandler> optional = this.dgsExceptionHandler;
        if (optional != null) {
            return optional;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dgsExceptionHandler");
        return null;
    }

    public final void setDgsExceptionHandler(@NotNull Optional<DataFetcherExceptionHandler> optional) {
        Intrinsics.checkNotNullParameter(optional, (String)"<set-?>");
        this.dgsExceptionHandler = optional;
    }

    @Override
    @NotNull
    public DataFetcher<Object> entitiesFetcher() {
        return this.entitiesDataFetcher;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> valuesWithMappedScalars(GraphQLContext graphQLContext, Map<String, ? extends Object> values, Map<List<String>, ? extends Coercing<?, ?>> scalarMappings, List<String> currentPath) {
        void $this$mapValuesTo$iv$iv;
        Map<String, ? extends Object> $this$mapValues$iv = values;
        boolean $i$f$mapValues = false;
        Map<String, ? extends Object> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Object object;
            Object object2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String key = (String)entry2.getKey();
            Object value = entry2.getValue();
            ((Collection)currentPath).add(key);
            Coercing<?, ?> converter = scalarMappings.get(currentPath);
            if (converter != null) {
                object2 = converter.parseValue(value, graphQLContext, Locale.getDefault());
            } else if (value instanceof Map) {
                Map cfr_ignored_0 = (Map)value;
                object2 = this.valuesWithMappedScalars(graphQLContext, (Map)value, scalarMappings, currentPath);
            } else {
                object2 = value;
            }
            Object newValue = object2;
            CollectionsKt.removeLast(currentPath);
            Intrinsics.checkNotNull(newValue);
            map3.put(k, object);
        }
        return destination$iv$iv;
    }

    static /* synthetic */ Map valuesWithMappedScalars$default(DefaultDgsFederationResolver defaultDgsFederationResolver, GraphQLContext graphQLContext, Map map, Map map2, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: valuesWithMappedScalars");
        }
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        return defaultDgsFederationResolver.valuesWithMappedScalars(graphQLContext, map, map2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<DataFetcherResult<List<Object>>> dgsEntityFetchers(DataFetchingEnvironment env) {
        void $this$mapTo$iv$iv;
        Object object = env.getArgument("representations");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getArgument(...)");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void values;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CompletableFuture)Try.tryCall(() -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$6$lambda$3((Map)values, this, env)).map(arg_0 -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$6$lambda$4(dgsEntityFetchers.resultList.1.2.INSTANCE, arg_0)).recover(DefaultDgsFederationResolver::dgsEntityFetchers$lambda$6$lambda$5).get());
        }
        List resultList2 = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = resultList2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletionStage completionStage = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenApply(arg_0 -> DefaultDgsFederationResolver.dgsEntityFetchers$lambda$7((Function1)new Function1<Void, DataFetcherResult<List<? extends Object>>>((List<? extends CompletableFuture<? extends Try<? extends Object>>>)resultList2, this, env){
            final /* synthetic */ List<CompletableFuture<? extends Try<? extends Object>>> $resultList;
            final /* synthetic */ DefaultDgsFederationResolver this$0;
            final /* synthetic */ DataFetchingEnvironment $env;
            {
                this.$resultList = $resultList;
                this.this$0 = $receiver;
                this.$env = $env;
                super(1);
            }

            public final DataFetcherResult<List<Object>> invoke(Void it) {
                Sequence trySequence2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.$resultList), (Function1)dgsEntityFetchers.trySequence.1.INSTANCE);
                return DataFetcherResult.newResult().data((Object)SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)trySequence2, (Function1)dgsEntityFetchers.1.INSTANCE), (Function1)dgsEntityFetchers.2.INSTANCE))).errors(SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapIndexed((Sequence)trySequence2, (Function2)dgsEntityFetchers.3.INSTANCE), (Function1)dgsEntityFetchers.4.INSTANCE), (Function1)dgsEntityFetchers.5.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends Integer, ? extends Throwable>, Sequence<? extends GraphQLError>>(this.this$0, this.$env){
                    final /* synthetic */ DefaultDgsFederationResolver this$0;
                    final /* synthetic */ DataFetchingEnvironment $env;
                    {
                        this.this$0 = $receiver;
                        this.$env = $env;
                        super(1);
                    }

                    @NotNull
                    public final Sequence<GraphQLError> invoke(@NotNull Pair<Integer, ? extends Throwable> pair) {
                        Sequence sequence;
                        Throwable exception;
                        Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                        int idx = ((Number)pair.component1()).intValue();
                        Throwable exc = (Throwable)pair.component2();
                        if (exc instanceof InvocationTargetException) {
                            v0 = ((InvocationTargetException)exc).getTargetException();
                        } else if (exc instanceof CompletionException && exc.getCause() != null) {
                            Throwable throwable = exc.getCause();
                            v0 = throwable;
                            Intrinsics.checkNotNull((Object)throwable);
                        } else {
                            v0 = exception = exc;
                        }
                        if (this.this$0.getDgsExceptionHandler().isPresent()) {
                            DgsDataFetchingEnvironment dfeWithErrorPath = this.this$0.createDataFetchingEnvironmentWithPath(this.$env, idx);
                            CompletableFuture res = this.this$0.getDgsExceptionHandler().get().handleException(DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment((DataFetchingEnvironment)dfeWithErrorPath).exception(exception).build());
                            List list = ((DataFetcherExceptionHandlerResult)res.join()).getErrors();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrors(...)");
                            sequence = CollectionsKt.asSequence((Iterable)list);
                        } else {
                            Object[] objectArray = new TypedGraphQLError[1];
                            Object[] objectArray2 = new Object[]{"/_entities", idx};
                            objectArray[0] = TypedGraphQLError.newInternalErrorBuilder().message(exception.getClass().getName() + ": " + exception.getMessage()).path(ResultPath.fromList((List)CollectionsKt.listOf((Object[])objectArray2))).build();
                            sequence = SequencesKt.sequenceOf((Object[])objectArray);
                        }
                        return sequence;
                    }
                })))).build();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public DgsDataFetchingEnvironment createDataFetchingEnvironmentWithPath(@NotNull DataFetchingEnvironment env, int pathIndex) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        ResultPath pathWithIndex = env.getExecutionStepInfo().getPath().segment(pathIndex);
        ExecutionStepInfo executionStepInfoWithPath = ExecutionStepInfo.newExecutionStepInfo((ExecutionStepInfo)env.getExecutionStepInfo()).path(pathWithIndex).build();
        DataFetchingEnvironment dfe = env instanceof DgsDataFetchingEnvironment ? ((DgsDataFetchingEnvironment)env).getDfe() : env;
        DataFetchingEnvironment dataFetchingEnvironment = DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)dfe).executionStepInfo(executionStepInfoWithPath).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetchingEnvironment, (String)"build(...)");
        return new DgsDataFetchingEnvironment(dataFetchingEnvironment);
    }

    @NotNull
    public Map<Class<?>, String> typeMapping() {
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    public TypeResolver typeResolver() {
        return arg_0 -> DefaultDgsFederationResolver.typeResolver$lambda$8(this, arg_0);
    }

    private static final Object entitiesDataFetcher$lambda$0(DefaultDgsFederationResolver this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)env);
        return this$0.dgsEntityFetchers(env);
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$6$lambda$3(Map $values, DefaultDgsFederationResolver this$0, DataFetchingEnvironment $env) {
        Object result;
        Object[] objectArray;
        Map coercedValues;
        boolean bl;
        Object[] parameterTypes;
        Method method;
        Object target;
        Object typename;
        block9: {
            Intrinsics.checkNotNullParameter((Object)$values, (String)"$values");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$env, (String)"$env");
            Object v = $values.get("__typename");
            if (v == null) {
                String[] stringArray = new String[]{"__typename"};
                throw new MissingFederatedQueryArgument(stringArray);
            }
            typename = v;
            Pair<Object, Method> pair = this$0.getEntityFetcherRegistry().getEntityFetchers().get(typename);
            if (pair == null) {
                throw new MissingDgsEntityFetcherException(typename.toString());
            }
            Pair<Object, Method> pair2 = pair;
            target = pair2.component1();
            method = (Method)pair2.component2();
            parameterTypes = method.getParameterTypes();
            Intrinsics.checkNotNull(parameterTypes);
            Object[] $this$any$iv = parameterTypes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                Class<Map> element$iv;
                Class<Map> it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!it.isAssignableFrom(Map.class)) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (!bl) {
            throw new InvalidDgsEntityFetcher("@DgsEntityFetcher " + target.getClass().getName() + "." + method.getName() + " is invalid. A DgsEntityFetcher must accept an argument of type Map<String, Object>");
        }
        if (this$0.getEntityFetcherRegistry().getEntityFetcherInputMappings().get(typename) != null) {
            GraphQLContext graphQLContext = $env.getGraphQlContext();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLContext, (String)"getGraphQlContext(...)");
            Map<List<String>, Coercing<?, ?>> map = this$0.getEntityFetcherRegistry().getEntityFetcherInputMappings().get(typename);
            Intrinsics.checkNotNull(map);
            v5 = DefaultDgsFederationResolver.valuesWithMappedScalars$default(this$0, graphQLContext, $values, map, null, 8, null);
        } else {
            v5 = coercedValues = $values;
        }
        if (((Class)ArraysKt.last((Object[])parameterTypes)).isAssignableFrom(DgsDataFetchingEnvironment.class)) {
            objectArray = new Object[]{coercedValues, new DgsDataFetchingEnvironment($env)};
            v6 = ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])objectArray);
        } else {
            objectArray = new Object[]{coercedValues};
            v6 = result = ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])objectArray);
        }
        if (result == null) {
            logger.error("@DgsEntityFetcher returned null for type: {}", typename);
            CompletableFuture.completedFuture(null);
        }
        return (objectArray = result) instanceof CompletionStage ? ((CompletionStage)result).toCompletableFuture() : (objectArray instanceof Mono ? ((Mono)result).toFuture() : CompletableFuture.completedFuture(result));
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    private static final CompletableFuture dgsEntityFetchers$lambda$6$lambda$5(Throwable exception) {
        return CompletableFuture.completedFuture(Try.failed((Throwable)exception));
    }

    private static final DataFetcherResult dgsEntityFetchers$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataFetcherResult)$tmp0.invoke(p0);
    }

    private static final GraphQLObjectType typeResolver$lambda$8(DefaultDgsFederationResolver this$0, TypeResolutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = env.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
        Object src = object;
        String typeName = this$0.typeMapping().containsKey(src.getClass()) ? this$0.typeMapping().get(src.getClass()) : src.getClass().getSimpleName();
        GraphQLObjectType type = env.getSchema().getObjectType(typeName);
        if (type == null) {
            logger.warn("No type definition found for {}. You probably need to provide either a type mapping,or override DefaultDgsFederationResolver.typeResolver().Alternatively make sure the type name in the schema and your Java model match", (Object)src.getClass().getName());
        }
        return type;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultDgsFederationResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DefaultDgsFederationResolver.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/federation/DefaultDgsFederationResolver$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

