/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.graphql.dgs.DgsExecutionResult;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.DgsBadRequestException;
import com.netflix.graphql.dgs.exceptions.DgsException;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dataloader.DataLoaderRegistry;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0098\u0001\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010$\u001a\u0004\u0018\u00010%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lcom/netflix/graphql/dgs/internal/BaseDgsQueryExecutor;", "", "()V", "logger", "Lorg/slf4j/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "parseContext", "Lcom/jayway/jsonpath/ParseContext;", "getParseContext", "()Lcom/jayway/jsonpath/ParseContext;", "baseExecute", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/ExecutionResult;", "query", "", "variables", "", "extensions", "operationName", "dgsContext", "Lcom/netflix/graphql/dgs/context/DgsContext;", "graphQLSchema", "Lgraphql/schema/GraphQLSchema;", "dataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "instrumentation", "Lgraphql/execution/instrumentation/Instrumentation;", "queryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "mutationExecutionStrategy", "idProvider", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionIdProvider;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nBaseDgsQueryExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseDgsQueryExecutor.kt\ncom/netflix/graphql/dgs/internal/BaseDgsQueryExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class BaseDgsQueryExecutor {
    @NotNull
    public static final BaseDgsQueryExecutor INSTANCE = new BaseDgsQueryExecutor();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final ParseContext parseContext;

    private BaseDgsQueryExecutor() {
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @NotNull
    public final ParseContext getParseContext() {
        return parseContext;
    }

    @NotNull
    public final CompletableFuture<ExecutionResult> baseExecute(@Language(value="graphql") @Nullable String query, @Nullable Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions, @Nullable String operationName, @NotNull DgsContext dgsContext, @NotNull GraphQLSchema graphQLSchema, @NotNull DgsDataLoaderProvider dataLoaderProvider, @Nullable Instrumentation instrumentation, @NotNull ExecutionStrategy queryExecutionStrategy, @NotNull ExecutionStrategy mutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @Nullable PreparsedDocumentProvider preparsedDocumentProvider) {
        CompletableFuture<ExecutionResult> completableFuture;
        PreparsedDocumentProvider it;
        Map inputVariables;
        Intrinsics.checkNotNullParameter((Object)dgsContext, (String)"dgsContext");
        Intrinsics.checkNotNullParameter((Object)graphQLSchema, (String)"graphQLSchema");
        Intrinsics.checkNotNullParameter((Object)dataLoaderProvider, (String)"dataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Map map = variables;
        if (map == null) {
            map = inputVariables = MapsKt.emptyMap();
        }
        if (!StringUtils.hasText((String)query)) {
            DgsExecutionResult.Builder builder = DgsExecutionResult.Companion.builder().status(HttpStatus.BAD_REQUEST);
            ExecutionResult executionResult = ExecutionResult.newExecutionResult().addError((GraphQLError)DgsException.toGraphQlError$default(DgsBadRequestException.Companion.getNULL_OR_EMPTY_QUERY_EXCEPTION(), null, 1, null)).build();
            Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"build(...)");
            CompletableFuture<ExecutionResult> completableFuture2 = CompletableFuture.completedFuture(builder.executionResult(executionResult).build());
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
            return completableFuture2;
        }
        GraphQL.Builder graphQLBuilder = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).queryExecutionStrategy(queryExecutionStrategy).mutationExecutionStrategy(mutationExecutionStrategy);
        PreparsedDocumentProvider preparsedDocumentProvider2 = preparsedDocumentProvider;
        if (preparsedDocumentProvider2 != null) {
            it = preparsedDocumentProvider2;
            boolean bl = false;
            graphQLBuilder.preparsedDocumentProvider(it);
        }
        Instrumentation instrumentation2 = instrumentation;
        if (instrumentation2 != null) {
            it = instrumentation2;
            boolean bl = false;
            graphQLBuilder.instrumentation((Instrumentation)it);
        }
        idProvider.ifPresent(arg_0 -> BaseDgsQueryExecutor.baseExecute$lambda$2((Function1)new Function1<ExecutionIdProvider, Unit>(graphQLBuilder){
            final /* synthetic */ GraphQL.Builder $graphQLBuilder;
            {
                this.$graphQLBuilder = $graphQLBuilder;
                super(1);
            }

            public final void invoke(@NotNull ExecutionIdProvider it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$graphQLBuilder.executionIdProvider(it);
            }
        }, arg_0));
        GraphQL graphQL = graphQLBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"build(...)");
        GraphQL graphQL2 = graphQL;
        Ref.ObjectRef executionInput = new Ref.ObjectRef();
        DataLoaderRegistry dataLoaderRegistry = dataLoaderProvider.buildRegistryWithContextSupplier(() -> BaseDgsQueryExecutor.baseExecute$lambda$3(executionInput));
        ExecutionInput.Builder builder = ExecutionInput.newExecutionInput().query(query).operationName(operationName).variables(inputVariables).dataLoaderRegistry(dataLoaderRegistry).context((Object)dgsContext).graphQLContext((Consumer)dgsContext);
        Map map2 = extensions;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        ExecutionInput executionInput2 = builder.extensions(map2).build();
        Intrinsics.checkNotNullExpressionValue((Object)executionInput2, (String)"build(...)");
        executionInput.element = executionInput2;
        try {
            ExecutionInput executionInput3;
            if (executionInput.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executionInput");
                executionInput3 = null;
            } else {
                executionInput3 = (ExecutionInput)executionInput.element;
            }
            CompletableFuture future = graphQL2.executeAsync(executionInput3);
            if (dataLoaderRegistry instanceof AutoCloseable) {
                future.whenComplete((arg_0, arg_1) -> BaseDgsQueryExecutor.baseExecute$lambda$4((Function2)new Function2<ExecutionResult, Throwable, Unit>(dataLoaderRegistry){
                    final /* synthetic */ DataLoaderRegistry $dataLoaderRegistry;
                    {
                        this.$dataLoaderRegistry = $dataLoaderRegistry;
                        super(2);
                    }

                    public final void invoke(ExecutionResult executionResult, Throwable throwable) {
                        ((AutoCloseable)this.$dataLoaderRegistry).close();
                    }
                }, arg_0, arg_1));
            }
            completableFuture = future.exceptionally(arg_0 -> BaseDgsQueryExecutor.baseExecute$lambda$5(query, arg_0));
            Intrinsics.checkNotNull((Object)completableFuture);
        }
        catch (Exception e) {
            logger.error("Encountered an exception while handling query {}", (Object)query, (Object)e);
            ExecutionResult.Builder executionResult = ExecutionResult.newExecutionResult();
            if (e instanceof GraphQLError) {
                executionResult.addError((GraphQLError)e);
            } else {
                executionResult.addError((GraphQLError)TypedGraphQLError.newInternalErrorBuilder().build());
            }
            CompletableFuture<ExecutionResult> completableFuture3 = CompletableFuture.completedFuture(executionResult.build());
            Intrinsics.checkNotNull(completableFuture3);
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    private static final void baseExecute$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final GraphQLContext baseExecute$lambda$3(Ref.ObjectRef $executionInput) {
        ExecutionInput executionInput;
        Intrinsics.checkNotNullParameter((Object)$executionInput, (String)"$executionInput");
        if ($executionInput.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executionInput");
            executionInput = null;
        } else {
            executionInput = (ExecutionInput)$executionInput.element;
        }
        return executionInput.getGraphQLContext();
    }

    private static final void baseExecute$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final ExecutionResult baseExecute$lambda$5(String $query, Throwable exc) {
        ExecutionResult executionResult;
        Throwable cause;
        Throwable throwable = cause = exc instanceof CompletionException ? exc.getCause() : exc;
        if (cause instanceof GraphQLError) {
            DgsExecutionResult.Builder builder = DgsExecutionResult.Companion.builder().status(HttpStatus.BAD_REQUEST);
            ExecutionResult executionResult2 = ExecutionResult.newExecutionResult().addError((GraphQLError)cause).build();
            Intrinsics.checkNotNullExpressionValue((Object)executionResult2, (String)"build(...)");
            executionResult = builder.executionResult(executionResult2).build();
        } else {
            logger.error("Encountered an exception while handling query {}", (Object)$query, (Object)cause);
            DgsExecutionResult.Builder builder = DgsExecutionResult.Companion.builder().status(HttpStatus.INTERNAL_SERVER_ERROR);
            ExecutionResult executionResult3 = ExecutionResult.newExecutionResult().addError((GraphQLError)TypedGraphQLError.newInternalErrorBuilder().build()).build();
            Intrinsics.checkNotNullExpressionValue((Object)executionResult3, (String)"build(...)");
            executionResult = builder.executionResult(executionResult3).build();
        }
        return executionResult;
    }

    static {
        Logger logger = LoggerFactory.getLogger(BaseDgsQueryExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        BaseDgsQueryExecutor.logger = logger;
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).registerModule((Module)new JavaTimeModule()).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"disable(...)");
        BaseDgsQueryExecutor.objectMapper = objectMapper;
        Option[] optionArray = new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL};
        ParseContext parseContext = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null))).mappingProvider((MappingProvider)new JacksonMappingProvider(BaseDgsQueryExecutor.objectMapper)).build().addOptions(optionArray));
        Intrinsics.checkNotNullExpressionValue((Object)parseContext, (String)"using(...)");
        BaseDgsQueryExecutor.parseContext = parseContext;
    }
}

