/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import graphql.ExecutionInput;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\u0012H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/netflix/graphql/dgs/DgsDefaultPreparsedDocumentProvider;", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "maximumSize", "", "expireAfterAccess", "Ljava/time/Duration;", "(JLjava/time/Duration;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lgraphql/execution/preparsed/PreparsedDocumentEntry;", "getCache", "()Lcom/github/benmanes/caffeine/cache/Cache;", "getDocumentAsync", "Ljava/util/concurrent/CompletableFuture;", "executionInput", "Lgraphql/ExecutionInput;", "parseAndValidateFunction", "Ljava/util/function/Function;", "graphql-dgs"})
public final class DgsDefaultPreparsedDocumentProvider
implements PreparsedDocumentProvider {
    @NotNull
    private final Cache<String, PreparsedDocumentEntry> cache;

    public DgsDefaultPreparsedDocumentProvider(long maximumSize, @NotNull Duration expireAfterAccess) {
        Intrinsics.checkNotNullParameter((Object)expireAfterAccess, (String)"expireAfterAccess");
        Cache cache = Caffeine.newBuilder().maximumSize(maximumSize).expireAfterAccess(expireAfterAccess).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    @NotNull
    public final Cache<String, PreparsedDocumentEntry> getCache() {
        return this.cache;
    }

    @NotNull
    public CompletableFuture<PreparsedDocumentEntry> getDocumentAsync(@NotNull ExecutionInput executionInput, @NotNull Function<ExecutionInput, PreparsedDocumentEntry> parseAndValidateFunction) {
        Intrinsics.checkNotNullParameter((Object)executionInput, (String)"executionInput");
        Intrinsics.checkNotNullParameter(parseAndValidateFunction, (String)"parseAndValidateFunction");
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(this.cache.get((Object)executionInput.getQuery(), arg_0 -> DgsDefaultPreparsedDocumentProvider.getDocumentAsync$lambda$0((Function1)new Function1<String, PreparsedDocumentEntry>(parseAndValidateFunction, executionInput){
            final /* synthetic */ Function<ExecutionInput, PreparsedDocumentEntry> $parseAndValidateFunction;
            final /* synthetic */ ExecutionInput $executionInput;
            {
                this.$parseAndValidateFunction = $parseAndValidateFunction;
                this.$executionInput = $executionInput;
                super(1);
            }

            public final PreparsedDocumentEntry invoke(String it) {
                return this.$parseAndValidateFunction.apply(this.$executionInput);
            }
        }, arg_0)));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    private static final PreparsedDocumentEntry getDocumentAsync$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PreparsedDocumentEntry)$tmp0.invoke(p0);
    }
}

