/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\n \u000e*\u0004\u0018\u0001H\rH\r\"\u0010\b\u0000\u0010\r*\n \u000e*\u0004\u0018\u00010\u000f0\u000fH\u0096\u0001\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00130\u0013 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00140\u0012H\u0096\u0001JI\u0010\u0015\u001aB\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f \u000e* \u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00170\u0016H\u0096\u0001J\u0006\u0010\u0003\u001a\u00020\u0004J\t\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0016J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lcom/netflix/graphql/dgs/DgsExecutionResult;", "Lgraphql/ExecutionResult;", "executionResult", "headers", "Lorg/springframework/http/HttpHeaders;", "status", "Lorg/springframework/http/HttpStatus;", "(Lgraphql/ExecutionResult;Lorg/springframework/http/HttpHeaders;Lorg/springframework/http/HttpStatus;)V", "getStatus", "()Lorg/springframework/http/HttpStatus;", "addExtensionsHeaderKeyToHeader", "", "getData", "T", "kotlin.jvm.PlatformType", "", "()Ljava/lang/Object;", "getErrors", "", "Lgraphql/GraphQLError;", "", "getExtensions", "", "", "isDataPresent", "", "toSpecification", "", "toSpringResponse", "Lorg/springframework/http/ResponseEntity;", "Builder", "Companion", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsExecutionResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsExecutionResult.kt\ncom/netflix/graphql/dgs/DgsExecutionResult\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,139:1\n215#2,2:140\n*S KotlinDebug\n*F\n+ 1 DgsExecutionResult.kt\ncom/netflix/graphql/dgs/DgsExecutionResult\n*L\n81#1:140,2\n*E\n"})
public final class DgsExecutionResult
implements ExecutionResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutionResult executionResult;
    @NotNull
    private HttpHeaders headers;
    @NotNull
    private final HttpStatus status;
    @NotNull
    public static final String DGS_RESPONSE_HEADERS_KEY = "dgs-response-headers";
    @NotNull
    private static final Logger logger;

    public DgsExecutionResult(@NotNull ExecutionResult executionResult, @NotNull HttpHeaders headers, @NotNull HttpStatus status) {
        Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.executionResult = executionResult;
        this.headers = headers;
        this.status = status;
        this.addExtensionsHeaderKeyToHeader();
    }

    @NotNull
    public final HttpStatus getStatus() {
        return this.status;
    }

    public <T> T getData() {
        return (T)this.executionResult.getData();
    }

    public List<GraphQLError> getErrors() {
        return this.executionResult.getErrors();
    }

    public Map<Object, Object> getExtensions() {
        return this.executionResult.getExtensions();
    }

    public boolean isDataPresent() {
        return this.executionResult.isDataPresent();
    }

    @NotNull
    public final HttpHeaders headers() {
        HttpHeaders httpHeaders = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.headers);
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"readOnlyHttpHeaders(...)");
        return httpHeaders;
    }

    @NotNull
    public final ResponseEntity<Object> toSpringResponse() {
        return new ResponseEntity(this.toSpecification(), (MultiValueMap)this.headers, (HttpStatusCode)this.status);
    }

    @NotNull
    public Map<String, Object> toSpecification() {
        Map spec = this.executionResult.toSpecification();
        Map map = (Map)spec.get("extensions");
        if (map == null) {
            Intrinsics.checkNotNull((Object)spec);
            return spec;
        }
        Map extensions = map;
        if (extensions.containsKey(DGS_RESPONSE_HEADERS_KEY)) {
            if (extensions.size() == 1) {
                Intrinsics.checkNotNull((Object)spec);
                spec.remove("extensions");
            } else {
                Intrinsics.checkNotNull((Object)spec);
                spec.put("extensions", MapsKt.minus((Map)extensions, (Object)DGS_RESPONSE_HEADERS_KEY));
            }
        }
        Intrinsics.checkNotNull((Object)spec);
        return spec;
    }

    private final void addExtensionsHeaderKeyToHeader() {
        Map map = this.executionResult.getExtensions();
        if (map == null) {
            return;
        }
        Map extensions = map;
        Object v = extensions.get(DGS_RESPONSE_HEADERS_KEY);
        if (v == null) {
            return;
        }
        Object dgsResponseHeaders = v;
        if (dgsResponseHeaders instanceof Map && !((Map)dgsResponseHeaders).isEmpty()) {
            HttpHeaders updatedHeaders = HttpHeaders.writableHttpHeaders((HttpHeaders)this.headers);
            Map $this$forEach$iv = (Map)dgsResponseHeaders;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null) continue;
                Object v2 = value;
                updatedHeaders.add(key.toString(), v2 != null ? v2.toString() : null);
            }
            HttpHeaders httpHeaders = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)updatedHeaders);
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"readOnlyHttpHeaders(...)");
            this.headers = httpHeaders;
        } else {
            logger.warn("{} must be of type java.util.Map, but was {}", (Object)DGS_RESPONSE_HEADERS_KEY, (Object)dgsResponseHeaders.getClass().getName());
        }
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsExecutionResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DgsExecutionResult.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u0012\u0010\u0005\u001a\u00020\u00002\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/DgsExecutionResult$Builder;", "", "()V", "<set-?>", "Lgraphql/ExecutionResult;", "executionResult", "getExecutionResult", "()Lgraphql/ExecutionResult;", "Lorg/springframework/http/HttpHeaders;", "headers", "getHeaders", "()Lorg/springframework/http/HttpHeaders;", "Lorg/springframework/http/HttpStatus;", "status", "getStatus", "()Lorg/springframework/http/HttpStatus;", "build", "Lcom/netflix/graphql/dgs/DgsExecutionResult;", "executionResultBuilder", "Lgraphql/ExecutionResultImpl$Builder;", "Companion", "graphql-dgs"})
    @SourceDebugExtension(value={"SMAP\nDgsExecutionResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsExecutionResult.kt\ncom/netflix/graphql/dgs/DgsExecutionResult$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private ExecutionResult executionResult;
        @NotNull
        private HttpHeaders headers;
        @NotNull
        private HttpStatus status;
        private static final ExecutionResult DEFAULT_EXECUTION_RESULT = ExecutionResultImpl.newExecutionResult().build();

        public Builder() {
            ExecutionResult executionResult = DEFAULT_EXECUTION_RESULT;
            Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"DEFAULT_EXECUTION_RESULT");
            this.executionResult = executionResult;
            HttpHeaders httpHeaders = HttpHeaders.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"EMPTY");
            this.headers = httpHeaders;
            this.status = HttpStatus.OK;
        }

        @NotNull
        public final ExecutionResult getExecutionResult() {
            return this.executionResult;
        }

        @NotNull
        public final Builder executionResult(@NotNull ExecutionResult executionResult) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
            Builder $this$executionResult_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$executionResult_u24lambda_u240.executionResult = executionResult;
            return builder;
        }

        @NotNull
        public final Builder executionResult(@NotNull ExecutionResultImpl.Builder<?> executionResultBuilder) {
            Builder builder;
            Intrinsics.checkNotNullParameter(executionResultBuilder, (String)"executionResultBuilder");
            Builder $this$executionResult_u24lambda_u241 = builder = this;
            boolean bl = false;
            ExecutionResult executionResult = executionResultBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"build(...)");
            $this$executionResult_u24lambda_u241.executionResult = executionResult;
            return builder;
        }

        @NotNull
        public final HttpHeaders getHeaders() {
            return this.headers;
        }

        @NotNull
        public final Builder headers(@NotNull HttpHeaders headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder $this$headers_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u242.headers = headers;
            return builder;
        }

        @NotNull
        public final HttpStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final Builder status(@NotNull HttpStatus status) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Builder $this$status_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$status_u24lambda_u243.status = status;
            return builder;
        }

        @NotNull
        public final DgsExecutionResult build() {
            return new DgsExecutionResult(this.executionResult, this.headers, this.status);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/DgsExecutionResult$Builder$Companion;", "", "()V", "DEFAULT_EXECUTION_RESULT", "Lgraphql/ExecutionResult;", "kotlin.jvm.PlatformType", "graphql-dgs"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/DgsExecutionResult$Companion;", "", "()V", "DGS_RESPONSE_HEADERS_KEY", "", "logger", "Lorg/slf4j/Logger;", "builder", "Lcom/netflix/graphql/dgs/DgsExecutionResult$Builder;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

