/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.internal.DgsDataLoaderRegistry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.registries.DispatchPredicate;
import org.dataloader.registries.ScheduledDataLoaderRegistry;
import org.dataloader.stats.Statistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0016JD\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0006\u0010\r\u001a\u00020\u00052\u001a\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J*\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f\u0018\u00010\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0016\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\u0017H\u0016J\u001c\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00052\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nH\u0016J&\u0010 \u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00052\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderRegistry;", "Lorg/dataloader/DataLoaderRegistry;", "()V", "scheduledDataLoaderRegistries", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/dataloader/registries/ScheduledDataLoaderRegistry;", "combine", "registry", "computeIfAbsent", "Lorg/dataloader/DataLoader;", "K", "V", "key", "mappingFunction", "Ljava/util/function/Function;", "dispatchAll", "", "dispatchAllWithCount", "", "dispatchDepth", "getDataLoader", "getDataLoaders", "", "getDataLoadersMap", "", "getKeys", "", "getStatistics", "Lorg/dataloader/stats/Statistics;", "register", "dataLoader", "registerWithDispatchPredicate", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "unregister", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsDataLoaderRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsDataLoaderRegistry.kt\ncom/netflix/graphql/dgs/internal/DgsDataLoaderRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1855#2,2:192\n1855#2,2:194\n1855#2,2:196\n1789#2,3:199\n1789#2,3:202\n1#3:198\n*S KotlinDebug\n*F\n+ 1 DgsDataLoaderRegistry.kt\ncom/netflix/graphql/dgs/internal/DgsDataLoaderRegistry\n*L\n122#1:192,2\n161#1:194,2\n162#1:196,2\n185#1:199,3\n188#1:202,3\n*E\n"})
public class DgsDataLoaderRegistry
extends DataLoaderRegistry {
    @NotNull
    private final ConcurrentMap<String, ScheduledDataLoaderRegistry> scheduledDataLoaderRegistries = new ConcurrentHashMap();

    @NotNull
    public DataLoaderRegistry register(@NotNull String key, @NotNull DataLoader<?, ?> dataLoader) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(dataLoader, (String)"dataLoader");
        super.register(key, dataLoader);
        return this;
    }

    @NotNull
    public final DataLoaderRegistry registerWithDispatchPredicate(@NotNull String key, @NotNull DataLoader<?, ?> dataLoader, @NotNull DispatchPredicate dispatchPredicate) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(dataLoader, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)dispatchPredicate, (String)"dispatchPredicate");
        ScheduledDataLoaderRegistry registry = ScheduledDataLoaderRegistry.newScheduledRegistry().register(key, dataLoader).dispatchPredicate(dispatchPredicate).build();
        this.scheduledDataLoaderRegistries.putIfAbsent(key, registry);
        return this;
    }

    @NotNull
    public <K, V> DataLoader<K, V> computeIfAbsent(@NotNull String key, @NotNull Function<String, DataLoader<?, ?>> mappingFunction) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        DataLoader dataLoader = super.computeIfAbsent(key, mappingFunction);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"computeIfAbsent(...)");
        return dataLoader;
    }

    @Nullable
    public DataLoaderRegistry combine(@NotNull DataLoaderRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        throw new UnsupportedOperationException("Cannot combine a DgsDataLoaderRegistry with another registry");
    }

    @NotNull
    public List<DataLoader<?, ?>> getDataLoaders() {
        return SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.scheduledDataLoaderRegistries.values()), (Function1)getDataLoaders.1.INSTANCE), (Iterable)this.dataLoaders.values()));
    }

    @NotNull
    public Map<String, DataLoader<?, ?>> getDataLoadersMap() {
        LinkedHashMap dataLoadersMap = new LinkedHashMap();
        Iterable $this$forEach$iv = this.scheduledDataLoaderRegistries.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScheduledDataLoaderRegistry dataLoader = (ScheduledDataLoaderRegistry)element$iv;
            boolean bl = false;
            Map map = dataLoadersMap;
            Map map2 = dataLoader.getDataLoadersMap();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getDataLoadersMap(...)");
            map.putAll(map2);
        }
        Map map = dataLoadersMap;
        Map map3 = this.dataLoaders;
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"dataLoaders");
        map.putAll(map3);
        return dataLoadersMap;
    }

    @NotNull
    public DataLoaderRegistry unregister(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.scheduledDataLoaderRegistries.remove(key);
        super.unregister(key);
        return this;
    }

    @Nullable
    public <K, V> DataLoader<K, V> getDataLoader(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = super.getDataLoader(key);
        if (object == null) {
            ScheduledDataLoaderRegistry scheduledDataLoaderRegistry = (ScheduledDataLoaderRegistry)this.scheduledDataLoaderRegistries.get(key);
            object = scheduledDataLoaderRegistry != null ? scheduledDataLoaderRegistry.getDataLoader(key) : null;
        }
        return object;
    }

    @NotNull
    public Set<String> getKeys() {
        return SetsKt.plus(this.scheduledDataLoaderRegistries.keySet(), (Iterable)this.dataLoaders.keySet());
    }

    public void dispatchAll() {
        Iterable $this$forEach$iv = this.scheduledDataLoaderRegistries.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScheduledDataLoaderRegistry registry = (ScheduledDataLoaderRegistry)element$iv;
            boolean bl = false;
            registry.dispatchAll();
        }
        $this$forEach$iv = this.dataLoaders.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataLoader dataLoader = (DataLoader)element$iv;
            boolean bl = false;
            dataLoader.dispatch();
        }
    }

    /*
     * WARNING - void declaration
     */
    public int dispatchAllWithCount() {
        int n;
        DataLoader registry;
        int n2;
        Iterable iterable = this.scheduledDataLoaderRegistries.values();
        int n3 = 0;
        for (Object t : iterable) {
            ScheduledDataLoaderRegistry scheduledDataLoaderRegistry = (ScheduledDataLoaderRegistry)t;
            n2 = n3;
            boolean bl = false;
            n = registry.dispatchAllWithCount();
            n3 = n2 + n;
        }
        iterable = this.dataLoaders.values();
        n2 = n3;
        n3 = 0;
        for (Object t : iterable) {
            void dataLoader;
            registry = (DataLoader)t;
            n = n3;
            boolean bl = false;
            int n4 = dataLoader.dispatchWithCounts().getKeysCount();
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    /*
     * WARNING - void declaration
     */
    public int dispatchDepth() {
        int n;
        DataLoader registry;
        int n2;
        Iterable iterable = this.scheduledDataLoaderRegistries.values();
        int n3 = 0;
        for (Object t : iterable) {
            ScheduledDataLoaderRegistry scheduledDataLoaderRegistry = (ScheduledDataLoaderRegistry)t;
            n2 = n3;
            boolean bl = false;
            n = registry.dispatchDepth();
            n3 = n2 + n;
        }
        iterable = this.dataLoaders.values();
        n2 = n3;
        n3 = 0;
        for (Object t : iterable) {
            void dataLoader;
            registry = (DataLoader)t;
            n = n3;
            boolean bl = false;
            int n4 = dataLoader.dispatchDepth();
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Statistics getStatistics() {
        Iterable $this$fold$iv;
        Iterable iterable = this.scheduledDataLoaderRegistries.values();
        Statistics initial$iv = new Statistics();
        boolean $i$f$fold = false;
        Statistics accumulator$iv = initial$iv;
        for (Object element$iv2 : $this$fold$iv) {
            void registry;
            ScheduledDataLoaderRegistry scheduledDataLoaderRegistry = (ScheduledDataLoaderRegistry)element$iv2;
            Statistics acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.combine(registry.getStatistics()), (String)"combine(...)");
        }
        Statistics stats = accumulator$iv;
        $this$fold$iv = this.dataLoaders.values();
        boolean $i$f$fold2 = false;
        Statistics accumulator$iv2 = stats;
        for (Object element$iv : $this$fold$iv) {
            void dataLoader;
            Object element$iv2;
            element$iv2 = (DataLoader)element$iv;
            Statistics acc = accumulator$iv2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.combine(dataLoader.getStatistics()), (String)"combine(...)");
        }
        return accumulator$iv2;
    }
}

