/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.model;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.tools.query.HollowFieldMatchQuery;
import com.netflix.hollow.tools.traverse.TransitiveSetTraverser;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryResult {
    private final List<QueryClause> queryClauses = new ArrayList<QueryClause>();
    private final Map<String, BitSet> queryMatches = new HashMap<String, BitSet>();
    private long randomizedStateTag;

    public QueryResult(long randomizedStateTag) {
        this.randomizedStateTag = randomizedStateTag;
    }

    public List<QueryClause> getQueryClauses() {
        return this.queryClauses;
    }

    public String getQueryDisplayString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.queryClauses.size(); ++i) {
            if (i > 0) {
                builder.append(" AND ");
            }
            builder.append(this.queryClauses.get(i));
        }
        return builder.toString();
    }

    public Map<String, BitSet> getQueryMatches() {
        return this.queryMatches;
    }

    public void recalculateIfNotCurrent(HollowReadStateEngine stateEngine) {
        if (stateEngine.getCurrentRandomizedTag() != this.randomizedStateTag) {
            this.queryMatches.clear();
            ArrayList<QueryClause> requeryClauses = new ArrayList<QueryClause>(this.queryClauses);
            this.queryClauses.clear();
            for (QueryClause clause : requeryClauses) {
                this.augmentQuery(clause, stateEngine);
            }
            this.randomizedStateTag = stateEngine.getCurrentRandomizedTag();
        }
    }

    public void augmentQuery(QueryClause clause, HollowReadStateEngine stateEngine) {
        HollowFieldMatchQuery query = new HollowFieldMatchQuery(stateEngine);
        Map clauseMatches = clause.getType() != null ? query.findMatchingRecords(clause.getType(), clause.getField(), clause.getValue()) : query.findMatchingRecords(clause.getField(), clause.getValue());
        TransitiveSetTraverser.addReferencingOutsideClosure((HollowReadStateEngine)stateEngine, (Map)clauseMatches);
        if (this.queryClauses.isEmpty()) {
            this.queryMatches.putAll(clauseMatches);
        } else {
            this.booleanAndQueryMatches(clauseMatches);
        }
        this.queryClauses.add(clause);
    }

    public void booleanAndQueryMatches(Map<String, BitSet> newQueryMatches) {
        Iterator<Map.Entry<String, BitSet>> iter = this.queryMatches.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, BitSet> existingEntry = iter.next();
            BitSet newTypeMatches = newQueryMatches.get(existingEntry.getKey());
            if (newTypeMatches != null) {
                existingEntry.getValue().and(newTypeMatches);
                continue;
            }
            iter.remove();
        }
    }

    public List<QueryTypeMatches> getTypeMatches() {
        ArrayList<QueryTypeMatches> list = new ArrayList<QueryTypeMatches>();
        for (Map.Entry<String, BitSet> entry : this.queryMatches.entrySet()) {
            int numTypeMatches = entry.getValue().cardinality();
            if (numTypeMatches <= 0) continue;
            list.add(new QueryTypeMatches(entry.getKey(), numTypeMatches));
        }
        Collections.sort(list, new Comparator<QueryTypeMatches>(){

            @Override
            public int compare(QueryTypeMatches o1, QueryTypeMatches o2) {
                return Integer.compare(o2.getNumMatches(), o1.getNumMatches());
            }
        });
        return list;
    }

    public static class QueryTypeMatches {
        private final String typeName;
        private final int numMatches;

        public QueryTypeMatches(String typeName, int numMatches) {
            this.typeName = typeName;
            this.numMatches = numMatches;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getNumMatches() {
            return this.numMatches;
        }
    }

    public static class QueryClause {
        private final String type;
        private final String field;
        private final String value;

        public QueryClause(String type, String field, String value) {
            this.type = type;
            this.field = field;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getField() {
            return this.field;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.type != null) {
                builder.append(this.type).append(".");
            }
            builder.append(this.field).append("=\"").append(this.value).append("\"");
            return builder.toString();
        }
    }
}

