/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.model;

import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.explorer.ui.model.SchemaDisplayField;
import java.util.ArrayList;
import java.util.List;

public class SchemaDisplay {
    private final HollowSchema schema;
    private final List<SchemaDisplayField> displayFields;
    private final String fieldPath;
    private boolean isExpanded;

    public SchemaDisplay(HollowSchema schema) {
        this(schema, "");
    }

    public SchemaDisplay(HollowSchema schema, String fieldPath) {
        this.schema = schema;
        this.fieldPath = fieldPath;
        this.displayFields = this.createDisplayFields();
        this.isExpanded = false;
    }

    private List<SchemaDisplayField> createDisplayFields() {
        ArrayList<SchemaDisplayField> displayFields = new ArrayList<SchemaDisplayField>();
        switch (this.schema.getSchemaType()) {
            case OBJECT: {
                HollowObjectSchema objSchema = (HollowObjectSchema)this.schema;
                for (int i = 0; i < objSchema.numFields(); ++i) {
                    displayFields.add(new SchemaDisplayField(this.fieldPath + "." + objSchema.getFieldName(i), objSchema, i));
                }
                return displayFields;
            }
            case LIST: 
            case SET: {
                HollowCollectionSchema collSchema = (HollowCollectionSchema)this.schema;
                displayFields.add(new SchemaDisplayField(this.fieldPath + ".element", collSchema));
                return displayFields;
            }
            case MAP: {
                HollowMapSchema mapSchema = (HollowMapSchema)this.schema;
                displayFields.add(new SchemaDisplayField(this.fieldPath + ".key", mapSchema, 0));
                displayFields.add(new SchemaDisplayField(this.fieldPath + ".value", mapSchema, 1));
                return displayFields;
            }
        }
        throw new IllegalArgumentException();
    }

    public String getTypeName() {
        return this.schema.getName();
    }

    public HollowSchema getSchema() {
        return this.schema;
    }

    public List<SchemaDisplayField> getFields() {
        return this.displayFields;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }
}

