/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.model;

import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.explorer.ui.model.SchemaDisplay;

public class SchemaDisplayField {
    private final String fieldName;
    private final String fieldPath;
    private final HollowObjectSchema.FieldType fieldType;
    private final boolean isSearchable;
    private final SchemaDisplay referencedType;

    public SchemaDisplayField(String fieldPath, HollowCollectionSchema parentSchema) {
        this.fieldPath = fieldPath;
        this.fieldName = "element";
        this.fieldType = HollowObjectSchema.FieldType.REFERENCE;
        this.isSearchable = false;
        this.referencedType = new SchemaDisplay(parentSchema.getElementTypeState().getSchema(), fieldPath);
    }

    public SchemaDisplayField(String fieldPath, HollowMapSchema parentSchema, int fieldNumber) {
        this.fieldPath = fieldPath;
        this.fieldName = fieldNumber == 0 ? "key" : "value";
        this.fieldType = HollowObjectSchema.FieldType.REFERENCE;
        this.isSearchable = false;
        this.referencedType = fieldNumber == 0 ? new SchemaDisplay(parentSchema.getKeyTypeState().getSchema(), fieldPath) : new SchemaDisplay(parentSchema.getValueTypeState().getSchema(), fieldPath);
    }

    public SchemaDisplayField(String fieldPath, HollowObjectSchema parentSchema, int fieldNumber) {
        this.fieldPath = fieldPath;
        this.fieldName = parentSchema.getFieldName(fieldNumber);
        this.fieldType = parentSchema.getFieldType(fieldNumber);
        this.isSearchable = this.isSearchable(parentSchema, fieldNumber);
        this.referencedType = this.fieldType == HollowObjectSchema.FieldType.REFERENCE ? new SchemaDisplay(parentSchema.getReferencedTypeState(fieldNumber).getSchema(), fieldPath) : null;
    }

    private boolean isSearchable(HollowObjectSchema schema, int fieldNumber) {
        if (schema.getFieldType(fieldNumber) == HollowObjectSchema.FieldType.REFERENCE) {
            if (schema.getReferencedTypeState(fieldNumber).getSchema().getSchemaType() != HollowSchema.SchemaType.OBJECT) {
                return false;
            }
            HollowObjectSchema refObjSchema = (HollowObjectSchema)schema.getReferencedTypeState(fieldNumber).getSchema();
            if (refObjSchema.numFields() != 1) {
                return false;
            }
            return this.isSearchable(refObjSchema, 0);
        }
        return true;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public HollowObjectSchema.FieldType getFieldType() {
        return this.fieldType;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public String getFieldPath() {
        return this.fieldPath;
    }

    public SchemaDisplay getReferencedType() {
        return this.referencedType;
    }
}

