/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.model;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.ui.HollowDiffUtil;
import java.text.NumberFormat;

public class TypeOverview {
    private final String typeName;
    private final int numRecords;
    private final int numHoles;
    private final long approxHoleFootprint;
    private final long approxHeapFootprint;
    private final PrimaryKey primaryKey;
    private final HollowSchema schema;
    private final int numShards;

    public TypeOverview(String typeName, int numRecords, int numHoles, long approxHoleFootprint, long approxHeapFootprint, PrimaryKey primaryKey, HollowSchema schema, int numShards) {
        this.typeName = typeName;
        this.numRecords = numRecords;
        this.numHoles = numHoles;
        this.approxHoleFootprint = approxHoleFootprint;
        this.approxHeapFootprint = approxHeapFootprint;
        this.primaryKey = primaryKey;
        this.schema = schema;
        this.numShards = numShards;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getNumRecordsInt() {
        return this.numRecords;
    }

    public String getNumRecords() {
        return NumberFormat.getIntegerInstance().format(this.numRecords);
    }

    public int getNumHolesInt() {
        return this.numHoles;
    }

    public String getNumHoles() {
        return NumberFormat.getIntegerInstance().format(this.numHoles);
    }

    public long getApproxHoleFootprintLong() {
        return this.approxHoleFootprint;
    }

    public String getApproxHoleFootprint() {
        return HollowDiffUtil.formatBytes((long)this.approxHoleFootprint);
    }

    public long getApproxHeapFootprintLong() {
        return this.approxHeapFootprint;
    }

    public String getApproxHeapFootprint() {
        return HollowDiffUtil.formatBytes((long)this.approxHeapFootprint);
    }

    public String getPrimaryKey() {
        return this.primaryKey == null ? "" : this.primaryKey.toString();
    }

    public String getSchema() {
        return this.schema.toString();
    }

    public int getNumShardsInt() {
        return this.numShards;
    }

    public String getNumShards() {
        return NumberFormat.getIntegerInstance().format(this.numShards);
    }
}

