/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter.chunker;

import com.netflix.hollow.jsonadapter.chunker.JsonArrayChunkReader;
import com.netflix.hollow.jsonadapter.chunker.JsonArrayChunkerInputSegment;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;

public class JsonArrayChunker {
    private static final int DEFAULT_SEGMENT_LENGTH = 262144;
    private static final int SEGMENT_QUEUE_SIZE = 32;
    private final Reader reader;
    private final Queue<JsonArrayChunkerInputSegment> bufferSegments;
    private final Executor executor;
    private final int segmentLength;
    private JsonArrayChunkerInputSegment currentSegment;
    private long currentSegmentStartOffset;
    private boolean eofReached;

    public JsonArrayChunker(Reader reader, Executor executor) {
        this(reader, executor, 262144);
    }

    public JsonArrayChunker(Reader reader, Executor executor, int segmentLength) {
        this.reader = reader;
        this.bufferSegments = new LinkedList<JsonArrayChunkerInputSegment>();
        this.executor = executor;
        this.segmentLength = segmentLength;
    }

    public void initialize() throws IOException, InterruptedException {
        while (!this.eofReached && this.bufferSegments.size() < 32) {
            this.fillOneSegment();
        }
        this.nextSegment();
    }

    public Reader nextChunk() throws InterruptedException, IOException {
        while (!this.currentSegment.nextSpecialCharacter()) {
            if (this.nextSegment()) continue;
            return null;
        }
        if (this.currentSegment.specialCharacter() != '{') {
            throw new IllegalStateException("Bad json");
        }
        int nestedObjectCount = 1;
        JsonArrayChunkReader chunkReader = new JsonArrayChunkReader(this.currentSegment, this.currentSegment.specialCharacterIteratorPosition());
        boolean insideQuotes = false;
        long lastEscapeCharacterLocation = Long.MIN_VALUE;
        while (nestedObjectCount > 0) {
            while (!this.currentSegment.nextSpecialCharacter()) {
                if (!this.nextSegment()) {
                    throw new IllegalStateException("Bad json");
                }
                chunkReader.addSegment(this.currentSegment);
            }
            switch (this.currentSegment.specialCharacter()) {
                case '{': {
                    if (insideQuotes) break;
                    ++nestedObjectCount;
                    break;
                }
                case '}': {
                    if (insideQuotes) break;
                    --nestedObjectCount;
                    break;
                }
                case '\"': {
                    long currentLocation = this.currentSegmentStartOffset + (long)this.currentSegment.specialCharacterIteratorPosition();
                    if (lastEscapeCharacterLocation == currentLocation - 1L) break;
                    insideQuotes = !insideQuotes;
                    break;
                }
                case '\\': {
                    long currentLocation = this.currentSegmentStartOffset + (long)this.currentSegment.specialCharacterIteratorPosition();
                    if (lastEscapeCharacterLocation == currentLocation - 1L) break;
                    lastEscapeCharacterLocation = currentLocation;
                }
            }
        }
        chunkReader.setEndOffset(this.currentSegment.specialCharacterIteratorPosition() + 1);
        return chunkReader;
    }

    private boolean nextSegment() throws InterruptedException, IOException {
        if (this.bufferSegments.size() == 0) {
            return false;
        }
        if (!this.eofReached) {
            this.fillOneSegment();
        }
        this.currentSegmentStartOffset += (long)this.segmentLength;
        this.currentSegment = this.bufferSegments.remove();
        this.currentSegment.waitForDefinedOffsets();
        return true;
    }

    private void fillOneSegment() throws IOException {
        final JsonArrayChunkerInputSegment seg = new JsonArrayChunkerInputSegment(this.segmentLength);
        this.eofReached = seg.fill(this.reader);
        this.bufferSegments.add(seg);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                seg.findSpecialCharacterOffsets();
            }
        });
    }
}

