/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.test;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.util.StateEngineRoundTripper;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

public class HollowReadStateEngineBuilder {
    private final HollowWriteStateEngine writeEngine = new HollowWriteStateEngine();
    private final HollowObjectMapper objectMapper = new HollowObjectMapper(this.writeEngine);
    private boolean built;

    public HollowReadStateEngineBuilder() {
        this(Collections.emptyList());
    }

    public HollowReadStateEngineBuilder(Collection<Class<?>> types) {
        for (Class<?> type : types) {
            this.objectMapper.initializeTypeState(type);
        }
    }

    public HollowReadStateEngineBuilder add(Object ... objects) {
        if (this.built) {
            throw new IllegalArgumentException("Cannot add after building HollowReadStateEngine");
        }
        for (Object o : objects) {
            this.objectMapper.add(o);
        }
        return this;
    }

    public HollowReadStateEngine build() {
        this.built = true;
        HollowReadStateEngine readEngine = new HollowReadStateEngine();
        try {
            StateEngineRoundTripper.roundTripSnapshot((HollowWriteStateEngine)this.writeEngine, (HollowReadStateEngine)readEngine, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating HollowReadStateEngine", e);
        }
        return readEngine;
    }
}

