/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.test;

import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class HollowWriteStateEngineBuilder {
    private final HollowWriteStateEngine writeEngine = new HollowWriteStateEngine();
    private final HollowObjectMapper objectMapper = new HollowObjectMapper(this.writeEngine);
    private boolean built;

    public HollowWriteStateEngineBuilder() {
        this(Collections.emptyList());
    }

    public HollowWriteStateEngineBuilder(Collection<Class<?>> types) {
        for (Class<?> type : types) {
            this.objectMapper.initializeTypeState(type);
        }
    }

    public HollowWriteStateEngineBuilder add(Object ... objects) {
        if (this.built) {
            throw new IllegalArgumentException("Cannot add after building Hollow state engine");
        }
        Arrays.stream(objects).forEach(arg_0 -> ((HollowObjectMapper)this.objectMapper).add(arg_0));
        return this;
    }

    public HollowWriteStateEngine build() {
        this.built = true;
        return this.writeEngine;
    }
}

