/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.test.consumer;

import com.netflix.hollow.Internal;
import com.netflix.hollow.PublicSpi;
import com.netflix.hollow.api.client.HollowAPIFactory;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.metrics.HollowConsumerMetrics;
import com.netflix.hollow.api.metrics.HollowMetricsCollector;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.HollowBlobReader;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.util.HollowWriteStateCreator;
import com.netflix.hollow.core.write.HollowBlobWriter;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.test.consumer.TestBlob;
import com.netflix.hollow.test.consumer.TestBlobRetriever;
import com.netflix.hollow.tools.combine.HollowCombiner;
import com.netflix.hollow.tools.combine.HollowCombinerCopyDirector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;

@PublicSpi
public class TestHollowConsumer
extends HollowConsumer {
    private final HollowConsumer.BlobRetriever blobRetriever;

    @Internal
    @Deprecated
    protected TestHollowConsumer(HollowConsumer.BlobRetriever blobRetriever, HollowConsumer.AnnouncementWatcher announcementWatcher, List<HollowConsumer.RefreshListener> refreshListeners, HollowAPIFactory apiFactory, HollowFilterConfig dataFilter, HollowConsumer.ObjectLongevityConfig objectLongevityConfig, HollowConsumer.ObjectLongevityDetector objectLongevityDetector, HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig, HollowObjectHashCodeFinder hashCodeFinder, Executor refreshExecutor, HollowMetricsCollector<HollowConsumerMetrics> metricsCollector) {
        super(blobRetriever, announcementWatcher, refreshListeners, apiFactory, dataFilter, objectLongevityConfig, objectLongevityDetector, doubleSnapshotConfig, hashCodeFinder, refreshExecutor, MemoryMode.ON_HEAP, metricsCollector);
        this.blobRetriever = blobRetriever;
    }

    protected TestHollowConsumer(Builder builder) {
        super((HollowConsumer.Builder)builder);
        this.blobRetriever = builder.blobRetriever();
    }

    public void applySnapshot(long toVersion, HollowWriteStateEngine state) throws IOException {
        this.addSnapshot(toVersion, state);
        this.triggerRefreshTo(toVersion);
    }

    public void applyDelta(long toVersion, HollowWriteStateEngine state) throws IOException {
        this.addDelta(this.getCurrentVersionId(), toVersion, state);
        this.triggerRefreshTo(toVersion);
    }

    public TestHollowConsumer addSnapshot(long version, HollowWriteStateEngine state) throws IOException {
        if (this.getStateEngine() != null) {
            HollowWriteStateEngine snapshotState = HollowWriteStateCreator.createWithSchemas((Collection)this.getStateEngine().getSchemas());
            snapshotState.restoreFrom(this.getStateEngine());
            HollowCombiner combiner = new HollowCombiner(HollowCombinerCopyDirector.DEFAULT_DIRECTOR, snapshotState, new HollowReadStateEngine[]{this.roundTrip(state)});
            combiner.combine();
        }
        if (!(this.blobRetriever instanceof TestBlobRetriever)) {
            throw new IllegalStateException("Cannot add snapshot if not using TestBlobRetriever");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new HollowBlobWriter(state).writeSnapshot((OutputStream)outputStream);
        ((TestBlobRetriever)this.blobRetriever).addSnapshot(version, new TestBlob(version, new ByteArrayInputStream(outputStream.toByteArray())));
        return this;
    }

    public TestHollowConsumer addDelta(long fromVersion, long toVersion, HollowWriteStateEngine state) throws IOException {
        if (this.getStateEngine() == null) {
            throw new UnsupportedOperationException("Delta can not be applied without first applying a snapshot");
        }
        HollowWriteStateEngine deltaState = HollowWriteStateCreator.createWithSchemas((Collection)this.getStateEngine().getSchemas());
        deltaState.restoreFrom(this.getStateEngine());
        HollowCombiner combiner = new HollowCombiner(HollowCombinerCopyDirector.DEFAULT_DIRECTOR, deltaState, new HollowReadStateEngine[]{this.roundTrip(state)});
        combiner.combine();
        if (!(this.blobRetriever instanceof TestBlobRetriever)) {
            throw new IllegalStateException("Cannot add delta if not using TestBlobRetriever");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new HollowBlobWriter(deltaState).writeDelta((OutputStream)outputStream);
        ((TestBlobRetriever)this.blobRetriever).addDelta(fromVersion, new TestBlob(fromVersion, toVersion, new ByteArrayInputStream(outputStream.toByteArray())));
        return this;
    }

    private HollowReadStateEngine roundTrip(HollowWriteStateEngine writeEngine) throws IOException {
        writeEngine.prepareForWrite();
        HollowBlobWriter writer = new HollowBlobWriter(writeEngine);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.writeSnapshot((OutputStream)baos);
        HollowReadStateEngine readEngine = new HollowReadStateEngine(writeEngine.getHashCodeFinder());
        HollowBlobReader reader = new HollowBlobReader(readEngine);
        reader.readSnapshot(HollowBlobInput.serial((byte[])baos.toByteArray()));
        return readEngine;
    }

    @PublicSpi
    public static class Builder
    extends HollowConsumer.Builder<Builder> {
        protected HollowConsumer.BlobRetriever blobRetriever() {
            return this.blobRetriever;
        }

        public TestHollowConsumer build() {
            this.checkArguments();
            TestHollowConsumer consumer = new TestHollowConsumer(this);
            return consumer;
        }
    }
}

