/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.test;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.util.StateEngineRoundTripper;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.test.HollowWriteStateEngineBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

public class HollowReadStateEngineBuilder {
    private final HollowWriteStateEngineBuilder writeEngineBuilder;

    public HollowReadStateEngineBuilder() {
        this(Collections.emptyList());
    }

    public HollowReadStateEngineBuilder(Collection<Class<?>> types) {
        this.writeEngineBuilder = new HollowWriteStateEngineBuilder(types);
    }

    public HollowReadStateEngineBuilder add(Object ... objects) {
        this.writeEngineBuilder.add(objects);
        return this;
    }

    public HollowReadStateEngine build() {
        HollowWriteStateEngine writeEngine = this.writeEngineBuilder.build();
        HollowReadStateEngine readEngine = new HollowReadStateEngine();
        try {
            StateEngineRoundTripper.roundTripSnapshot((HollowWriteStateEngine)writeEngine, (HollowReadStateEngine)readEngine, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating HollowReadStateEngine", e);
        }
        return readEngine;
    }
}

