/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.test;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.core.read.OptionalBlobPartInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InMemoryBlobStore
implements HollowConsumer.BlobRetriever,
HollowProducer.Publisher {
    private final Set<String> optionalPartsToRetrieve;
    private Map<Long, HollowConsumer.Blob> snapshots = new HashMap<Long, HollowConsumer.Blob>();
    private Map<Long, HollowConsumer.Blob> deltas = new HashMap<Long, HollowConsumer.Blob>();
    private Map<Long, HollowConsumer.Blob> reverseDeltas = new HashMap<Long, HollowConsumer.Blob>();
    private Map<Long, HollowConsumer.HeaderBlob> headers = new HashMap<Long, HollowConsumer.HeaderBlob>();

    public InMemoryBlobStore() {
        this(null);
    }

    public InMemoryBlobStore(Set<String> optionalPartsToRetrieve) {
        this.optionalPartsToRetrieve = optionalPartsToRetrieve;
    }

    private HollowConsumer.Blob getDesiredVersion(long desiredVersion, Map<Long, ? extends HollowConsumer.Blob> map) {
        HollowConsumer.Blob snapshot = map.get(desiredVersion);
        if (snapshot != null) {
            return snapshot;
        }
        long greatestPriorSnapshotVersion = Long.MIN_VALUE;
        for (Map.Entry<Long, ? extends HollowConsumer.Blob> entry : map.entrySet()) {
            if (entry.getKey() <= greatestPriorSnapshotVersion || entry.getKey() >= desiredVersion) continue;
            greatestPriorSnapshotVersion = entry.getKey();
        }
        return map.get(greatestPriorSnapshotVersion);
    }

    public HollowConsumer.Blob retrieveSnapshotBlob(long desiredVersion) {
        return this.getDesiredVersion(desiredVersion, this.snapshots);
    }

    public HollowConsumer.Blob retrieveDeltaBlob(long currentVersion) {
        return this.deltas.get(currentVersion);
    }

    public HollowConsumer.Blob retrieveReverseDeltaBlob(long currentVersion) {
        return this.reverseDeltas.get(currentVersion);
    }

    public HollowConsumer.HeaderBlob retrieveHeaderBlob(long currentVersion) {
        return this.headers.get(currentVersion);
    }

    public void publish(HollowProducer.Blob blob) {
        this.publishBlob(blob);
    }

    public void publish(HollowProducer.PublishArtifact publishArtifact) {
        if (publishArtifact instanceof HollowProducer.HeaderBlob) {
            this.publishHeader((HollowProducer.HeaderBlob)publishArtifact);
        } else {
            this.publishBlob((HollowProducer.Blob)publishArtifact);
        }
    }

    private void publishHeader(final HollowProducer.HeaderBlob headerBlob) {
        HollowConsumer.HeaderBlob consumerBlob = new HollowConsumer.HeaderBlob(headerBlob.getVersion()){

            public InputStream getInputStream() throws IOException {
                return headerBlob.newInputStream();
            }
        };
        this.headers.put(headerBlob.getVersion(), consumerBlob);
    }

    private void publishBlob(final HollowProducer.Blob blob) {
        HollowConsumer.Blob consumerBlob = new HollowConsumer.Blob(blob.getFromVersion(), blob.getToVersion()){

            public InputStream getInputStream() throws IOException {
                return blob.newInputStream();
            }

            public OptionalBlobPartInput getOptionalBlobPartInputs() throws IOException {
                if (blob.getOptionalPartConfig() == null || InMemoryBlobStore.this.optionalPartsToRetrieve == null) {
                    return null;
                }
                OptionalBlobPartInput parts = new OptionalBlobPartInput();
                for (String part : blob.getOptionalPartConfig().getParts()) {
                    if (!InMemoryBlobStore.this.optionalPartsToRetrieve.contains(part)) continue;
                    parts.addInput(part, blob.newOptionalPartInputStream(part));
                }
                if (parts.getPartNames().isEmpty()) {
                    return null;
                }
                return parts;
            }
        };
        switch (blob.getType()) {
            case SNAPSHOT: {
                this.snapshots.put(blob.getToVersion(), consumerBlob);
                break;
            }
            case DELTA: {
                this.deltas.put(blob.getFromVersion(), consumerBlob);
                break;
            }
            case REVERSE_DELTA: {
                this.reverseDeltas.put(blob.getFromVersion(), consumerBlob);
            }
        }
    }

    public void removeSnapshot(long version) {
        this.snapshots.remove(version);
    }
}

