/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.ui;

import java.text.DecimalFormat;

public class HollowDiffUtil {
    private static final String[] HEAP_SIZE_UNITS = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB"};

    public static String formatBytes(long sizeInBytes) {
        if (sizeInBytes == 0L) {
            return "0 B";
        }
        String sign = sizeInBytes < 0L ? "-" : "";
        sizeInBytes = Math.abs(sizeInBytes);
        int digitGroups = (int)(Math.log10(sizeInBytes) / Math.log10(1024.0));
        DecimalFormat formatter = new DecimalFormat("#,##0.##");
        return sign + formatter.format((double)sizeInBytes / Math.pow(1024.0, digitGroups)) + " " + HEAP_SIZE_UNITS[digitGroups];
    }
}

